/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common.tabs;

import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.idea.common.ui.common.VcsTabStatus;
import com.microsoft.alm.plugin.idea.common.ui.common.tabs.TabModel;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.operations.Operation;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class TabLookupListenerImpl
implements Operation.Listener {
    protected final TabModel model;
    protected boolean isContextFound = true;
    private Operation activeOperation;
    protected RepositoryContext repositoryContext;

    public TabLookupListenerImpl(@NotNull TabModel model) {
        this.model = model;
    }

    public abstract void loadData(RepositoryContext var1, Operation.Inputs var2);

    protected void loadData(Operation activeOperation, Operation.Inputs inputs) {
        assert (activeOperation != null);
        if (this.model.getTabStatus() != VcsTabStatus.LOADING_IN_PROGRESS) {
            this.model.clearData();
            this.activeOperation = activeOperation;
            this.activeOperation.addListener((Operation.Listener)this);
            this.activeOperation.doWorkAsync(inputs);
        }
    }

    public void notifyLookupStarted() {
        IdeaHelper.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                TabLookupListenerImpl.this.model.setTabStatus(VcsTabStatus.LOADING_IN_PROGRESS);
            }
        });
    }

    public void notifyLookupCompleted() {
        this.operationDone();
        IdeaHelper.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (TabLookupListenerImpl.this.model.getTabStatus() == VcsTabStatus.LOADING_IN_PROGRESS) {
                    TabLookupListenerImpl.this.model.setTabStatus(VcsTabStatus.LOADING_COMPLETED);
                }
            }
        });
    }

    public void notifyLookupResults(final Operation.Results results) {
        if (results.isCancelled()) {
            this.operationDone();
            IdeaHelper.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    TabLookupListenerImpl.this.model.setTabStatus(VcsTabStatus.LOADING_COMPLETED);
                }
            });
        } else if (results.hasError()) {
            ServerContext newContext;
            if (AuthHelper.isNotAuthorizedError((Throwable)results.getError())) {
                newContext = ServerContextManager.getInstance().updateAuthenticationInfo(this.repositoryContext.getUrl());
            } else if (results.getError() instanceof AssertionError && StringUtils.containsIgnoreCase((String)results.getError().getMessage(), (String)"Microsoft.TeamFoundation.Git.Server.GitRepositoryNotFoundException")) {
                ServerContextManager.getInstance().remove(this.repositoryContext.getUrl());
                newContext = null;
            } else {
                newContext = null;
            }
            IdeaHelper.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (AuthHelper.isNotAuthorizedError((Throwable)results.getError())) {
                        if (newContext != null) {
                            TabLookupListenerImpl.this.model.loadData();
                        } else {
                            TabLookupListenerImpl.this.model.setTabStatus(VcsTabStatus.NO_AUTH_INFO);
                            TabLookupListenerImpl.this.isContextFound = false;
                        }
                    } else {
                        TabLookupListenerImpl.this.model.setTabStatus(VcsTabStatus.LOADING_COMPLETED_ERRORS);
                    }
                }
            });
        } else {
            this.isContextFound = true;
            IdeaHelper.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    TabLookupListenerImpl.this.model.appendData(results);
                }
            });
        }
    }

    protected void operationDone() {
        if (this.activeOperation != null) {
            this.activeOperation.removeListener((Operation.Listener)this);
            this.activeOperation = null;
        }
    }

    public void terminateActiveOperation() {
        if (this.activeOperation != null) {
            this.activeOperation.removeListener((Operation.Listener)this);
            this.activeOperation.cancel();
            this.activeOperation = null;
        }
    }
}

