/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.controls;

import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.ui.common.SwingHelper;
import com.microsoft.alm.plugin.idea.common.ui.controls.Hyperlink;
import com.microsoft.alm.plugin.idea.common.ui.controls.IconPanel;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.apache.commons.lang.StringUtils;

public class HelpPanel
extends JPanel {
    private static final int INITIAL_DELAY = 1000;
    private static final int DISMISS_DELAY = 5000;
    private final JLabel helpLabel;
    private final List<HelpPopupCommand> popupCommands = new ArrayList<HelpPopupCommand>();
    private final List<ActionListener> listeners = new ArrayList<ActionListener>();
    private final Timer showTooltipTimer;
    private final Timer hideTooltipTimer;
    private String popupText;
    private HelpIdeTooltip tip;

    public HelpPanel() {
        this.helpLabel = new JLabel();
        IconPanel helpIcon = new IconPanel(Icons.Help);
        this.setLayout(new GridBagLayout());
        SwingHelper.addToGridBag(this, this.helpLabel, 0, 0, 1, 1, 0, JBUI.scale((int)4));
        SwingHelper.addToGridBag(this, helpIcon, 1, 0);
        this.addMouseListener(new MouseEventListener());
        this.showTooltipTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeaHelper.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        HelpPanel.this.showToolTip(true);
                    }
                });
            }
        });
        this.showTooltipTimer.setInitialDelay(1000);
        this.showTooltipTimer.setRepeats(false);
        this.hideTooltipTimer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeaHelper.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        HelpPanel.this.hideToolTip(true);
                    }
                });
            }
        });
        this.hideTooltipTimer.setInitialDelay(5000);
        this.hideTooltipTimer.setRepeats(false);
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public String getHelpText() {
        return this.helpLabel.getText();
    }

    public void setHelpText(String text) {
        this.helpLabel.setText(text);
    }

    public String getPopupText() {
        return this.popupText;
    }

    public void setPopupText(String popupText) {
        this.popupText = popupText;
    }

    public void addPopupCommand(String text, String command) {
        this.popupCommands.add(new HelpPopupCommand(text, command));
    }

    public void clearPopupCommands() {
        this.popupCommands.clear();
    }

    private void onPopupCommandEvent(String command) {
        this.hideToolTip(true);
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(new ActionEvent(this, 0, command));
        }
    }

    private void toggleToolTip() {
        if (this.tip == null || !this.tip.isShowing()) {
            this.showToolTip(true);
        } else {
            this.hideToolTip(true);
        }
    }

    private void showToolTip(boolean immediately) {
        this.hideTooltipTimer.stop();
        if (this.tip != null && this.tip.isShowing()) {
            return;
        }
        if (this.tip == null) {
            HelpToolTip toolTipPanel = new HelpToolTip(this.popupText, this.popupCommands, this.getWidth());
            this.tip = new HelpIdeTooltip(this, new Point(this.getWidth() / 2, 0), toolTipPanel);
        }
        if (immediately) {
            IdeTooltipManager.getInstance().show((IdeTooltip)this.tip, true);
        } else {
            this.showTooltipTimer.start();
        }
    }

    private void hideToolTip(boolean immediately) {
        this.showTooltipTimer.stop();
        if (this.tip != null) {
            if (immediately) {
                IdeTooltipManager.getInstance().hide((IdeTooltip)this.tip);
            } else {
                this.hideTooltipTimer.start();
            }
        }
    }

    private class MouseEventListener
    implements MouseListener {
        private boolean ignoreNextClick = false;

        private MouseEventListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!this.ignoreNextClick) {
                e.consume();
                HelpPanel.this.toggleToolTip();
                this.ignoreNextClick = true;
            } else {
                this.ignoreNextClick = false;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            HelpPanel.this.showToolTip(false);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            HelpPanel.this.hideToolTip(false);
        }
    }

    private class HelpToolTip
    extends JPanel {
        public HelpToolTip(String wrappingText, List<HelpPopupCommand> popupCommands, int preferredWidth) {
            IdeTooltipManager.setColors((JComponent)this);
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel();
            label.setText("<HTML>" + wrappingText + "</HTML>");
            FontMetrics fm = this.getFontMetrics(label.getFont());
            int preferredHeight = (int)((double)fm.getHeight() * ((double)fm.stringWidth(wrappingText) / (double)(preferredWidth - JBUI.scale((int)20)) + 1.0));
            label.setPreferredSize(new Dimension(preferredWidth, preferredHeight));
            label.setVerticalAlignment(1);
            SwingHelper.addToGridBag(this, label, 0, 0);
            int row = 1;
            for (final HelpPopupCommand popupCommand : popupCommands) {
                if (StringUtils.isEmpty((String)popupCommand.text)) continue;
                Hyperlink hyperlink = new Hyperlink();
                hyperlink.setText(popupCommand.text);
                hyperlink.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HelpPanel.this.onPopupCommandEvent(popupCommand.command);
                    }
                });
                SwingHelper.addToGridBag(this, (Component)((Object)hyperlink), 0, row++, 1, 1, JBUI.scale((int)4), 0);
            }
        }
    }

    private class HelpIdeTooltip
    extends IdeTooltip {
        private boolean showing;

        public HelpIdeTooltip(Component component, Point point, JComponent tipComponent) {
            super(component, point, tipComponent, new Object[0]);
            this.showing = false;
            this.setCalloutShift(JBUI.scale((int)5));
            this.setExplicitClose(true);
            this.setPreferredPosition(Balloon.Position.below);
        }

        public boolean canBeDismissedOnTimeout() {
            return false;
        }

        protected void onHidden() {
            this.showing = false;
            super.onHidden();
        }

        protected boolean beforeShow() {
            this.showing = true;
            return super.beforeShow();
        }

        public boolean isShowing() {
            return this.showing;
        }
    }

    private class HelpPopupCommand {
        private final String text;
        private final String command;

        public HelpPopupCommand(String text, String command) {
            this.text = text;
            this.command = command;
        }
    }
}

