/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.controls;

import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class HintTextFieldUI
extends BasicTextFieldUI
implements FocusListener {
    private final String hintText;

    public HintTextFieldUI(String hint) {
        this.hintText = hint;
    }

    @Override
    protected void paintSafely(Graphics g) {
        super.paintSafely(g);
        JTextComponent component = this.getComponent();
        if (this.hintText != null && component.getText().length() == 0 && !component.hasFocus()) {
            g.setColor((Color)JBColor.GRAY);
            int fontSize = component.getFont().getSize();
            int padding = (component.getHeight() - fontSize) / 2;
            int x = component.getInsets().left;
            int y = component.getHeight() - padding - 1;
            g.drawString(this.hintText, x, y);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getComponent().addFocusListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this);
    }

    private void repaint() {
        if (this.getComponent() != null) {
            this.getComponent().repaint();
        }
    }
}

