/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.controls;

import com.intellij.ui.JBColor;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.microsoft.alm.plugin.idea.common.utils.BackCompatibleUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;

public class Hyperlink
extends LinkLabel<Object> {
    private List<ActionListener> listeners;
    private String actionCommand;

    public Hyperlink() {
        super("Hyperlink", null);
        super.setListener((LinkListener)new LinkListener<Object>(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                Hyperlink.this.notifyActionListeners();
            }
        }, null);
        super.setFocusable(true);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    protected void processComponentKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
            e.consume();
            this.notifyActionListeners();
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        super.repaint();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.hasFocus()) {
            g.setColor((Color)JBColor.black);
            BackCompatibleUtils.paintFocusRing(g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void notifyActionListeners() {
        if (this.listeners == null || this.listeners.size() == 0 || !super.isEnabled()) {
            return;
        }
        ActionEvent event = new ActionEvent((Object)this, 1, this.actionCommand);
        for (ActionListener al : this.listeners) {
            al.actionPerformed(event);
        }
    }

    public void addActionListener(ActionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ActionListener>();
        }
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        this.listeners.remove(listener);
    }
}

