/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.controls;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.controls.FilterDropDown;
import com.microsoft.alm.plugin.idea.common.ui.workitem.WorkItemHelper;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import com.microsoft.alm.plugin.operations.Operation;
import com.microsoft.alm.plugin.operations.WorkItemQueriesLookupOperation;
import com.microsoft.alm.workitemtracking.webapi.models.QueryHierarchyItem;
import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemQueryDropDown
extends FilterDropDown {
    private static final Logger logger = LoggerFactory.getLogger(WorkItemQueryDropDown.class);
    public static final String CMD_QUERY_COMBO_BOX_CHANGED = "cmdQueryComboBoxChanged";
    private final QueryAction defaultQuery;
    private final Project project;
    private final FilterDropDown.LoadingAction loadingAction;
    private final WorkItemQueriesLookupOperation.QueryInputs queryOperationInput;
    private QueryAction selectedQuery;

    public WorkItemQueryDropDown(Project project) {
        this.project = project;
        this.defaultQuery = new QueryAction(TfPluginBundle.message("VcsWorkItemsTab.Query.DefaultQuery", new Object[0]), WorkItemHelper.getAssignedToMeQuery());
        this.loadingAction = new FilterDropDown.LoadingAction();
        this.queryOperationInput = new WorkItemQueriesLookupOperation.QueryInputs(WorkItemQueriesLookupOperation.QueryRootDirectories.MY_QUERIES);
        this.group.add((AnAction)this.defaultQuery, Constraints.FIRST);
        this.group.addSeparator(TfPluginBundle.message("VcsWorkItemsTab.Query.Separator.MyQueries", new Object[0]));
        this.group.add((AnAction)this.loadingAction, Constraints.LAST);
        this.selectedQuery = this.defaultQuery;
        this.initializeUI();
        this.enableDropDown(false);
    }

    protected void initializeUI() {
        super.initializeUI(TfPluginBundle.message("VcsWorkItemsTab.Query.Title", new Object[0]), new JLabel(){

            @Override
            public String getText() {
                return WorkItemQueryDropDown.this.selectedQuery.queryName;
            }
        });
    }

    @Override
    protected void populateDropDownMenu() {
        this.isLoading = true;
        this.group.removeAll();
        this.group.add((AnAction)this.defaultQuery, Constraints.FIRST);
        this.group.addSeparator(TfPluginBundle.message("VcsWorkItemsTab.Query.Separator.MyQueries", new Object[0]));
        this.group.add((AnAction)this.loadingAction, Constraints.LAST);
        this.selectedQuery = this.selectedQuery == null ? this.defaultQuery : this.selectedQuery;
        this.addQueriesFromServer(this.group);
    }

    @Override
    public String getSelectedResults() {
        return this.selectedQuery.wiql;
    }

    private void addQueriesFromServer(final DefaultActionGroup group) {
        final AtomicBoolean isContextFound = new AtomicBoolean(true);
        final RepositoryContext repositoryContext = VcsHelper.getRepositoryContext(this.project);
        WorkItemQueriesLookupOperation operation = new WorkItemQueriesLookupOperation(repositoryContext);
        operation.addListener(new Operation.Listener(){

            public void notifyLookupStarted() {
                logger.info("WorkItemQueriesLookupOperation started.");
            }

            public void notifyLookupCompleted() {
                logger.info("WorkItemQueriesLookupOperation completed and context found: " + isContextFound.get());
                if (isContextFound.get()) {
                    IdeaHelper.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            group.remove((AnAction)WorkItemQueryDropDown.this.loadingAction);
                        }
                    });
                }
                WorkItemQueryDropDown.this.isLoading = false;
            }

            public void notifyLookupResults(Operation.Results results) {
                final WorkItemQueriesLookupOperation.QueryResults wiResults = (WorkItemQueriesLookupOperation.QueryResults)results;
                if (wiResults.isCancelled()) {
                    logger.info("WorkItemQueriesLookupOperation was cancelled");
                } else {
                    ServerContext newContext;
                    if (wiResults.hasError() && AuthHelper.isNotAuthorizedError((Throwable)wiResults.getError())) {
                        isContextFound.set(false);
                        newContext = ServerContextManager.getInstance().createContextFromGitRemoteUrl(repositoryContext.getUrl(), false);
                    } else {
                        newContext = null;
                    }
                    IdeaHelper.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (wiResults.hasError()) {
                                if (AuthHelper.isNotAuthorizedError((Throwable)wiResults.getError())) {
                                    logger.warn("WorkItemQueriesLookupOperation failed due to auth error");
                                    if (newContext != null) {
                                        isContextFound.set(true);
                                        WorkItemQueryDropDown.this.addQueriesFromServer(group);
                                    } else {
                                        logger.info("WorkItemQueriesLookupOperation was cancelled");
                                    }
                                } else {
                                    IdeaHelper.showErrorDialog(WorkItemQueryDropDown.this.project, wiResults.getError());
                                }
                            }
                            for (QueryHierarchyItem item : wiResults.getQueries()) {
                                group.add((AnAction)new QueryAction(item.getName(), item.getWiql()));
                            }
                        }
                    });
                }
            }
        });
        operation.doWorkAsync((Operation.Inputs)this.queryOperationInput);
    }

    protected class QueryAction
    extends DumbAwareAction {
        private final String queryName;
        private final String wiql;

        public QueryAction(String queryName, String wiql) {
            super(queryName);
            this.queryName = queryName;
            this.wiql = wiql;
            this.getTemplatePresentation().setText(queryName, false);
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            if (!((Object)((Object)this)).equals((Object)WorkItemQueryDropDown.this.selectedQuery)) {
                WorkItemQueryDropDown.this.selectedQuery = this;
                WorkItemQueryDropDown.this.pickerLabel.revalidate();
                WorkItemQueryDropDown.this.pickerLabel.repaint();
                if (WorkItemQueryDropDown.this.listener != null) {
                    WorkItemQueryDropDown.this.listener.actionPerformed(new ActionEvent((Object)this, 0, WorkItemQueryDropDown.CMD_QUERY_COMBO_BOX_CHANGED));
                }
            }
        }
    }
}

