/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.settings;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.plugin.authentication.AuthTypes;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextTableModel;
import com.microsoft.alm.plugin.idea.common.ui.common.SwingHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.TableFocusListener;
import com.microsoft.alm.plugin.idea.common.ui.common.TableModelSelectionConverter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableRowSorter;

public class TeamServicesSettingsForm {
    public static final String CMD_DELETE_PASSWORD = "deletePassword";
    public static final String CMD_UPDATE_PASSWORD = "updatePasword";
    public static final String CMD_AUTH_CHANGED = "authChanged";
    private JPanel mainPanel;
    private JButton updatePasswordButton;
    private JPanel passwordPanel;
    private JTable contextTable;
    private JScrollPane contextScrollPane;
    private JButton deletePasswordButton;
    private JRadioButton credsOption;
    private JRadioButton deviceFlowOption;
    private JPanel authTypePanel;

    public TeamServicesSettingsForm() {
        this.$$$setupUI$$$();
        SwingHelper.scaleTableRowHeight(this.contextTable);
        SwingHelper.fixTabKeys(this.contextTable);
        this.contextTable.addFocusListener(new TableFocusListener(this.contextTable));
        this.contextScrollPane.setMinimumSize(new Dimension(JBUI.scale((int)200), JBUI.scale((int)50)));
        this.updatePasswordButton.setActionCommand(CMD_UPDATE_PASSWORD);
        this.deletePasswordButton.setActionCommand(CMD_DELETE_PASSWORD);
        this.credsOption.setActionCommand(CMD_AUTH_CHANGED);
        this.deviceFlowOption.setActionCommand(CMD_AUTH_CHANGED);
    }

    public JComponent getContentPane() {
        return this.mainPanel;
    }

    public void setContextTable(ServerContextTableModel tableModel, ListSelectionModel selectionModel) {
        this.contextTable.setModel(tableModel);
        this.contextTable.setSelectionModel(selectionModel);
        TableRowSorter<ServerContextTableModel> sorter = new TableRowSorter<ServerContextTableModel>(tableModel);
        this.contextTable.setRowSorter(sorter);
        tableModel.setSelectionConverter(new TableModelSelectionConverter(){

            @Override
            public int convertRowIndexToModel(int viewRowIndex) {
                if (viewRowIndex >= 0) {
                    return TeamServicesSettingsForm.this.contextTable.convertRowIndexToModel(viewRowIndex);
                }
                return viewRowIndex;
            }
        });
    }

    public void setAuthType(AuthTypes authType) {
        if (AuthTypes.DEVICE_FLOW == authType) {
            this.credsOption.setSelected(false);
            this.deviceFlowOption.setSelected(true);
        } else {
            this.credsOption.setSelected(true);
            this.deviceFlowOption.setSelected(false);
        }
    }

    public AuthTypes getSelectAuthType() {
        if (this.deviceFlowOption.isSelected()) {
            return AuthTypes.DEVICE_FLOW;
        }
        return AuthTypes.CREDS;
    }

    public void addActionListener(ActionListener listener) {
        this.deletePasswordButton.addActionListener(listener);
        this.updatePasswordButton.addActionListener(listener);
        this.deviceFlowOption.addActionListener(listener);
        this.credsOption.addActionListener(listener);
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.passwordPanel = new JPanel();
        this.passwordPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1));
        this.mainPanel.add((Component)this.passwordPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        this.passwordPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Config.Mgt.Title")));
        this.contextScrollPane = new JScrollPane();
        this.passwordPanel.add((Component)this.contextScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.contextTable = new JTable();
        this.contextTable.setPreferredScrollableViewportSize(new Dimension(450, 150));
        this.contextScrollPane.setViewportView(this.contextTable);
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.passwordPanel.add((Component)panel1, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.deletePasswordButton = new JButton();
        this.$$$loadButtonText$$$(this.deletePasswordButton, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Config.Mgt.DeleteButton"));
        panel1.add((Component)this.deletePasswordButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.updatePasswordButton = new JButton();
        this.$$$loadButtonText$$$(this.updatePasswordButton, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Config.Mgt.UpdateButton"));
        panel1.add((Component)this.updatePasswordButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.authTypePanel = new JPanel();
        this.authTypePanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(5, 5, 5, 5), -1, -1));
        this.mainPanel.add((Component)this.authTypePanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        this.authTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Auth.Method.Title")));
        this.credsOption = new JRadioButton();
        this.credsOption.setEnabled(true);
        this.credsOption.setSelected(true);
        this.$$$loadButtonText$$$(this.credsOption, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Auth.Method.Creds.Button"));
        this.credsOption.setToolTipText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Auth.Method.Creds.ToolTip"));
        this.authTypePanel.add((Component)this.credsOption, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2, false));
        this.deviceFlowOption = new JRadioButton();
        this.$$$loadButtonText$$$(this.deviceFlowOption, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Auth.Method.DeviceFlow.Button"));
        this.deviceFlowOption.setToolTipText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("Settings.Auth.Method.DeviceFlow.ToolTip"));
        this.authTypePanel.add((Component)this.deviceFlowOption, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 2, false));
        Spacer spacer2 = new Spacer();
        this.authTypePanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        this.mainPanel.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.deviceFlowOption);
        buttonGroup.add(this.credsOption);
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

