/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.settings;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.authentication.AuthTypes;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.AbstractModel;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextTableModel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ListSelectionModel;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamServicesSettingsModel
extends AbstractModel {
    private static final Logger logger = LoggerFactory.getLogger(TeamServicesSettingsModel.class);
    private final Project project;
    private final ServerContextTableModel tableModel;
    private final List<ServerContext> deleteContexts;
    private AuthTypes updatedAuthType;
    private AuthTypes originalAuthType;

    public TeamServicesSettingsModel(Project project) {
        ArgumentHelper.checkNotNull((Object)project, (String)"project");
        this.project = project;
        this.tableModel = new ServerContextTableModel(ServerContextTableModel.GENERAL_COLUMNS, 2);
        this.deleteContexts = new ArrayList<ServerContext>();
    }

    public boolean isModified() {
        return !this.deleteContexts.isEmpty() || this.originalAuthType != this.updatedAuthType;
    }

    public void loadSettings() {
        this.loadAuthMethod();
        this.populateContextTable();
    }

    private void loadAuthMethod() {
        String savedAuthMethod = AuthHelper.getAuthTypeInSettingsFile();
        this.updatedAuthType = this.originalAuthType = StringUtils.isNotEmpty((String)savedAuthMethod) ? AuthTypes.getEnum((String)savedAuthMethod.toUpperCase()) : AuthTypes.CREDS;
    }

    private void populateContextTable() {
        ArrayList serverContexts = new ArrayList(ServerContextManager.getInstance().getAllServerContexts());
        Hashtable<String, ServerContext> contextTable = new Hashtable<String, ServerContext>(serverContexts.size());
        for (ServerContext context : serverContexts) {
            String accountUrl;
            String key;
            String repoName;
            if (context.getGitRepository() != null && context.getGitRepository().getName() != null) {
                repoName = context.getGitRepository().getName();
            } else {
                if (context.getTeamProjectReference() == null || context.getTeamProjectReference().getName() == null) continue;
                repoName = context.getTeamProjectReference().getName();
            }
            if (context.getUri().toString().equals("http://_TFS_LAST_USED_URL_") || contextTable.containsKey(key = repoName.concat(accountUrl = context.getUri().toString()).toLowerCase()) || this.deleteContexts.contains(context)) continue;
            contextTable.put(key, context);
        }
        this.tableModel.clearRows();
        this.tableModel.addServerContexts(new ArrayList<ServerContext>(contextTable.values()));
    }

    public void apply() {
        for (ServerContext context : this.deleteContexts) {
            ServerContextManager.getInstance().remove(context.getKey());
        }
        this.deleteContexts.clear();
        if (this.originalAuthType != this.updatedAuthType) {
            AuthHelper.setAuthTypeInSettingsFile((AuthTypes)this.updatedAuthType);
            this.originalAuthType = this.updatedAuthType;
            if (this.updatedAuthType == AuthTypes.DEVICE_FLOW) {
                AuthHelper.setDeviceFlowEnvVariableTrue();
            } else {
                AuthHelper.setDeviceFlowEnvVariableFalse();
            }
        }
    }

    public void reset() {
        this.deleteContexts.clear();
        this.populateContextTable();
        this.updatedAuthType = this.originalAuthType;
    }

    public void deletePasswords() {
        ListSelectionModel selectionModel = this.getTableSelectionModel();
        if (!selectionModel.isSelectionEmpty()) {
            if (Messages.showYesNoDialog((Project)this.project, (String)TfPluginBundle.message("Settings.Config.Mgt.Delete.Msg", new Object[0]), (String)TfPluginBundle.message("Settings.Config.Mgt.Delete.Title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                this.deleteContexts.addAll(this.tableModel.getSelectedContexts());
                this.populateContextTable();
            }
        } else {
            Messages.showWarningDialog((Project)this.project, (String)TfPluginBundle.message("Settings.Config.Mgt.NoRowsSelected", new Object[0]), (String)TfPluginBundle.message("Settings.Config.Mgt.Delete.Title", new Object[0]));
        }
    }

    public void updatePasswords() {
        ListSelectionModel selectionModel = this.getTableSelectionModel();
        if (!selectionModel.isSelectionEmpty()) {
            if (Messages.showYesNoDialog((Project)this.project, (String)TfPluginBundle.message("Settings.Config.Mgt.Update.Msg", new Object[0]), (String)TfPluginBundle.message("Settings.Config.Mgt.Update.Title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                final List<ServerContext> contexts = this.tableModel.getSelectedContexts();
                Task.Backgroundable updateAuthTask = new Task.Backgroundable(this.project, TfPluginBundle.message("Settings.Config.Mgt.Updating", new Object[0])){

                    public void run(ProgressIndicator indicator) {
                        logger.info("Updating passwords for user. Selected: " + contexts.size());
                        ServerContextManager.getInstance().updateServerContextsAuthInfo(contexts);
                        TeamServicesSettingsModel.this.populateContextTable();
                    }
                };
                updateAuthTask.queue();
            }
        } else {
            Messages.showWarningDialog((Project)this.project, (String)TfPluginBundle.message("Settings.Config.Mgt.NoRowsSelected", new Object[0]), (String)TfPluginBundle.message("Settings.Config.Mgt.Update.Title", new Object[0]));
        }
    }

    public ServerContextTableModel getTableModel() {
        return this.tableModel;
    }

    public AuthTypes getOriginalAuthType() {
        return this.originalAuthType;
    }

    public void setUpdatedAuthType(AuthTypes updatedAuthType) {
        this.updatedAuthType = updatedAuthType;
    }

    public ListSelectionModel getTableSelectionModel() {
        return this.tableModel.getSelectionModel();
    }

    @VisibleForTesting
    protected List<ServerContext> getDeleteContexts() {
        return this.deleteContexts;
    }

    @VisibleForTesting
    protected void setDeleteContexts(List<ServerContext> deleteContexts) {
        this.deleteContexts.clear();
        this.deleteContexts.addAll(deleteContexts);
    }
}

