/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.workitem;

import com.intellij.openapi.project.Project;
import com.microsoft.alm.plugin.idea.common.ui.common.AbstractController;
import com.microsoft.alm.plugin.idea.common.ui.workitem.SelectWorkItemsForm;
import com.microsoft.alm.plugin.idea.common.ui.workitem.SelectWorkItemsModel;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import java.awt.event.ActionEvent;
import java.util.Observable;
import javax.swing.JPanel;

public class SelectWorkItemsController
extends AbstractController {
    private final SelectWorkItemsModel model;
    private final SelectWorkItemsForm form;

    public SelectWorkItemsController(Project project) {
        this.model = new SelectWorkItemsModel(project, VcsHelper.getRepositoryContext(project));
        this.form = new SelectWorkItemsForm();
        this.model.addObserver(this);
        this.form.addActionListener(this);
        this.update(null, null);
        this.model.loadWorkItems();
    }

    public JPanel getContentPanel() {
        return this.form.getContentPanel();
    }

    public String getComment() {
        return this.model.getComment();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == null || arg.equals("loading")) {
            this.form.setLoading(this.model.isLoading());
            this.form.setShowHelpPanel(!this.model.isLoading() && this.model.isMaxItemsReached());
        }
        if (arg == null || arg.equals("filter")) {
            this.form.setFilter(this.model.getFilter());
        }
        if (arg == null || arg.equals("serverName")) {
            this.form.setServerName(this.model.getServerName());
        }
        if (arg == null) {
            this.form.setWorkItemTable(this.model.getTableModel(), this.model.getTableSelectionModel());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModel();
        if ("refresh".equals(e.getActionCommand())) {
            this.model.loadWorkItems();
        } else if (!"filterChanged".equals(e.getActionCommand())) {
            if ("newWorkItem".equals(e.getActionCommand())) {
                this.model.createWorkItem();
            } else if ("gotoViewMyWorkItems".equals(e.getActionCommand())) {
                this.model.gotoMyWorkItems();
            }
        }
    }

    @Override
    protected void updateModel() {
        this.model.setFilter(this.form.getFilter());
    }
}

