/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.workitem;

import com.microsoft.alm.common.utils.SystemHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.FilteredModel;
import com.microsoft.alm.plugin.idea.common.ui.common.TableModelSelectionConverter;
import com.microsoft.alm.plugin.idea.common.ui.workitem.WorkItemHelper;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItem;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import jersey.repackaged.com.google.common.base.Predicate;
import jersey.repackaged.com.google.common.collect.Collections2;
import jersey.repackaged.com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;

public class WorkItemsTableModel
extends AbstractTableModel
implements FilteredModel {
    public static final Column[] ALL_COLUMNS = new Column[]{Column.ID, Column.TYPE, Column.TITLE, Column.STATE, Column.ASSIGNED_TO, Column.BRANCH};
    public static final Column[] DEFAULT_COLUMNS = new Column[]{Column.ID, Column.TYPE, Column.STATE, Column.TITLE};
    public static final Column[] COLUMNS_PLUS_BRANCH = new Column[]{Column.ID, Column.TYPE, Column.STATE, Column.BRANCH, Column.TITLE};
    private static final TableModelSelectionConverter DEFAULT_CONVERTER = new TableModelSelectionConverter(){

        @Override
        public int convertRowIndexToModel(int viewRowIndex) {
            return viewRowIndex;
        }
    };
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private List<WorkItem> rows = new ArrayList<WorkItem>(100);
    private List<WorkItem> filteredRows = null;
    private String filter;
    private final Column[] columns;
    private TableModelSelectionConverter converter;

    public WorkItemsTableModel(Column[] columns) {
        assert (columns != null);
        this.columns = (Column[])columns.clone();
        this.selectionModel.setSelectionMode(2);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public WorkItem getWorkItem(int rowIndex) {
        List<WorkItem> localRows = this.filteredRows != null ? this.filteredRows : this.rows;
        if (rowIndex >= 0 && rowIndex < localRows.size()) {
            return localRows.get(rowIndex);
        }
        return null;
    }

    public void addWorkItems(List<WorkItem> workItems) {
        this.rows.addAll(workItems);
        if (this.hasFilter()) {
            this.applyFilter();
        } else {
            super.fireTableDataChanged();
        }
    }

    public void setSelectionConverter(TableModelSelectionConverter converter) {
        this.converter = converter;
    }

    public TableModelSelectionConverter getSelectionConverter() {
        if (this.converter == null) {
            return DEFAULT_CONVERTER;
        }
        return this.converter;
    }

    public List<WorkItem> getSelectedWorkItems() {
        ArrayList<WorkItem> items = new ArrayList<WorkItem>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getSelectionModel().isSelectedIndex(i)) continue;
            int modelIndex = this.getSelectionConverter().convertRowIndexToModel(i);
            items.add(this.getWorkItem(modelIndex));
        }
        return items;
    }

    public void clearRows() {
        this.filteredRows = null;
        this.rows.clear();
        super.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.filteredRows != null) {
            return this.filteredRows.size();
        }
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        WorkItem item = this.getWorkItem(rowIndex);
        String val = this.getValueFor(item, columnIndex);
        if (this.getColumnClass(columnIndex) == Integer.class) {
            return SystemHelper.toInt((String)val, (int)0);
        }
        return val;
    }

    private String getValueFor(WorkItem item, int columnIndex) {
        if (item == null) {
            return "";
        }
        Column column = this.columns[columnIndex];
        switch (column) {
            case ID: {
                return WorkItemHelper.getFieldValue(item, "System.Id");
            }
            case TYPE: {
                return WorkItemHelper.getFieldValue(item, "System.WorkItemType");
            }
            case STATE: {
                return WorkItemHelper.getFieldValue(item, "System.State");
            }
            case TITLE: {
                return WorkItemHelper.getFieldValue(item, "System.Title");
            }
            case ASSIGNED_TO: {
                return WorkItemHelper.getFieldValue(item, "System.AssignedTo");
            }
            case BRANCH: {
                return WorkItemHelper.getBranchName(item);
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int columnIndex) {
        Column column = this.columns[columnIndex];
        switch (column) {
            case ID: {
                return WorkItemHelper.getLocalizedFieldName("System.Id");
            }
            case TYPE: {
                return WorkItemHelper.getLocalizedFieldName("System.WorkItemType");
            }
            case TITLE: {
                return WorkItemHelper.getLocalizedFieldName("System.Title");
            }
            case STATE: {
                return WorkItemHelper.getLocalizedFieldName("System.State");
            }
            case ASSIGNED_TO: {
                return WorkItemHelper.getLocalizedFieldName("System.AssignedTo");
            }
            case BRANCH: {
                return WorkItemHelper.getLocalizedFieldName("branch");
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == Column.ID.ordinal()) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    public boolean hasFilter() {
        return StringUtils.isNotEmpty((String)this.filter);
    }

    @Override
    public void setFilter(String filter) {
        this.filter = filter;
        this.applyFilter();
    }

    private void applyFilter() {
        this.filteredRows = !this.hasFilter() ? null : Lists.newArrayList((Iterable)Collections2.filter(this.rows, (Predicate)new Predicate<WorkItem>(){

            public boolean apply(WorkItem item) {
                return WorkItemsTableModel.this.rowContains(item);
            }
        }));
        super.fireTableDataChanged();
    }

    private boolean rowContains(WorkItem item) {
        for (int c = 0; c < this.columns.length; ++c) {
            if (!StringUtils.containsIgnoreCase((String)this.getValueFor(item, c), (String)this.filter)) continue;
            return true;
        }
        return false;
    }

    public static enum Column {
        ID,
        TYPE,
        TITLE,
        ASSIGNED_TO,
        STATE,
        BRANCH;

    }
}

