/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.utils;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.util.net.HttpConfigurable;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackCompatibleUtils {
    private static final Logger logger = LoggerFactory.getLogger(BackCompatibleUtils.class);
    private static final String PROXY_LOGIN_METHOD = "getProxyLogin";
    private static final String PROXY_LOGIN_FIELD = "PROXY_LOGIN";

    public static String getProxyLogin() {
        try {
            Method proxyLoginMethod = HttpConfigurable.getInstance().getClass().getDeclaredMethod(PROXY_LOGIN_METHOD, new Class[0]);
            return (String)proxyLoginMethod.invoke((Object)HttpConfigurable.getInstance(), null);
        }
        catch (Exception newImplementationException) {
            try {
                logger.warn("Failed to get proxy login using getProxyLogin() so attempting old way", (Throwable)newImplementationException);
                Field proxyLoginField = HttpConfigurable.getInstance().getClass().getDeclaredField(PROXY_LOGIN_FIELD);
                return (String)proxyLoginField.get(HttpConfigurable.getInstance());
            }
            catch (Exception oldImplementationException) {
                logger.warn("Failed to get proxy login using PROXY_LOGIN field", (Throwable)oldImplementationException);
                return "";
            }
        }
    }

    public static void paintFocusRing(Graphics g, int x, int y, int width, int height) {
        try {
            Method paintFocusRingMethodNew = DarculaUIUtil.class.getDeclaredMethod("paintFocusRing", Graphics.class, Rectangle.class);
            paintFocusRingMethodNew.invoke(null, g, new Rectangle(x, y, width, height));
        }
        catch (Exception newImplementationException) {
            try {
                logger.warn("Failed to get DarculaUIUtil.paintFocusRing() new implementation so attempting old way", (Throwable)newImplementationException);
                Method paintFocusRingMethodOld = DarculaUIUtil.class.getDeclaredMethod("paintFocusRing", Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                paintFocusRingMethodOld.invoke(null, g, x, y, width, height);
            }
            catch (Exception oldImplementationException) {
                logger.warn("Failed to find DarculaUIUtil.paintFocusRing() method", (Throwable)oldImplementationException);
            }
        }
    }
}

