/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.utils;

import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateHelper {
    private static final Logger logger = LoggerFactory.getLogger(DateHelper.class);

    public static String getFriendlyDateTimeString(Date date) {
        Date now = new Date();
        return DateHelper.getFriendlyDateTimeString(date, now);
    }

    protected static String getFriendlyDateTimeString(Date date, Date now) {
        if (date == null) {
            return "";
        }
        try {
            long diff = now.getTime() - date.getTime();
            if (diff < 0L) {
                return date.toString();
            }
            long diffMinutes = diff / 60000L;
            if (diffMinutes < 1L) {
                return TfPluginBundle.message("VcsPullRequestsTab.Date.LessThanAMinuteAgo", new Object[0]);
            }
            if (diffMinutes == 1L) {
                return TfPluginBundle.message("VcsPullRequestsTab.Date.OneMinuteAgo", new Object[0]);
            }
            if (diffMinutes < 60L) {
                return TfPluginBundle.message("VcsPullRequestsTab.Date.MinutesAgo", diffMinutes);
            }
            long diffHours = diff / 3600000L;
            if (diffHours <= 1L) {
                return TfPluginBundle.message("VcsPullRequestsTab.Date.OneHourAgo", new Object[0]);
            }
            if (diffHours <= 24L) {
                return TfPluginBundle.message("VcsPullRequestsTab.Date.HoursAgo", diffHours);
            }
            long diffDays = diff / 86400000L;
            if (diffDays <= 2L) {
                return TfPluginBundle.message("VcsPullRequestsTab.Date.Yesterday", new Object[0]);
            }
            if (diffDays < 7L) {
                return TfPluginBundle.message("VcsPullRequestsTab.Date.DaysAgo", diffDays);
            }
            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
            return format.format(date);
        }
        catch (Throwable t) {
            logger.warn("getFriendlyDateTimeString unexpected error with input date {}", (Object)date.toString(), (Object)t);
            return date.toString();
        }
    }
}

