/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.context.RepositoryContextManager;
import com.microsoft.alm.plugin.external.commands.FindWorkspaceCommand;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.idea.git.utils.TfGitHelper;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcsHelper {
    private static final Logger logger = LoggerFactory.getLogger(VcsHelper.class);
    public static final String GIT_BRANCH_PREFIX = "refs/heads/";
    public static final String TFVC_ROOT = "$/";
    public static final String TFVC_SEPARATOR = "/";
    private static final String UNKNOWN = "Unknown";
    private static Pattern pattern = null;

    public static boolean isGitVcs(Project project) {
        ArgumentHelper.checkNotNull((Object)project, (String)"project");
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        return projectLevelVcsManager.checkVcsIsActive("Git");
    }

    public static boolean isTfVcs(Project project) {
        ArgumentHelper.checkNotNull((Object)project, (String)"project");
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        return projectLevelVcsManager.checkVcsIsActive("TFVC");
    }

    public static String getVcsType(Project project) {
        ArgumentHelper.checkNotNull((Object)project, (String)"project");
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        AbstractVcs vcs = projectLevelVcsManager.getVcsFor(project.getBaseDir());
        return vcs != null && StringUtils.isNotEmpty((String)vcs.getName()) ? vcs.getName() : UNKNOWN;
    }

    public static boolean isVstsRepo(Project project) {
        if (project != null) {
            if (VcsHelper.isTfVcs(project)) {
                return true;
            }
            if (!VcsHelper.isGitVcs(project)) {
                return false;
            }
            GitRepository repo = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForFile(project.getBaseDir());
            return repo != null && TfGitHelper.isTfGitRepository(repo);
        }
        return false;
    }

    public static GitRepository getGitRepository(Project project) {
        if (VcsHelper.isGitVcs(project)) {
            GitRepositoryManager manager = GitUtil.getRepositoryManager((Project)project);
            GitRepository repository = (GitRepository)manager.getRepositoryForRoot(project.getBaseDir());
            if (repository == null) {
                List repos = manager.getRepositories();
                if (repos.size() > 0) {
                    repository = (GitRepository)repos.get(0);
                    if (repos.size() > 1) {
                        logger.warn("More than 1 Git repo was found. Defaulting to the first returned: " + repository.getRoot().getPath());
                    }
                } else {
                    logger.warn("We are in a Git project that does not have any Git repos. (We may be asking too early.)");
                }
            }
            return repository;
        }
        return null;
    }

    public static RepositoryContext getRepositoryContext(Project project) {
        ArgumentHelper.checkNotNull((Object)project, (String)"project");
        try {
            FindWorkspaceCommand command;
            Workspace workspace;
            String projectRootFolder = project.getBasePath();
            RepositoryContext context = RepositoryContextManager.getInstance().get(projectRootFolder);
            if (context != null) {
                logger.info("getRepositoryContext: cache hit: " + projectRootFolder);
                return context;
            }
            logger.info("getRepositoryContext: cache miss: " + projectRootFolder);
            ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
            if (projectLevelVcsManager.checkVcsIsActive("Git")) {
                GitRepository repository = VcsHelper.getGitRepository(project);
                if (repository != null && TfGitHelper.isTfGitRepository(repository)) {
                    GitRemote gitRemote = TfGitHelper.getTfGitRemote(repository);
                    String gitRemoteUrl = gitRemote.getFirstUrl();
                    String branch = GIT_BRANCH_PREFIX + GitBranchUtil.getDisplayableBranchText((GitRepository)repository);
                    context = RepositoryContext.createGitContext((String)projectRootFolder, (String)repository.getRoot().getName(), (String)branch, (String)gitRemoteUrl);
                }
            } else if (projectLevelVcsManager.checkVcsIsActive("TFVC") && (workspace = (Workspace)(command = new FindWorkspaceCommand(projectRootFolder)).runSynchronously()) != null) {
                String projectName = VcsHelper.getTeamProjectFromTfvcServerPath(workspace.getMappings().size() > 0 ? ((Workspace.Mapping)workspace.getMappings().get(0)).getServerPath() : null);
                context = RepositoryContext.createTfvcContext((String)projectRootFolder, (String)workspace.getName(), (String)projectName, (String)workspace.getServer());
            }
            if (context != null) {
                RepositoryContextManager.getInstance().add(context);
                return context;
            }
        }
        catch (Throwable t) {
            logger.warn("Unable to get repository context for the project.", t);
        }
        logger.info("getRepositoryContext: We couldn't determine the VCS provider, so returning null.");
        return null;
    }

    public static String getTeamProjectFromTfvcServerPath(String serverPath) {
        if (StringUtils.isNotEmpty((String)serverPath) && StringUtils.startsWith((String)serverPath, (String)TFVC_ROOT) && serverPath.length() > 2) {
            int index = serverPath.indexOf(TFVC_SEPARATOR, 2);
            if (index >= 0) {
                return serverPath.substring(2, index);
            }
            return serverPath.substring(2);
        }
        logger.info("getTeamProjectFromTfvcServerPath: No project was found.");
        return "";
    }

    public static List<Integer> getWorkItemIdsFromMessage(String commitMessage) {
        logger.info("getWorkItemIdsFromMessage: commitMessage = " + commitMessage);
        ArrayList<Integer> workItems = new ArrayList<Integer>(10);
        if (pattern == null) {
            pattern = Pattern.compile("#(\\d+)");
        }
        Matcher matcher = pattern.matcher(commitMessage);
        while (matcher.find()) {
            try {
                int workItemId = Integer.parseInt(StringUtils.removeStart((String)matcher.group(), (String)"#"));
                workItems.add(workItemId);
            }
            catch (NumberFormatException e) {
                logger.warn("Error converting work item id into integer: " + matcher.group(1));
            }
        }
        return workItems;
    }
}

