/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.microsoft.alm.plugin.idea.common.actions.InstrumentedAction;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportController;
import git4idea.actions.BasicAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportAction
extends InstrumentedAction {
    private static final Logger logger = LoggerFactory.getLogger(ImportAction.class);

    public ImportAction() {
        super(TfPluginBundle.message("Actions.Import.Title", new Object[0]), TfPluginBundle.message("Actions.Import.Message", new Object[0]), Icons.VSLogoSmall);
    }

    @Override
    public void doUpdate(AnActionEvent anActionEvent) {
        Project project = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            anActionEvent.getPresentation().setVisible(false);
            anActionEvent.getPresentation().setEnabled(false);
            return;
        }
        anActionEvent.getPresentation().setVisible(true);
        anActionEvent.getPresentation().setEnabled(true);
    }

    @Override
    public void doActionPerformed(AnActionEvent anActionEvent) {
        Project project = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDisposed()) {
            return;
        }
        BasicAction.saveAll();
        try {
            ImportController controller = new ImportController(project);
            controller.showModalDialog();
        }
        catch (Throwable t) {
            logger.warn("ImportAction doActionPerformed failed unexpected error", t);
            VcsNotifier.getInstance((Project)project).notifyError(TfPluginBundle.message("Actions.Import.Title", new Object[0]), TfPluginBundle.message("Import.Errors.Unexpected", t.getMessage()));
        }
    }
}

