/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.extensions;

import com.intellij.util.AuthData;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.authentication.AuthenticationProvider;
import com.microsoft.alm.plugin.authentication.VsoAuthenticationProvider;
import com.microsoft.alm.plugin.context.ServerContextManager;
import git4idea.remote.GitHttpAuthDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfGitHttpAuthDataProvider
implements GitHttpAuthDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(TfGitHttpAuthDataProvider.class);

    public AuthData getAuthData(String url) {
        assert (url != null);
        AuthenticationInfo authenticationInfo = ServerContextManager.getInstance().getBestAuthenticationInfo(url, false);
        if (authenticationInfo != null) {
            return new AuthData(authenticationInfo.getUserName(), authenticationInfo.getPassword());
        }
        logger.debug("getAuthData: Couldn't find authentication info from saved contexts.");
        if (UrlHelper.isTeamServicesUrl((String)url)) {
            String authUrl = UrlHelper.getHttpsUrlFromHttpUrl((String)url);
            if (authUrl != null) {
                AuthenticationInfo vsoAuthenticationInfo = AuthHelper.getAuthenticationInfoSynchronously((AuthenticationProvider)VsoAuthenticationProvider.getInstance(), (String)authUrl);
                if (vsoAuthenticationInfo == null) {
                    return new AuthData("", "");
                }
                return new AuthData(vsoAuthenticationInfo.getUserName(), vsoAuthenticationInfo.getPassword());
            }
            logger.warn("getAuthData: Unable to get https team services url for input url = " + url);
        }
        return null;
    }

    public void forgetPassword(String url) {
        assert (url != null);
        if (UrlHelper.isTeamServicesUrl((String)url)) {
            String authUrl = UrlHelper.getHttpsUrlFromHttpUrl((String)url);
            if (authUrl != null) {
                ServerContextManager.getInstance().updateAuthenticationInfo(authUrl);
            } else {
                logger.warn("forgetPassword: Unable to get https team services url for input url = " + url);
            }
        } else {
            logger.warn("forgetPassword: If server is https:// user might see multiple prompts for entering password resulting in all failures.");
            ServerContextManager.getInstance().updateAuthenticationInfo(url);
        }
    }
}

