/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.ui.common.ValidationListener;
import com.microsoft.alm.plugin.idea.git.ui.branch.CreateBranchDialog;
import com.microsoft.alm.plugin.idea.git.ui.branch.CreateBranchModel;
import git4idea.repo.GitRepository;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBranchController
implements Observer,
ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(CreateBranchController.class);
    private final CreateBranchDialog dialog;
    private final CreateBranchModel model;

    public CreateBranchController(Project project, String defaultBranchName, GitRepository gitRepository) {
        this(new CreateBranchDialog(project, TfPluginBundle.message("CreateBranchDialog.Title", new Object[0]), TfPluginBundle.message("CreateBranchDialog.CreateButton", new Object[0]), "CreateBranchDialog.Title"), new CreateBranchModel(project, defaultBranchName, gitRepository));
    }

    public CreateBranchController(CreateBranchDialog dialog, CreateBranchModel model) {
        this.dialog = dialog;
        this.dialog.addActionListener(this);
        this.model = model;
        this.model.addObserver(this);
        this.setupDialog();
        this.update(null, null);
    }

    private void setupDialog() {
        this.dialog.addValidationListener(new ValidationListener(){

            @Override
            public ValidationInfo doValidate() {
                return CreateBranchController.this.validate();
            }
        });
    }

    public boolean showModalDialog() {
        logger.info("CreateBranchController is showing dialog");
        return this.dialog.showModalDialog();
    }

    public String getBranchName() {
        return this.model.getBranchName();
    }

    public boolean createBranch(ServerContext context) {
        this.model.doBranchCreate(context, null);
        return this.model.getBranchWasCreated();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModel();
        if ("ok".equals(e.getActionCommand())) {
            logger.info("CreateBranchController create action completed so valid branch name was input");
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == null || "branchName".equals(arg)) {
            this.dialog.setBranchName(this.model.getBranchName());
        }
        if (arg == null || "checkoutBranch".equals(arg)) {
            this.dialog.setCheckoutBranch(this.model.getCheckoutBranch());
        }
        if (arg == null || "remoteBranchComboModel".equals(arg)) {
            this.dialog.setRemoteBranchDropdownModel(this.model.getRemoteBranchDropdownModel());
        }
        if (arg == null || "selectedRemoteBranch".equals(arg)) {
            this.dialog.setSelectedRemoteBranch(this.model.getSelectedRemoteBranch());
        }
    }

    protected ValidationInfo validate() {
        this.updateModel();
        ModelValidationInfo validationInfo = this.model.validate();
        if (validationInfo != ModelValidationInfo.NO_ERRORS) {
            return new ValidationInfo(validationInfo.getValidationMessage(), this.dialog.getComponent(validationInfo.getValidationSource()));
        }
        return null;
    }

    protected void updateModel() {
        this.model.setBranchName(this.dialog.getBranchName());
        this.model.setSelectedRemoteBranch(this.dialog.getSelectedRemoteBranch());
        this.model.setCheckoutBranch(this.dialog.getCheckoutBranch());
    }
}

