/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.branch;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.BasicForm;
import git4idea.GitRemoteBranch;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;

public class CreateBranchForm
implements BasicForm {
    private JPanel contentPanel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JComboBox remoteBranchComboBox;
    private JLabel basedOn;
    private JCheckBox checkoutBranch;
    private boolean initialized = false;

    public CreateBranchForm() {
        this.$$$setupUI$$$();
    }

    @Override
    public JPanel getContentPanel() {
        this.ensureInitialized();
        return this.contentPanel;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.remoteBranchComboBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    return super.getListCellRendererComponent((JList<?>)list, value != null ? ((GitRemoteBranch)value).getName() : "", index, isSelected, cellHasFocus);
                }
            });
            this.initialized = true;
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.nameTextField;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.remoteBranchComboBox.addActionListener(listener);
    }

    public void setRemoteBranchDropdownModel(ComboBoxModel model) {
        if (model != null) {
            this.remoteBranchComboBox.setModel(model);
        }
    }

    public GitRemoteBranch getSelectedRemoteBranch() {
        Object item = this.remoteBranchComboBox.getSelectedItem();
        if (item instanceof GitRemoteBranch) {
            return (GitRemoteBranch)this.remoteBranchComboBox.getSelectedItem();
        }
        return null;
    }

    public void setSelectedRemoteBranch(GitRemoteBranch targetBranch) {
        if (targetBranch != null && this.remoteBranchComboBox != null) {
            this.remoteBranchComboBox.setSelectedItem(targetBranch);
        }
    }

    public void setBranchName(String branchName) {
        this.nameTextField.setText(branchName);
    }

    public String getBranchName() {
        return StringUtils.trim((String)this.nameTextField.getText());
    }

    public void setCheckoutBranch(boolean checkoutBranch) {
        this.checkoutBranch.setSelected(checkoutBranch);
    }

    public boolean getCheckoutBranch() {
        return this.checkoutBranch.isSelected();
    }

    private JComponent getBranchNameComponent() {
        return this.nameTextField;
    }

    public JComponent getComponent(String name) {
        if ("branchName".equals(name)) {
            return this.getBranchNameComponent();
        }
        if ("selectedRemoteBranch".equals(name)) {
            return this.remoteBranchComboBox;
        }
        return null;
    }

    private void $$$setupUI$$$() {
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.nameLabel = new JLabel();
        this.$$$loadLabelText$$$(this.nameLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreateBranchDialog.NameLabel"));
        this.contentPanel.add((Component)this.nameLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.remoteBranchComboBox = new JComboBox();
        this.contentPanel.add((Component)this.remoteBranchComboBox, new GridConstraints(3, 0, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.nameTextField = new JTextField();
        this.contentPanel.add((Component)this.nameTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.basedOn = new JLabel();
        this.$$$loadLabelText$$$(this.basedOn, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreateBranchDialog.BasedOn"));
        this.contentPanel.add((Component)this.basedOn, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.checkoutBranch = new JCheckBox();
        this.checkoutBranch.setSelected(true);
        this.$$$loadButtonText$$$(this.checkoutBranch, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreateBranchDialog.CheckoutBranch"));
        this.contentPanel.add((Component)this.checkoutBranch, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }
}

