/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.branch;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.ui.SortedComboBoxModel;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.AbstractModel;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.git.utils.GeneralGitHelper;
import com.microsoft.alm.plugin.idea.git.utils.TfGitHelper;
import com.microsoft.alm.plugin.telemetry.TfsTelemetryHelper;
import com.microsoft.alm.sourcecontrol.webapi.model.GitRefUpdate;
import com.microsoft.alm.sourcecontrol.webapi.model.GitRefUpdateResult;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBrancher;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.update.GitFetchResult;
import git4idea.update.GitFetcher;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBranchModel
extends AbstractModel {
    private static final Logger logger = LoggerFactory.getLogger(CreateBranchModel.class);
    private static final String REFS_PREFIX = "refs/heads/";
    private static final String ORIGIN_PREFIX = "origin/";
    private static final String BASE_HASH = "0000000000000000000000000000000000000000";
    public static final String PROP_BRANCH_NAME = "branchName";
    public static final String PROP_SELECTED_REMOTE_BRANCH = "selectedRemoteBranch";
    public static final String PROP_REMOTE_BRANCH_COMBO_MODEL = "remoteBranchComboModel";
    public static final String PROP_CHECKOUT_BRANCH = "checkoutBranch";
    public static final String CREATE_BRANCH_ACTION = "create-branch";
    private final Project project;
    private final GitRepository gitRepository;
    private final Collection<GitRemote> tfGitRemotes;
    private String branchName;
    private GitRemoteBranch selectedRemoteBranch;
    private SortedComboBoxModel<GitRemoteBranch> remoteBranchComboModel;
    private boolean checkoutBranch = true;
    private boolean branchWasCreated = false;

    protected CreateBranchModel(Project project, String defaultBranchName, GitRepository gitRepository) {
        this.project = project;
        this.branchName = defaultBranchName;
        this.gitRepository = gitRepository;
        this.tfGitRemotes = TfGitHelper.getTfGitRemotes(gitRepository);
        this.remoteBranchComboModel = this.createRemoteBranchDropdownModel();
        this.selectedRemoteBranch = (GitRemoteBranch)this.remoteBranchComboModel.getSelectedItem();
    }

    private SortedComboBoxModel<GitRemoteBranch> createRemoteBranchDropdownModel() {
        logger.info("CreateBranchModel.createRemoteBranchDropdownModel");
        SortedComboBoxModel sortedRemoteBranches = new SortedComboBoxModel((Comparator)new TfGitHelper.BranchComparator());
        sortedRemoteBranches.addAll(Collections2.filter((Collection)this.gitRepository.getInfo().getRemoteBranches(), (Predicate)new Predicate<GitRemoteBranch>(){

            public boolean apply(GitRemoteBranch remoteBranch) {
                return CreateBranchModel.this.tfGitRemotes.contains(remoteBranch.getRemote());
            }
        }));
        sortedRemoteBranches.setSelectedItem((Object)TfGitHelper.getDefaultBranch(sortedRemoteBranches.getItems(), this.tfGitRemotes));
        return sortedRemoteBranches;
    }

    public ComboBoxModel getRemoteBranchDropdownModel() {
        return this.remoteBranchComboModel;
    }

    public GitRemoteBranch getSelectedRemoteBranch() {
        return this.selectedRemoteBranch;
    }

    public void setSelectedRemoteBranch(GitRemoteBranch remoteBranch) {
        this.selectedRemoteBranch = remoteBranch;
        this.setChangedAndNotify(PROP_SELECTED_REMOTE_BRANCH);
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        if (!StringUtils.equals((String)this.branchName, (String)branchName)) {
            this.branchName = branchName;
            this.setChangedAndNotify(PROP_BRANCH_NAME);
        }
    }

    public boolean getCheckoutBranch() {
        return this.checkoutBranch;
    }

    public void setCheckoutBranch(boolean checkoutBranch) {
        if (this.checkoutBranch != checkoutBranch) {
            this.checkoutBranch = checkoutBranch;
            this.setChangedAndNotify(PROP_CHECKOUT_BRANCH);
        }
    }

    private void setBranchWasCreated(boolean branchWasCreated) {
        this.branchWasCreated = branchWasCreated;
    }

    public boolean getBranchWasCreated() {
        return this.branchWasCreated;
    }

    public ModelValidationInfo validate() {
        String branchName = this.getBranchName();
        if (branchName == null || branchName.isEmpty()) {
            return ModelValidationInfo.createWithResource(PROP_BRANCH_NAME, "CreateBranchDialog.Errors.BranchNameEmpty", new Object[0]);
        }
        for (GitRemoteBranch ref : this.remoteBranchComboModel.getItems()) {
            if (!StringUtils.equals((String)ref.getName().replace(ORIGIN_PREFIX, ""), (String)this.getBranchName())) continue;
            return ModelValidationInfo.createWithResource(PROP_BRANCH_NAME, "CreateBranchDialog.Errors.BranchNameExists", new Object[0]);
        }
        return ModelValidationInfo.NO_ERRORS;
    }

    public void createBranch() {
        logger.info("CreateBranchModel.createBranch");
        ModelValidationInfo validationInfo = this.validate();
        if (validationInfo == null) {
            final String gitRemoteUrl = TfGitHelper.getTfGitRemote(this.gitRepository).getFirstUrl();
            Task.Backgroundable createBranchTask = new Task.Backgroundable(this.project, TfPluginBundle.message("CreateBranchDialog.Title", new Object[0]), true, PerformInBackgroundOption.DEAF){

                public void run(@NotNull ProgressIndicator progressIndicator) {
                    progressIndicator.setText(TfPluginBundle.message("CreateBranchDialog.Title", new Object[0]));
                    ServerContext context = ServerContextManager.getInstance().getUpdatedContext(gitRemoteUrl, true);
                    if (context == null) {
                        VcsNotifier.getInstance((Project)CreateBranchModel.this.project).notifyError(TfPluginBundle.message("CreateBranchDialog.Errors.AuthenticationFailed.Title", new Object[0]), TfPluginBundle.message("Errors.AuthNotSuccessful", gitRemoteUrl));
                        return;
                    }
                    CreateBranchModel.this.doBranchCreate(context, progressIndicator);
                }
            };
            createBranchTask.queue();
        }
    }

    public boolean doBranchCreate(@NotNull ServerContext context, ProgressIndicator progressIndicator) {
        logger.info("CreateBranchModel.doBranchCreate");
        boolean hasNotifiedUser = false;
        String errorMessage = "";
        try {
            GitRefUpdate gitRefUpdate = new GitRefUpdate();
            gitRefUpdate.setName(REFS_PREFIX + this.getBranchName().replaceFirst(ORIGIN_PREFIX, ""));
            gitRefUpdate.setOldObjectId(BASE_HASH);
            gitRefUpdate.setNewObjectId(GeneralGitHelper.getLastCommitHash(this.project, this.gitRepository, (GitBranch)this.selectedRemoteBranch));
            gitRefUpdate.setRepositoryId(context.getGitRepository().getId());
            logger.info("CreateBranchModel.createBranch sending create ref call to server");
            List results = context.getGitHttpClient().updateRefs(Arrays.asList(gitRefUpdate), context.getGitRepository().getId(), context.getTeamProjectReference().getId().toString());
            if (results.size() < 1 || !((GitRefUpdateResult)results.get(0)).getSuccess()) {
                errorMessage = results.size() > 0 ? ((GitRefUpdateResult)results.get(0)).getCustomMessage() : "CreateBranchDialog.Errors.UnexpectedServerError";
            } else {
                final GitRepository gitRepository = TfGitHelper.getTfGitRepository(this.project);
                if (gitRepository != null) {
                    logger.info("Fetching latest from server so that the new branch is available to checkout");
                    GitFetcher fetcher = new GitFetcher(this.project, this.getProgressIndicator(progressIndicator), true);
                    GitFetchResult fetchResult = fetcher.fetch(gitRepository);
                    if (fetchResult.isSuccess() && this.checkoutBranch) {
                        logger.info("Checking out new branch: " + this.branchName);
                        IdeaHelper.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                logger.info("Finishing: Checking out new branch: " + CreateBranchModel.this.branchName);
                                String remoteBranchName = TfGitHelper.getRemoteBranchName(CreateBranchModel.this.selectedRemoteBranch.getRemote(), CreateBranchModel.this.branchName);
                                GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)CreateBranchModel.this.project, GitBrancher.class);
                                brancher.checkoutNewBranchStartingFrom(CreateBranchModel.this.branchName, remoteBranchName, Collections.singletonList(gitRepository), null);
                            }
                        });
                    }
                } else {
                    logger.warn("Could not fetch branch from server. Unable to retrieve the git repo object from the project.");
                }
            }
        }
        catch (Throwable t) {
            if (AuthHelper.isNotAuthorizedError((Throwable)t)) {
                ServerContext newContext = ServerContextManager.getInstance().updateAuthenticationInfo(context.getGitRepository().getRemoteUrl());
                if (newContext != null) {
                    hasNotifiedUser = this.doBranchCreate(newContext, progressIndicator);
                } else {
                    errorMessage = t.getMessage();
                }
            }
            errorMessage = t.getMessage();
        }
        if (!hasNotifiedUser) {
            if (StringUtils.isEmpty((String)errorMessage)) {
                logger.info("Create branch succeeded");
                this.setBranchWasCreated(true);
                String branchLink = String.format("<html><body><a href=\"%s\">%s</a></body></html>", UrlHelper.getBranchURI((URI)context.getUri(), (String)this.getBranchName()), this.getBranchName());
                VcsNotifier.getInstance((Project)this.project).notifyImportantInfo(TfPluginBundle.message("CreateBranchDialog.Successful.Title", new Object[0]), TfPluginBundle.message("CreateBranchDialog.Successful.Description", branchLink), new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent hyperlinkEvent) {
                        BrowserUtil.browse((URL)hyperlinkEvent.getURL());
                    }
                });
            } else {
                logger.warn("Create branch failed", (Object)errorMessage);
                VcsNotifier.getInstance((Project)this.project).notifyError(TfPluginBundle.message("CreateBranchDialog.Failed.Title", new Object[0]), TfPluginBundle.message("CreateBranchDialog.Errors.BranchCreateFailed", errorMessage));
            }
            TfsTelemetryHelper.sendEventAsync((String)CREATE_BRANCH_ACTION, (Map)new TfsTelemetryHelper.PropertyMapBuilder().currentOrActiveContext(context).actionName(CREATE_BRANCH_ACTION).success(Boolean.valueOf(StringUtils.isEmpty((String)errorMessage))).message(errorMessage).build());
            hasNotifiedUser = true;
        }
        return hasNotifiedUser;
    }

    private ProgressIndicator getProgressIndicator(ProgressIndicator indicator) {
        if (indicator != null) {
            return indicator;
        }
        return new ProgressIndicator(){

            public void start() {
            }

            public void stop() {
            }

            public boolean isRunning() {
                return false;
            }

            public void cancel() {
            }

            public boolean isCanceled() {
                return false;
            }

            public void setText(String text) {
            }

            public String getText() {
                return null;
            }

            public void setText2(String text) {
            }

            public String getText2() {
                return null;
            }

            public double getFraction() {
                return 0.0;
            }

            public void setFraction(double fraction) {
            }

            public void pushState() {
            }

            public void popState() {
            }

            public void startNonCancelableSection() {
            }

            public void finishNonCancelableSection() {
            }

            public boolean isModal() {
                return false;
            }

            @NotNull
            public ModalityState getModalityState() {
                return null;
            }

            public void setModalityProgress(ProgressIndicator modalityProgress) {
            }

            public boolean isIndeterminate() {
                return false;
            }

            public void setIndeterminate(boolean indeterminate) {
            }

            public void checkCanceled() throws ProcessCanceledException {
            }

            public boolean isPopupWasShown() {
                return false;
            }

            public boolean isShowing() {
                return false;
            }
        };
    }
}

