/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.checkout;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.checkout.VcsSpecificCheckoutModel;
import git4idea.checkout.GitCheckoutProvider;
import git4idea.commands.Git;

public class GitCheckoutModel
implements VcsSpecificCheckoutModel {
    @Override
    public void doCheckout(Project project, CheckoutProvider.Listener listener, ServerContext context, VirtualFile destinationParent, String directoryName, String parentDirectory, boolean isAdvancedChecked) {
        String gitRepositoryStr = context.getUsableGitUrl();
        Git git = (Git)ServiceManager.getService(Git.class);
        GitCheckoutProvider.clone((Project)project, (Git)git, (CheckoutProvider.Listener)listener, (VirtualFile)destinationParent, (String)gitRepositoryStr, (String)directoryName, (String)parentDirectory);
    }

    @Override
    public String getTelemetryAction() {
        return "clone";
    }

    @Override
    public String getButtonText() {
        return TfPluginBundle.message("CheckoutDialog.CloneButton", new Object[0]);
    }

    @Override
    public String getRepositoryName(ServerContext context) {
        return context != null && context.getGitRepository() != null ? context.getGitRepository().getName() : "";
    }

    @Override
    public RepositoryContext.Type getRepositoryType() {
        return RepositoryContext.Type.GIT;
    }
}

