/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.pullrequest;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.SwingHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.BasicForm;
import com.microsoft.alm.plugin.idea.common.ui.controls.BusySpinnerPanel;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.repo.GitRepository;
import git4idea.ui.GitCommitListWithDiffPanel;
import git4idea.util.GitCommitCompareInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CreatePullRequestForm
implements BasicForm {
    public static final String CMD_TARGET_BRANCH_UPDATED = "cmdTargetBranchDropDownChanged";
    private JComboBox targetBranchDropdown;
    private JLabel sourceBranch;
    private JLabel sourceBranchLabel;
    private JPanel contentPanel;
    private JTabbedPane quickDiffPane;
    private JLabel titleLabel;
    private JTextField titleTextField;
    private JLabel descriptionLabel;
    private JTextArea descriptionTextArea;
    private JLabel targetBranchLabel;
    private JLabel loadingLabel;
    private BusySpinnerPanel spinner;
    private JPanel spinnerPanel;
    private JScrollPane descriptionScrollPane;
    private JSplitPane splitPane;
    private boolean initialized = false;

    public CreatePullRequestForm() {
        this.$$$setupUI$$$();
    }

    @Override
    public JPanel getContentPanel() {
        this.ensureInitialized();
        return this.contentPanel;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            Dimension spinnerSize = new Dimension(JBUI.scale((int)20), JBUI.scale((int)20));
            this.spinner.setPreferredSize(spinnerSize);
            this.spinner.setMinimumSize(spinnerSize);
            SwingHelper.fixTabKeys(this.descriptionTextArea);
            SwingHelper.setPreferredHeight(this.descriptionScrollPane, 80);
            SwingHelper.copyFontAndMargins(this.descriptionTextArea, this.titleTextField);
            Dimension descriptionScrollPaneSize = new Dimension(JBUI.scale((int)80), JBUI.scale((int)80));
            this.descriptionScrollPane.setPreferredSize(descriptionScrollPaneSize);
            this.descriptionScrollPane.setMinimumSize(descriptionScrollPaneSize);
            this.splitPane.setDividerSize(JBUI.scale((int)7));
            this.initialized = true;
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.titleTextField;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.targetBranchDropdown.addActionListener(listener);
    }

    public void setTargetBranchDropdownModel(ComboBoxModel model) {
        if (model != null) {
            this.targetBranchDropdown.setModel(model);
        }
    }

    public void setSourceBranch(GitBranch currentBranch) {
        if (currentBranch != null) {
            this.sourceBranch.setText(currentBranch.getName());
        }
    }

    public void setTitleTextField(String title) {
        this.titleTextField.setText(title);
    }

    public String getTitleText() {
        return this.titleTextField.getText();
    }

    public void setDescriptionTextArea(String description) {
        this.descriptionTextArea.setText(description);
    }

    public String getDescriptionText() {
        return this.descriptionTextArea.getText();
    }

    public GitRemoteBranch getSelectedRemoteBranch() {
        Object o = this.targetBranchDropdown.getSelectedItem();
        if (o instanceof GitRemoteBranch) {
            return (GitRemoteBranch)this.targetBranchDropdown.getSelectedItem();
        }
        return null;
    }

    public void setSelectedTargetBranch(GitRemoteBranch targetBranch) {
        if (targetBranch != null && this.targetBranchDropdown != null) {
            this.targetBranchDropdown.setSelectedItem(targetBranch);
        }
    }

    public JComponent getComponent(@NotNull String componentPropName) {
        if (componentPropName.equals("title")) {
            return this.titleTextField;
        }
        if (componentPropName.equals("description")) {
            return this.descriptionTextArea;
        }
        if (componentPropName.equals("sourceBranch")) {
            return this.sourceBranch;
        }
        if (componentPropName.equals("targetBranch")) {
            return this.targetBranchDropdown;
        }
        return null;
    }

    public void setLoading(boolean loading) {
        if (loading) {
            this.quickDiffPane.removeAll();
            this.spinnerPanel.setVisible(true);
            this.spinner.start(true);
        } else {
            this.spinnerPanel.setVisible(false);
            this.spinner.start(false);
        }
    }

    public synchronized void populateDiffPane(@NotNull Project project, @NotNull GitRepository gitRepository, @NotNull String sourceBranchBeingCompared, @NotNull String targetBranchBeingCompared, @NotNull GitCommitCompareInfo myCompareInfo) {
        GitRemoteBranch gitRemoteBranch = this.getSelectedRemoteBranch();
        String currBranch = this.sourceBranch.getText();
        if (gitRemoteBranch != null && StringUtils.equals((String)gitRemoteBranch.getName(), (String)targetBranchBeingCompared) && StringUtils.isNotEmpty((String)currBranch) && StringUtils.equals((String)currBranch, (String)sourceBranchBeingCompared)) {
            this.quickDiffPane.removeAll();
            JComponent myDiffPanel = this.createDiffPaneBrowser(project, myCompareInfo);
            this.quickDiffPane.addTab(TfPluginBundle.message("CreatePullRequestDialog.ChangesPane.Title", new Object[0]), AllIcons.Actions.Diff, myDiffPanel);
            JComponent myCommitsPanel = this.createCommitsListPane(project, gitRepository, myCompareInfo);
            this.quickDiffPane.addTab(TfPluginBundle.message("CreatePullRequestDialog.CommitsPane.Title", new Object[0]), AllIcons.Actions.Commit, myCommitsPanel);
        }
    }

    private JComponent createCommitsListPane(Project project, GitRepository gitRepository, GitCommitCompareInfo compareInfo) {
        return new GitCommitListWithDiffPanel(project, compareInfo.getBranchToHeadCommits(gitRepository));
    }

    private JComponent createDiffPaneBrowser(Project project, GitCommitCompareInfo compareInfo) {
        List diff = compareInfo.getTotalDiff();
        ChangesBrowser changesBrowser = new ChangesBrowser(project, null, diff, null, false, true, null, ChangesBrowser.MyUseCase.COMMITTED_CHANGES, null);
        changesBrowser.setChangesToDisplay(diff);
        return changesBrowser;
    }

    private void createUIComponents() {
        this.targetBranchDropdown = new JComboBox();
        this.targetBranchDropdown.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object gitRemoteBranch, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, gitRemoteBranch != null ? ((GitRemoteBranch)gitRemoteBranch).getName() : "", index, isSelected, cellHasFocus);
            }
        });
        this.targetBranchDropdown.setActionCommand(CMD_TARGET_BRANCH_UPDATED);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout((LayoutManager)new GridLayoutManager(9, 4, new Insets(0, 0, 0, 0), -1, -1));
        this.sourceBranchLabel = new JLabel();
        this.$$$loadLabelText$$$(this.sourceBranchLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreatePullRequestDialog.SourceBranchLabel"));
        this.contentPanel.add((Component)this.sourceBranchLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.titleLabel = new JLabel();
        this.$$$loadLabelText$$$(this.titleLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreatePullRequestDialog.TitleLabel"));
        this.contentPanel.add((Component)this.titleLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.descriptionLabel = new JLabel();
        this.$$$loadLabelText$$$(this.descriptionLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreatePullRequestDialog.DescriptionLabel"));
        this.contentPanel.add((Component)this.descriptionLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.titleTextField = new JTextField();
        this.contentPanel.add((Component)this.titleTextField, new GridConstraints(5, 0, 1, 4, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.targetBranchLabel = new JLabel();
        this.$$$loadLabelText$$$(this.targetBranchLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreatePullRequestDialog.TargetBranchLabel"));
        this.contentPanel.add((Component)this.targetBranchLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.contentPanel.add((Component)this.targetBranchDropdown, new GridConstraints(2, 0, 1, 4, 8, 1, 2, 0, null, null, null, 0, false));
        this.sourceBranch = new JLabel();
        this.sourceBranch.setText("");
        this.contentPanel.add((Component)this.sourceBranch, new GridConstraints(0, 1, 1, 2, 8, 0, 4, 0, null, null, null, 0, false));
        this.splitPane = new JSplitPane();
        this.splitPane.setOrientation(0);
        this.contentPanel.add((Component)this.splitPane, new GridConstraints(7, 0, 1, 4, 0, 3, 3, 3, null, new Dimension(200, 200), null, 0, false));
        this.descriptionScrollPane = new JScrollPane();
        this.splitPane.setLeftComponent(this.descriptionScrollPane);
        this.descriptionTextArea = new JTextArea();
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.splitPane.setRightComponent(panel1);
        this.quickDiffPane = new JTabbedPane();
        panel1.add((Component)this.quickDiffPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null, 0, false));
        this.spinnerPanel = new JPanel();
        this.spinnerPanel.setLayout(new FlowLayout(0, 5, 5));
        panel1.add((Component)this.spinnerPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null, 0, false));
        this.spinner = new BusySpinnerPanel();
        this.spinnerPanel.add(this.spinner);
        this.loadingLabel = new JLabel();
        this.$$$loadLabelText$$$(this.loadingLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreatePullRequestDialog.LoadingDiffLabel"));
        this.spinnerPanel.add(this.loadingLabel);
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }
}

