/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.pullrequest;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.ui.SortedComboBoxModel;
import com.microsoft.alm.common.artifact.ArtifactID;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.context.rest.GitHttpClientEx;
import com.microsoft.alm.plugin.context.rest.GitPullRequestEx;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.AbstractModel;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.utils.EventContextHelper;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.DiffCompareInfoProvider;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.GitChangesContainer;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.PullRequestHelper;
import com.microsoft.alm.plugin.idea.git.utils.GeneralGitHelper;
import com.microsoft.alm.plugin.idea.git.utils.TfGitHelper;
import com.microsoft.alm.sourcecontrol.webapi.GitHttpClient;
import com.microsoft.alm.sourcecontrol.webapi.model.GitPullRequest;
import com.microsoft.alm.workitemtracking.webapi.models.Link;
import com.microsoft.visualstudio.services.webapi.patch.Operation;
import com.microsoft.visualstudio.services.webapi.patch.json.JsonPatchDocument;
import com.microsoft.visualstudio.services.webapi.patch.json.JsonPatchOperation;
import git4idea.GitBranch;
import git4idea.GitCommit;
import git4idea.GitExecutionException;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.util.GitCommitCompareInfo;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.ComboBoxModel;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePullRequestModel
extends AbstractModel {
    private static final Logger logger = LoggerFactory.getLogger(CreatePullRequestModel.class);
    public static final int MAX_SIZE_TITLE = 400;
    public static final int MAX_SIZE_DESCRIPTION = 4000;
    public static final String PROP_TARGET_BRANCH = "targetBranch";
    public static final String PROP_TARGET_BRANCH_COMBO_MODEL = "targetBranchComboModel";
    public static final String PROP_SOURCE_BRANCH = "sourceBranch";
    public static final String PROP_TITLE = "title";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_LOADING = "loading";
    public static final String PROP_DIFF_MODEL = "diffModel";
    private static final String LINK_NAME_KEY = "name";
    private static final String LINK_NAME_VALUE = "Pull Request";
    private static final String ARTIFACT_LINK_RELATION = "ArtifactLink";
    private static final String RELATIONS_PATH = "/relations/-";
    private Project project;
    private GitRepository gitRepository;
    private GitRemoteBranch targetBranch;
    private String title;
    private String description;
    private final Collection<GitRemote> tfGitRemotes;
    private final ComboBoxModel remoteBranchComboModel;
    private final PullRequestHelper pullRequestHelper;
    private final Set<Integer> workItems;
    private DiffCompareInfoProvider diffCompareInfoProvider;
    private boolean loading = false;
    private GitChangesContainer localBranchChanges;
    private final LoadingCache<Pair<String, String>, GitCommitCompareInfo> diffCache;
    private final ListeningExecutorService executorService;
    private ApplicationProvider applicationProvider;

    public CreatePullRequestModel(final @NotNull Project project, final @NotNull GitRepository gitRepository) {
        this.project = project;
        this.gitRepository = gitRepository;
        this.tfGitRemotes = TfGitHelper.getTfGitRemotes(gitRepository);
        this.remoteBranchComboModel = this.createRemoteBranchDropdownModel();
        this.targetBranch = (GitRemoteBranch)this.remoteBranchComboModel.getSelectedItem();
        this.applicationProvider = new ApplicationProvider();
        this.pullRequestHelper = new PullRequestHelper();
        this.diffCompareInfoProvider = new DiffCompareInfoProvider();
        this.diffCache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<Pair<String, String>, GitCommitCompareInfo>(){

            public GitCommitCompareInfo load(Pair<String, String> key) throws Exception {
                CreatePullRequestModel.this.applicationProvider.invokeAndWaitWithAnyModality(new Runnable(){

                    @Override
                    public void run() {
                        CreatePullRequestModel.this.setLoading(true);
                    }
                });
                return CreatePullRequestModel.this.getDiffCompareInfoProvider().getBranchCompareInfo(project, gitRepository, (String)key.getFirst(), (String)key.getSecond());
            }
        });
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        this.workItems = new HashSet<Integer>();
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public synchronized String getTitle() {
        return StringUtils.isNotBlank((String)this.title) ? this.title : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String title) {
        CreatePullRequestModel createPullRequestModel = this;
        synchronized (createPullRequestModel) {
            this.title = StringUtils.trim((String)title);
        }
        this.setChangedAndNotify(PROP_TITLE);
    }

    public synchronized String getDescription() {
        return StringUtils.isNotBlank((String)this.description) ? this.description : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescription(String description) {
        CreatePullRequestModel createPullRequestModel = this;
        synchronized (createPullRequestModel) {
            this.description = StringUtils.trim((String)description);
        }
        this.setChangedAndNotify(PROP_DESCRIPTION);
    }

    public DiffCompareInfoProvider getDiffCompareInfoProvider() {
        return this.diffCompareInfoProvider;
    }

    public void setDiffCompareInfoProvider(DiffCompareInfoProvider diffCompareInfoProvider) {
        this.diffCompareInfoProvider = diffCompareInfoProvider;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        if (this.loading != loading) {
            this.loading = loading;
            this.setChangedAndNotify(PROP_LOADING);
        }
    }

    public GitChangesContainer getLocalBranchChanges() {
        return this.localBranchChanges;
    }

    public void setLocalBranchChanges(GitChangesContainer localBranchChanges) {
        if (this.localBranchChanges != localBranchChanges) {
            this.localBranchChanges = localBranchChanges;
            this.setChangedAndNotify(PROP_DIFF_MODEL);
        }
    }

    @Nullable
    public GitLocalBranch getSourceBranch() {
        return this.getInfo() != null ? this.getInfo().getCurrentBranch() : null;
    }

    public synchronized GitRemoteBranch getTargetBranch() {
        return this.targetBranch;
    }

    public synchronized void setTargetBranch(GitRemoteBranch targetBranch) {
        if (this.targetBranch != targetBranch) {
            this.targetBranch = targetBranch;
            this.setChangedAndNotify(PROP_TARGET_BRANCH);
        }
    }

    @NotNull
    public ComboBoxModel getRemoteBranchDropdownModel() {
        return this.remoteBranchComboModel;
    }

    private ComboBoxModel createRemoteBranchDropdownModel() {
        SortedComboBoxModel sortedRemoteBranches = new SortedComboBoxModel((Comparator)new TfGitHelper.BranchComparator());
        final GitRemoteBranch remoteTrackingBranch = this.getRemoteTrackingBranch();
        sortedRemoteBranches.addAll(Collections2.filter((Collection)this.getInfo().getRemoteBranches(), (Predicate)new Predicate<GitRemoteBranch>(){

            public boolean apply(GitRemoteBranch remoteBranch) {
                return CreatePullRequestModel.this.tfGitRemotes.contains(remoteBranch.getRemote()) && !remoteBranch.equals((Object)remoteTrackingBranch);
            }
        }));
        sortedRemoteBranches.setSelectedItem((Object)TfGitHelper.getDefaultBranch(sortedRemoteBranches.getItems(), this.tfGitRemotes));
        return sortedRemoteBranches;
    }

    @Nullable
    private GitRemoteBranch getRemoteTrackingBranch() {
        GitLocalBranch localBranch = this.getSourceBranch();
        return localBranch != null && this.gitRepository != null ? localBranch.findTrackedBranch(this.gitRepository) : null;
    }

    GitChangesContainer getMyChangesCompareInfo() throws VcsException {
        GitLocalBranch currBranch = this.getSourceBranch();
        GitRemoteBranch selectedRemoteBranch = this.getTargetBranch();
        if (selectedRemoteBranch == null || currBranch == null) {
            return GitChangesContainer.createChangesContainer(null, null, null, null, this.getDiffCompareInfoProvider().getEmptyDiff(this.gitRepository), this.gitRepository);
        }
        String remoteBranchHash = GeneralGitHelper.getLastCommitHash(this.project, this.gitRepository, (GitBranch)selectedRemoteBranch);
        String currBranchHash = GeneralGitHelper.getLastCommitHash(this.project, this.gitRepository, (GitBranch)currBranch);
        try {
            GitCommitCompareInfo changes = (GitCommitCompareInfo)this.diffCache.get((Object)new Pair((Object)currBranchHash, (Object)remoteBranchHash));
            return GitChangesContainer.createChangesContainer(currBranch.getName(), selectedRemoteBranch.getName(), currBranchHash, remoteBranchHash, changes, this.gitRepository);
        }
        catch (ExecutionException e) {
            throw new VcsException(e.getCause());
        }
    }

    public void loadDiff() {
        if (this.getSourceBranch() != null && this.getTargetBranch() != null) {
            ListenableFuture diffFuture = this.executorService.submit((Callable)new Callable<GitChangesContainer>(){

                @Override
                public GitChangesContainer call() throws Exception {
                    return CreatePullRequestModel.this.getMyChangesCompareInfo();
                }
            });
            Futures.addCallback((ListenableFuture)diffFuture, (FutureCallback)new FutureCallback<GitChangesContainer>(){

                public void onSuccess(final GitChangesContainer changesContainer) {
                    CreatePullRequestModel.this.applicationProvider.invokeAndWaitWithAnyModality(new Runnable(){

                        @Override
                        public void run() {
                            if (changesContainer != null && CreatePullRequestModel.this.isChangesUpToDate(changesContainer)) {
                                CreatePullRequestModel.this.setLoading(false);
                                GitCommitCompareInfo compareInfo = changesContainer.getGitCommitCompareInfo();
                                if (compareInfo != null) {
                                    List commits = compareInfo.getBranchToHeadCommits(changesContainer.getGitRepository());
                                    GitLocalBranch sourceBranch = CreatePullRequestModel.this.getSourceBranch();
                                    GitRemoteBranch targetBranch = CreatePullRequestModel.this.getTargetBranch();
                                    if (StringUtils.isEmpty((String)CreatePullRequestModel.this.getTitle()) && commits != null && sourceBranch.getName() != null && targetBranch.getNameForRemoteOperations() != null) {
                                        String defaultTitle = CreatePullRequestModel.this.pullRequestHelper.createDefaultTitle(commits, sourceBranch.getName(), targetBranch.getNameForRemoteOperations());
                                        CreatePullRequestModel.this.setTitle(defaultTitle);
                                        String defaultDescription = CreatePullRequestModel.this.pullRequestHelper.createDefaultDescription(commits);
                                        CreatePullRequestModel.this.setDescription(defaultDescription);
                                    }
                                    CreatePullRequestModel.this.workItems.clear();
                                    for (GitCommit commit : commits) {
                                        String commitMsg = commit.getFullMessage();
                                        CreatePullRequestModel.this.workItems.addAll(VcsHelper.getWorkItemIdsFromMessage(commitMsg));
                                    }
                                }
                                CreatePullRequestModel.this.setLocalBranchChanges(changesContainer);
                            }
                        }
                    });
                }

                public void onFailure(Throwable thrown) {
                    logger.warn("onFailure in loadDiff", thrown);
                    CreatePullRequestModel.this.applicationProvider.invokeAndWaitWithAnyModality(new Runnable(){

                        @Override
                        public void run() {
                            GitLocalBranch sourceBranch = CreatePullRequestModel.this.getSourceBranch();
                            GitRemoteBranch targetBranch = CreatePullRequestModel.this.getTargetBranch();
                            String sourceBranchName = sourceBranch != null ? sourceBranch.getName() : "";
                            String targetBranchName = targetBranch != null ? targetBranch.getName() : "";
                            CreatePullRequestModel.this.notifyDiffFailedError(CreatePullRequestModel.this.getProject(), TfPluginBundle.message("CreatePullRequestDialog.Errors.DiffFailed.Message", sourceBranchName, targetBranchName));
                            GitChangesContainer changesContainer = GitChangesContainer.createChangesContainer(sourceBranchName, targetBranchName, null, null, CreatePullRequestModel.this.getDiffCompareInfoProvider().getEmptyDiff(CreatePullRequestModel.this.gitRepository), CreatePullRequestModel.this.gitRepository);
                            if (CreatePullRequestModel.this.isChangesUpToDate(changesContainer)) {
                                CreatePullRequestModel.this.setLoading(false);
                                CreatePullRequestModel.this.setLocalBranchChanges(changesContainer);
                            }
                        }
                    });
                }
            });
        }
    }

    public void createPullRequest() {
        final GitLocalBranch sourceBranch = this.getSourceBranch();
        final GitRemoteBranch targetBranch = this.getTargetBranch();
        if (sourceBranch == null) {
            this.notifyCreateFailedError(this.project, TfPluginBundle.message("CreatePullRequestDialog.Errors.SourceEmpty", new Object[0]));
            return;
        }
        if (targetBranch == null) {
            this.notifyCreateFailedError(this.project, TfPluginBundle.message("CreatePullRequestDialog.Errors.TargetNotSelected", new Object[0]));
            return;
        }
        if (targetBranch.equals((Object)this.getRemoteTrackingBranch())) {
            this.notifyCreateFailedError(this.project, TfPluginBundle.message("CreatePullRequestDialog.Errors.TargetIsLocalTracking", new Object[0]));
            return;
        }
        final String gitRemoteUrl = TfGitHelper.getTfGitRemote(this.gitRepository).getFirstUrl();
        final CreatePullRequestModel createModel = this;
        Task.Backgroundable createPullRequestTask = new Task.Backgroundable(this.project, TfPluginBundle.message("CreatePullRequestDialog.Title", new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator progressIndicator) {
                ListenableFuture pushResult = CreatePullRequestModel.this.doPushCommits(CreatePullRequestModel.this.gitRepository, sourceBranch, targetBranch.getRemote(), progressIndicator);
                Futures.addCallback((ListenableFuture)pushResult, (FutureCallback)new FutureCallback<Pair<String, GitCommandResult>>(){

                    public void onSuccess(@Nullable Pair<String, GitCommandResult> result) {
                        if (result != null && StringUtils.isNotEmpty((String)((String)result.getFirst()))) {
                            String title = createModel.getTitle();
                            String description = createModel.getDescription();
                            String branchNameOnRemoteServer = (String)result.getFirst();
                            ServerContext context = ServerContextManager.getInstance().getUpdatedContext(gitRemoteUrl, true);
                            if (context == null) {
                                CreatePullRequestModel.this.notifyCreateFailedError(CreatePullRequestModel.this.project, TfPluginBundle.message("Errors.AuthNotSuccessful", gitRemoteUrl));
                                return;
                            }
                            CreatePullRequestModel.this.doCreatePullRequest(CreatePullRequestModel.this.project, context, title, description, branchNameOnRemoteServer, targetBranch);
                        } else {
                            CreatePullRequestModel.this.notifyPushFailedError(createModel.getProject(), "");
                        }
                    }

                    public void onFailure(Throwable t) {
                        CreatePullRequestModel.this.notifyPushFailedError(createModel.getProject(), t.getLocalizedMessage());
                    }
                });
            }
        };
        createPullRequestTask.queue();
    }

    private ListenableFuture<Pair<String, GitCommandResult>> doPushCommits(@NotNull GitRepository gitRepository, @NotNull GitLocalBranch localBranch, @NotNull GitRemote gitRemote, @NotNull ProgressIndicator indicator) {
        String createdBranchNameOnServer;
        SettableFuture pushResult = SettableFuture.create();
        indicator.setText(TfPluginBundle.message("CreatePullRequestDialog.Push.Title", new Object[0]));
        Git git = (Git)ServiceManager.getService(Git.class);
        GitRemoteBranch trackingBranch = localBranch.findTrackedBranch(gitRepository);
        StringBuilder pushSpec = new StringBuilder(localBranch.getName());
        if (trackingBranch != null && trackingBranch.getRemote().equals((Object)gitRemote)) {
            pushSpec.append(":").append(trackingBranch.getNameForRemoteOperations());
            createdBranchNameOnServer = trackingBranch.getNameForRemoteOperations();
        } else {
            createdBranchNameOnServer = localBranch.getName();
        }
        String fetchUrl = this.getFetchUrl(gitRemote);
        String pushSpecStr = pushSpec.toString();
        String gitRemoteName = gitRemote.getName();
        logger.debug("Pushing {} to {}: {}", new Object[]{pushSpecStr, gitRemoteName, fetchUrl});
        GitCommandResult result = git.push(gitRepository, gitRemoteName, fetchUrl, pushSpecStr, true, new GitLineHandlerListener[0]);
        if (result.success()) {
            pushResult.set((Object)Pair.create((Object)createdBranchNameOnServer, (Object)result));
        } else {
            String errMsg = result.getErrorOutputAsJoinedString();
            pushResult.setException((Throwable)new GitExecutionException(errMsg, null));
        }
        return pushResult;
    }

    private void doCreatePullRequest(@NotNull Project project, @NotNull ServerContext context, @NotNull String title, @NotNull String description, @NotNull String branchNameOnRemoteServer, @NotNull GitRemoteBranch targetBranch) {
        GitHttpClientEx gitClient = context.getGitHttpClient();
        try {
            UUID repositoryId = context.getGitRepository().getId();
            UUID projectId = context.getTeamProjectReference().getId();
            GitPullRequestEx pullRequestToBeCreated = this.pullRequestHelper.generateGitPullRequest(title, description, branchNameOnRemoteServer, targetBranch, this.workItems, context);
            GitPullRequest gitPullRequest = gitClient.createPullRequest((GitPullRequest)pullRequestToBeCreated, projectId, repositoryId, Boolean.valueOf(true), Boolean.valueOf(true));
            String repositoryRemoteUrl = context.getGitRepository().getRemoteUrl();
            this.notifySuccess(project, TfPluginBundle.message("CreatePullRequestDialog.Created.Title", new Object[0]), this.pullRequestHelper.getHtmlMsg(repositoryRemoteUrl, gitPullRequest.getPullRequestId()));
        }
        catch (Throwable t) {
            if (AuthHelper.isNotAuthorizedError((Throwable)t)) {
                ServerContext newContext = ServerContextManager.getInstance().updateAuthenticationInfo(context.getGitRepository().getRemoteUrl());
                if (newContext != null) {
                    this.doCreatePullRequest(project, newContext, title, description, branchNameOnRemoteServer, targetBranch);
                }
            }
            Pair<PullRequestHelper.PRCreateStatus, String> parsed = this.pullRequestHelper.parseException(t, branchNameOnRemoteServer, targetBranch, context, (GitHttpClient)gitClient);
            if (parsed.getFirst() == PullRequestHelper.PRCreateStatus.DUPLICATE) {
                this.notifySuccess(project, TfPluginBundle.message("CreatePullRequestDialog.AlreadyExists.Title", new Object[0]), (String)parsed.getSecond());
            }
            this.notifyCreateFailedError(project, (String)parsed.getSecond());
            logger.warn("Create pull request failed", t);
        }
    }

    private void createWorkItemLinks(int workItemId, ServerContext context, int prNumber) {
        String toolSpecificId = context.getTeamProjectReference().getId().toString() + "/" + context.getGitRepository().getId().toString() + "/" + prNumber;
        ArtifactID artifactID = new ArtifactID("Git", "PullRequestId", toolSpecificId);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(LINK_NAME_KEY, LINK_NAME_VALUE);
        Link link = new Link();
        link.setUrl(artifactID.encodeURI());
        link.setTitle("");
        link.setRel(ARTIFACT_LINK_RELATION);
        link.setAttributes(attributes);
        JsonPatchOperation operation = new JsonPatchOperation();
        operation.setOp(Operation.ADD);
        operation.setPath(RELATIONS_PATH);
        operation.setValue((Object)link);
        JsonPatchDocument doc = new JsonPatchDocument();
        doc.add((Object)operation);
        try {
            context.getWitHttpClient().updateWorkItem(doc, workItemId, Boolean.valueOf(false), Boolean.valueOf(false));
        }
        catch (Throwable t) {
            logger.warn("createWorkItemLinks experienced an exception while associating a work item and pull request", t);
        }
    }

    private String getFetchUrl(@NotNull GitRemote gitRemote) {
        return gitRemote.getFirstUrl();
    }

    private boolean isChangesUpToDate(GitChangesContainer changesContainer) {
        GitRemoteBranch targetBranch = this.getTargetBranch();
        if (changesContainer.getTargetBranchName() != null && targetBranch != null && !changesContainer.getTargetBranchName().equals(targetBranch.getName())) {
            return false;
        }
        GitLocalBranch sourceBranch = this.getSourceBranch();
        return changesContainer.getSourceBranchName() == null || sourceBranch == null || changesContainer.getSourceBranchName().equals(sourceBranch.getName());
    }

    public ModelValidationInfo validate() {
        if (StringUtils.isEmpty((String)this.getTitle())) {
            return ModelValidationInfo.createWithResource(PROP_TITLE, "CreatePullRequestDialog.Errors.TitleEmpty", new Object[0]);
        }
        if (this.getTitle().length() > 400) {
            return ModelValidationInfo.createWithResource(PROP_TITLE, TfPluginBundle.message("CreatePullRequestDialog.Errors.TitleTooLong", 400), new Object[0]);
        }
        if (StringUtils.isEmpty((String)this.getDescription())) {
            return ModelValidationInfo.createWithResource(PROP_DESCRIPTION, "CreatePullRequestDialog.Errors.DescriptionEmpty", new Object[0]);
        }
        if (this.getDescription().length() > 4000) {
            return ModelValidationInfo.createWithResource(PROP_DESCRIPTION, TfPluginBundle.message("CreatePullRequestDialog.Errors.DescriptionTooLong", 4000), new Object[0]);
        }
        if (this.getSourceBranch() == null) {
            return ModelValidationInfo.createWithResource(PROP_SOURCE_BRANCH, "CreatePullRequestDialog.Errors.SourceEmpty", new Object[0]);
        }
        if (this.getTargetBranch() == null) {
            return ModelValidationInfo.createWithResource(PROP_TARGET_BRANCH, "CreatePullRequestDialog.Errors.TargetNotSelected", new Object[0]);
        }
        return ModelValidationInfo.NO_ERRORS;
    }

    private GitRepoInfo getInfo() {
        return this.gitRepository.getInfo();
    }

    private void notifyDiffFailedError(Project project, String message) {
        this.notifyError(project, TfPluginBundle.message("CreatePullRequestDialog.Errors.DiffFailed.Title", new Object[0]), message);
    }

    private void notifyPushFailedError(Project project, String message) {
        this.notifyError(project, TfPluginBundle.message("CreatePullRequestDialog.Errors.PushFailed.Title", new Object[0]), message);
    }

    private void notifyCreateFailedError(Project project, String message) {
        this.notifyError(project, TfPluginBundle.message("CreatePullRequestDialog.Errors.CreateFailed.Title", new Object[0]), message);
    }

    private void notifyError(Project project, String title, String message) {
        if (message != null) {
            VcsNotifier.getInstance((Project)project).notifyError(title, message);
        } else {
            VcsNotifier.getInstance((Project)project).notifyError(title, "");
        }
    }

    private void notifySuccess(Project project, String title, String message) {
        VcsNotifier.getInstance((Project)project).notifyImportantInfo(title, message, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification n, @NotNull HyperlinkEvent e) {
                BrowserUtil.browse((URL)e.getURL());
            }
        });
        EventContextHelper.triggerPullRequestChanged("createPullRequest", project);
    }

    void setApplicationProvider(ApplicationProvider applicationProvider) {
        this.applicationProvider = applicationProvider;
    }

    static class ApplicationProvider {
        ApplicationProvider() {
        }

        public Application getApplication() {
            return ApplicationManager.getApplication();
        }

        public void invokeAndWaitWithAnyModality(Runnable r) {
            this.getApplication().invokeAndWait(r, ModalityState.any());
        }
    }
}

