/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.pullrequest;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitCommit;
import git4idea.GitRevisionNumber;
import git4idea.changes.GitChangeUtils;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import git4idea.util.GitCommitCompareInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DiffCompareInfoProvider {
    private GitUtilWrapper utilWrapper = new GitUtilWrapper();

    public GitCommitCompareInfo getBranchCompareInfo(Project project, GitRepository gitRepository, String source, String target) throws VcsException {
        String commonParentHash;
        GitRevisionNumber commonParentRevision = this.getUtilWrapper().getMergeBase(project, gitRepository.getRoot(), target, source);
        String string = commonParentHash = commonParentRevision != null ? commonParentRevision.getRev() : null;
        if (commonParentHash == null) {
            return this.getEmptyDiff(gitRepository);
        }
        return this.getCompareInfo(project, gitRepository, source, commonParentHash);
    }

    private GitCommitCompareInfo getCompareInfo(Project project, GitRepository gitRepository, String source, String target) throws VcsException {
        VirtualFile root = gitRepository.getRoot();
        List<GitCommit> commits1 = this.getUtilWrapper().history(project, root, ".." + target);
        List<GitCommit> commits2 = this.getUtilWrapper().history(project, root, target + "..");
        Collection<Change> diff = this.getUtilWrapper().getDiff(project, root, target, source);
        GitCommitCompareInfo info = new GitCommitCompareInfo(GitCommitCompareInfo.InfoType.BRANCH_TO_HEAD);
        info.put(gitRepository, diff);
        info.put(gitRepository, new Pair(commits1, commits2));
        return info;
    }

    public GitCommitCompareInfo getEmptyDiff(GitRepository gitRepository) {
        GitCommitCompareInfo emptyCompareInfo = new GitCommitCompareInfo(GitCommitCompareInfo.InfoType.BRANCH_TO_HEAD);
        emptyCompareInfo.put(gitRepository, new Pair(Collections.emptyList(), Collections.emptyList()));
        emptyCompareInfo.put(gitRepository, Collections.emptyList());
        return emptyCompareInfo;
    }

    public GitUtilWrapper getUtilWrapper() {
        return this.utilWrapper;
    }

    public void setUtilWrapper(GitUtilWrapper utilWrapper) {
        this.utilWrapper = utilWrapper;
    }

    static class GitUtilWrapper {
        GitUtilWrapper() {
        }

        public List<GitCommit> history(Project project, VirtualFile root, String parameters) throws VcsException {
            return GitHistoryUtils.history((Project)project, (VirtualFile)root, (String[])new String[]{parameters});
        }

        public GitRevisionNumber getMergeBase(Project project, VirtualFile root, String target, String source) throws VcsException {
            return GitHistoryUtils.getMergeBase((Project)project, (VirtualFile)root, (String)target, (String)source);
        }

        public Collection<Change> getDiff(Project project, VirtualFile root, String target, String source) throws VcsException {
            return GitChangeUtils.getDiff((Project)project, (VirtualFile)root, (String)target, (String)source, null);
        }
    }
}

