/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.pullrequest;

import com.intellij.openapi.util.Pair;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.rest.GitPullRequestEx;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.sourcecontrol.webapi.GitHttpClient;
import com.microsoft.alm.sourcecontrol.webapi.model.GitPullRequest;
import com.microsoft.alm.sourcecontrol.webapi.model.GitPullRequestSearchCriteria;
import com.microsoft.alm.sourcecontrol.webapi.model.PullRequestStatus;
import com.microsoft.visualstudio.services.webapi.model.ResourceRef;
import git4idea.GitCommit;
import git4idea.GitRemoteBranch;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestHelper {
    private static final Logger logger = LoggerFactory.getLogger(PullRequestHelper.class);
    public static final String PR_EXISTS_EXCEPTION_NAME = "GitPullRequestExistsException";
    public static final String PR_EXISTS_EXCEPTION_CODE = "TF401179";
    private static final String WEB_ACCESS_PR_FORMAT = "%s/pullrequest/%d#view=discussion";
    private static final String TF_REF_FORMATTER = "refs/heads/%s";

    public String createDefaultTitle(List<GitCommit> commits, String sourceBranchName, String targetBranchName) {
        if (commits == null || commits.isEmpty()) {
            return "";
        }
        if (commits.size() == 1) {
            GitCommit commit = commits.get(0);
            String commitMessage = commit.getSubject();
            int titleLength = 120;
            if (commitMessage.length() < 120) {
                return commitMessage;
            }
            String shortCommitMessage = commitMessage.substring(0, 120);
            return StringUtils.substringBeforeLast((String)shortCommitMessage, (String)"\\s+");
        }
        return TfPluginBundle.message("CreatePullRequestDialog.Default.Title", sourceBranchName, targetBranchName);
    }

    public String createDefaultDescription(List<GitCommit> commits) {
        if (commits == null || commits.isEmpty()) {
            return "";
        }
        if (commits.size() == 1) {
            GitCommit commit = commits.get(0);
            if (commit.getFullMessage().length() > 4000) {
                return commit.getFullMessage().substring(0, 3995) + "...";
            }
            return commit.getFullMessage();
        }
        StringBuilder descBuilder = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        int descCommitsLimit = 10;
        for (int i = 0; i < 10 && i < commits.size(); ++i) {
            GitCommit commit = commits.get(i);
            descBuilder.append("-").append(commit.getSubject()).append(lineSeparator);
        }
        if (commits.size() > 10) {
            descBuilder.append("...");
        }
        return descBuilder.length() < 4000 ? descBuilder.toString() : descBuilder.substring(0, 3990);
    }

    public String getHtmlMsg(String repositoryRemoteUrl, int id) {
        String text = TfPluginBundle.message("CreatePullRequestDialog.Created.Message", String.valueOf(id));
        String webAccessUrl = String.format(WEB_ACCESS_PR_FORMAT, repositoryRemoteUrl, id);
        return String.format("<html><body><a href=\"%s\">%s</a></body></html>", webAccessUrl, text);
    }

    public GitPullRequestEx generateGitPullRequest(@NotNull String title, @NotNull String description, @NotNull String branchNameOnRemoteServer, @NotNull GitRemoteBranch targetBranch, @NotNull Set<Integer> workItems, @NotNull ServerContext context) {
        GitPullRequestEx pullRequest = new GitPullRequestEx();
        pullRequest.setTitle(title);
        pullRequest.setDescription(description);
        pullRequest.setSourceRefName(this.getVSORefName(branchNameOnRemoteServer));
        pullRequest.setTargetRefName(this.getVSORefName(targetBranch.getNameForRemoteOperations()));
        try {
            if (!workItems.isEmpty()) {
                ResourceRef[] workItemRefs = new ResourceRef[workItems.size()];
                int count = 0;
                for (int workItemId : workItems) {
                    ResourceRef ref = new ResourceRef();
                    ref.setId(String.valueOf(workItemId));
                    ref.setUrl(UrlHelper.getWorkItemRefURI((URI)context.getTeamProjectURI(), (String)String.valueOf(workItemId)).toString());
                    workItemRefs[count] = ref;
                    ++count;
                }
                pullRequest.setWorkItemRefs(workItemRefs);
            }
        }
        catch (Exception e) {
            logger.warn("Error while adding work items to pull request", (Throwable)e);
        }
        return pullRequest;
    }

    public Pair<PRCreateStatus, String> parseException(Throwable t, String sourceBranch, GitRemoteBranch targetBranch, ServerContext context, GitHttpClient gitClient) {
        if (t == null) {
            return Pair.create((Object)((Object)PRCreateStatus.UNKNOWN), (Object)"");
        }
        if (StringUtils.contains((String)t.getMessage(), (String)PR_EXISTS_EXCEPTION_NAME) || StringUtils.contains((String)t.getMessage(), (String)PR_EXISTS_EXCEPTION_CODE)) {
            try {
                UUID repoId = context.getGitRepository().getId();
                GitPullRequestSearchCriteria searchCriteria = new GitPullRequestSearchCriteria();
                searchCriteria.setRepositoryId(repoId);
                searchCriteria.setStatus(PullRequestStatus.ACTIVE);
                searchCriteria.setSourceRefName(this.getVSORefName(sourceBranch));
                searchCriteria.setTargetRefName(this.getVSORefName(targetBranch.getNameForRemoteOperations()));
                List pullRequests = gitClient.getPullRequests(repoId, searchCriteria, null, Integer.valueOf(0), Integer.valueOf(1));
                if (pullRequests != null && pullRequests.size() > 0) {
                    String repositoryRemoteUrl = context.getGitRepository().getRemoteUrl();
                    String notifyMsgInHtml = this.getHtmlMsg(repositoryRemoteUrl, ((GitPullRequest)pullRequests.get(0)).getPullRequestId());
                    return Pair.create((Object)((Object)PRCreateStatus.DUPLICATE), (Object)notifyMsgInHtml);
                }
            }
            catch (Throwable innerT) {
                logger.error("Failed to retrieve existing pull request", innerT);
                return Pair.create((Object)((Object)PRCreateStatus.FAILED), (Object)t.getMessage());
            }
        }
        return Pair.create((Object)((Object)PRCreateStatus.FAILED), (Object)t.getMessage());
    }

    private String getVSORefName(String name) {
        return String.format(TF_REF_FORMATTER, name);
    }

    public static enum PRCreateStatus {
        UNKNOWN,
        FAILED,
        SUCCESS,
        DUPLICATE;

    }
}

