/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.pullrequest;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.microsoft.alm.plugin.idea.common.ui.common.tabs.TabFormImpl;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.PRTreeCellRenderer;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.PullRequestsTreeModel;
import com.microsoft.alm.plugin.operations.Operation;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class VcsPullRequestsForm
extends TabFormImpl<PullRequestsTreeModel> {
    private Tree pullRequestsTree;
    public static final String CMD_ABANDON_SELECTED_PR = "abandonSelectedPullRequest";
    public static final String TOOLBAR_LOCATION = "Vcs.PullRequests";
    private PullRequestsTreeModel pullRequestsTreeModel;

    public VcsPullRequestsForm() {
        super("VcsPullRequestsTab.Title", "CreatePullRequestDialog.Title", "VcsPullRequestsTab.Refresh.Tooltip", TOOLBAR_LOCATION);
        this.ensureInitialized();
    }

    @Override
    protected void createCustomView() {
        this.pullRequestsTree = new Tree();
        this.pullRequestsTree.setCellRenderer((TreeCellRenderer)new PRTreeCellRenderer());
        this.pullRequestsTree.setShowsRootHandles(true);
        this.pullRequestsTree.setRootVisible(false);
        this.pullRequestsTree.setRowHeight(0);
        this.scrollPanel = new JBScrollPane((Component)this.pullRequestsTree);
    }

    @Override
    protected void addCustomTools(JPanel toolBar) {
    }

    @Override
    public void setModelForView(PullRequestsTreeModel treeModel) {
        treeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                if (VcsPullRequestsForm.this.pullRequestsTreeModel != null) {
                    VcsPullRequestsForm.this.pullRequestsTree.expandRow(0);
                    VcsPullRequestsForm.this.pullRequestsTree.expandRow(VcsPullRequestsForm.this.pullRequestsTreeModel.getRequestedByMeRoot().getChildCount() + 1);
                }
            }
        });
        this.pullRequestsTreeModel = treeModel;
        this.pullRequestsTree.setModel((TreeModel)treeModel);
        this.pullRequestsTree.setSelectionModel(treeModel.getSelectionModel());
        this.searchFilter.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.onFilterChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.onFilterChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.onFilterChanged();
            }

            private void onFilterChanged() {
                if (VcsPullRequestsForm.this.timer.isRunning()) {
                    VcsPullRequestsForm.this.timer.restart();
                } else {
                    VcsPullRequestsForm.this.timer.start();
                }
            }
        });
    }

    @Override
    public void addActionListener(ActionListener listener) {
        super.addActionListener(listener);
        this.addTreeEventListeners(listener);
    }

    private void addTreeEventListeners(final ActionListener listener) {
        this.pullRequestsTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                if (mouseEvent.getClickCount() == 2) {
                    VcsPullRequestsForm.this.triggerEvent("openSelectedItem");
                } else if (mouseEvent.isPopupTrigger() || (mouseEvent.getModifiers() & 4) == 4) {
                    VcsPullRequestsForm.this.showPopupMenu(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), listener);
                }
            }
        });
        this.pullRequestsTree.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    VcsPullRequestsForm.this.triggerEvent("openSelectedItem");
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    @Override
    protected List<JBMenuItem> getMenuItems(ActionListener listener) {
        return Arrays.asList(this.createMenuItem("VcsTab.OpenInBrowser", null, "openSelectedItem", listener), this.createMenuItem("VcsPullRequestsTab.Abandon", null, CMD_ABANDON_SELECTED_PR, listener));
    }

    @Override
    public Operation.CredInputsImpl getOperationInputs() {
        return new Operation.CredInputsImpl();
    }

    @Override
    public void refresh(boolean isTeamServicesRepository) {
    }

    @VisibleForTesting
    Tree getPullRequestTree() {
        return this.pullRequestsTree;
    }
}

