/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.pullrequest;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsNotifier;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.tabs.TabModelImpl;
import com.microsoft.alm.plugin.idea.common.utils.EventContextHelper;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.CreatePullRequestController;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.PullRequestsTabLookupListener;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.PullRequestsTreeModel;
import com.microsoft.alm.plugin.idea.git.utils.TfGitHelper;
import com.microsoft.alm.plugin.operations.Operation;
import com.microsoft.alm.plugin.operations.PullRequestLookupOperation;
import com.microsoft.alm.sourcecontrol.webapi.model.GitPullRequest;
import com.microsoft.alm.sourcecontrol.webapi.model.PullRequestStatus;
import git4idea.repo.GitRepository;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcsPullRequestsModel
extends TabModelImpl<PullRequestsTreeModel> {
    private static final Logger logger = LoggerFactory.getLogger(VcsPullRequestsModel.class);
    private final GitRepository gitRepository;

    public VcsPullRequestsModel(@NotNull Project project) {
        super(project, new PullRequestsTreeModel(), "PullRequestsTab.");
        this.operationInputs = new Operation.CredInputsImpl();
        this.gitRepository = VcsHelper.getGitRepository(project);
    }

    @Override
    protected void createDataProvider() {
        this.dataProvider = new PullRequestsTabLookupListener(this);
    }

    private boolean isTfGitRepository() {
        return this.isTeamServicesRepository() && this.gitRepository != null;
    }

    @Override
    public void openGitRepoLink() {
        ServerContext context;
        if (this.isTfGitRepository() && (context = TfGitHelper.getSavedServerContext(this.gitRepository)) != null && context.getGitRepository() != null && StringUtils.isNotEmpty((String)context.getGitRepository().getRemoteUrl())) {
            BrowserUtil.browse((String)context.getGitRepository().getRemoteUrl().concat("/").concat("pullrequests"));
        }
    }

    @Override
    public void openSelectedItemsLink() {
        if (this.isTfGitRepository()) {
            ServerContext context = TfGitHelper.getSavedServerContext(this.gitRepository);
            GitPullRequest pullRequest = this.getSelectedPullRequest();
            if (context != null && pullRequest != null) {
                BrowserUtil.browse((String)this.getPullRequestWebLink(context.getGitRepository().getRemoteUrl(), pullRequest.getPullRequestId()));
            }
        }
    }

    private String getPullRequestWebLink(String gitRemoteUrl, int pullRequestId) {
        return gitRemoteUrl.concat("/").concat("pullrequest").concat("/" + pullRequestId);
    }

    public void abandonSelectedPullRequest() {
        if (this.isTfGitRepository()) {
            final ServerContext context = TfGitHelper.getSavedServerContext(this.gitRepository);
            Task.Backgroundable abandonPullRequestTask = new Task.Backgroundable(this.project, TfPluginBundle.message("VcsPullRequestsTab.Title", new Object[0])){
                boolean abandonPR;

                public void run(ProgressIndicator indicator) {
                    block6: {
                        GitPullRequest pullRequest = VcsPullRequestsModel.this.getSelectedPullRequest();
                        if (pullRequest != null) {
                            String prLink = VcsPullRequestsModel.this.getPullRequestWebLink(context.getGitRepository().getRemoteUrl(), pullRequest.getPullRequestId());
                            final int prId = pullRequest.getPullRequestId();
                            IdeaHelper.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    abandonPR = IdeaHelper.showConfirmationDialog(VcsPullRequestsModel.this.project, TfPluginBundle.message("VcsPullRequestsTab.Abandon.Confirmation", prId), TfPluginBundle.message("VcsPullRequestsTab.Title", new Object[0]), Icons.VSLogo, Messages.YES_BUTTON, Messages.NO_BUTTON);
                                }
                            }, true, indicator.getModalityState());
                            if (this.abandonPR) {
                                try {
                                    GitPullRequest pullRequestToUpdate = new GitPullRequest();
                                    pullRequestToUpdate.setStatus(PullRequestStatus.ABANDONED);
                                    GitPullRequest pr = context.getGitHttpClient().updatePullRequest(pullRequestToUpdate, pullRequest.getRepository().getId(), pullRequest.getPullRequestId());
                                    if (pr != null && pr.getStatus() == PullRequestStatus.ABANDONED) {
                                        VcsPullRequestsModel.this.notifyOperationStatus(true, TfPluginBundle.message("VcsPullRequestsTab.Abandon.Succeeded", prLink, prId));
                                        break block6;
                                    }
                                    logger.warn("abandonSelectedPullRequest: pull request status not ABANDONED as expected. Actual status = {}", pr != null ? pr.getStatus() : "null");
                                    VcsPullRequestsModel.this.notifyOperationStatus(false, TfPluginBundle.message("VcsPullRequestsTab.Abandon.Failed", prLink, prId));
                                }
                                catch (Throwable t) {
                                    logger.warn("abandonSelectedPullRequest: Unexpected exception", t);
                                    VcsPullRequestsModel.this.notifyOperationStatus(false, TfPluginBundle.message("VcsPullRequestsTab.Abandon.Failed", prLink, prId));
                                }
                            }
                        } else {
                            VcsPullRequestsModel.this.notifyOperationStatus(false, TfPluginBundle.message("VcsPullRequestsTab.Abandon.Failed.NoSelection", new Object[0]));
                        }
                    }
                }
            };
            if (context != null) {
                abandonPullRequestTask.queue();
            }
        }
    }

    private GitPullRequest getSelectedPullRequest() {
        ServerContext context;
        if (this.isTfGitRepository() && (context = TfGitHelper.getSavedServerContext(this.gitRepository)) != null && context.getGitRepository() != null && StringUtils.isNotEmpty((String)context.getGitRepository().getRemoteUrl())) {
            return ((PullRequestsTreeModel)this.viewForModel).getSelectedPullRequest();
        }
        return null;
    }

    private void notifyOperationStatus(boolean success, String message) {
        if (success) {
            VcsNotifier.getInstance((Project)this.project).notifySuccess(TfPluginBundle.message("VcsPullRequestsTab.Title", new Object[0]), message, NotificationListener.URL_OPENING_LISTENER);
        } else {
            VcsNotifier.getInstance((Project)this.project).notifyError(TfPluginBundle.message("VcsPullRequestsTab.Title", new Object[0]), message, NotificationListener.URL_OPENING_LISTENER);
        }
        EventContextHelper.triggerPullRequestChanged("abandonPullReguest", this.project);
    }

    @Override
    public void appendData(Operation.Results results) {
        PullRequestLookupOperation.PullRequestLookupResults lookupResults = (PullRequestLookupOperation.PullRequestLookupResults)results;
        ((PullRequestsTreeModel)this.viewForModel).appendPullRequests(lookupResults.getPullRequests(), lookupResults.getScope());
    }

    @Override
    public void clearData() {
        ((PullRequestsTreeModel)this.viewForModel).clearPullRequests();
    }

    @Override
    public void createNewItem() {
        if (!this.isTeamServicesRepository() || this.gitRepository == null) {
            return;
        }
        CreatePullRequestController createPullRequestController = new CreatePullRequestController(this.project, this.gitRepository);
        createPullRequestController.showModalDialog();
    }
}

