/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.vcsimport;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextTableModel;
import com.microsoft.alm.plugin.idea.common.ui.common.SwingHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.TableFocusListener;
import com.microsoft.alm.plugin.idea.common.ui.common.TableModelSelectionConverter;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.BasicForm;
import com.microsoft.alm.plugin.idea.common.ui.controls.BusySpinnerPanel;
import com.microsoft.alm.plugin.idea.common.ui.controls.HelpPanel;
import com.microsoft.alm.plugin.idea.common.ui.controls.HintTextFieldUI;
import com.microsoft.alm.plugin.idea.common.ui.controls.UserAccountPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableRowSorter;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NonNls;

public class ImportForm
implements BasicForm {
    private JPanel contentPanel;
    private UserAccountPanel userAccountPanel;
    private JTextField teamProjectFilter;
    private JTable teamProjectTable;
    private JTextField repositoryName;
    private JButton refreshButton;
    private BusySpinnerPanel busySpinner;
    private JScrollPane teamProjectScrollPane;
    private HelpPanel helpPanel;
    private boolean initialized = false;
    private Timer timer;
    @NonNls
    public static final String CMD_PROJECT_FILTER_CHANGED = "teamProjectFilterChanged";
    @NonNls
    public static final String CMD_REFRESH = "refresh";
    @NonNls
    public static final String CMD_GOTO_TFS = "gotoTFS";
    @NonNls
    public static final String CMD_GOTO_SPS_PROFILE = "gotoSPSProfile";

    public ImportForm(boolean vsoSelected) {
        this.$$$setupUI$$$();
        this.userAccountPanel.setWindowsAccount(!vsoSelected);
    }

    @Override
    public JPanel getContentPanel() {
        this.ensureInitialized();
        return this.contentPanel;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.teamProjectFilter.setActionCommand(CMD_PROJECT_FILTER_CHANGED);
            this.refreshButton.setActionCommand(CMD_REFRESH);
            SwingHelper.scaleTableRowHeight(this.teamProjectTable);
            SwingHelper.fixTabKeys(this.teamProjectTable);
            this.teamProjectTable.addFocusListener(new TableFocusListener(this.teamProjectTable));
            this.helpPanel.addPopupCommand(TfPluginBundle.message("VsoLookupHelp.EnterUrl", new Object[0]), CMD_GOTO_TFS);
            this.helpPanel.addPopupCommand(TfPluginBundle.message("VsoLookupHelp.ViewAccounts", new Object[0]), CMD_GOTO_SPS_PROFILE);
            this.helpPanel.setVisible(false);
            this.teamProjectFilter.setUI(new HintTextFieldUI(TfPluginBundle.message("ImportDialog.FilterHint", new Object[0])));
            int refreshButtonHeight = (int)this.refreshButton.getMinimumSize().getHeight();
            Dimension size = new Dimension(refreshButtonHeight, refreshButtonHeight);
            this.refreshButton.setMinimumSize(size);
            this.refreshButton.setPreferredSize(size);
            this.busySpinner.setMinimumSize(size);
            this.busySpinner.setPreferredSize(size);
            this.teamProjectFilter.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.onFilterChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.onFilterChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.onFilterChanged();
                }

                private void onFilterChanged() {
                    if (ImportForm.this.timer.isRunning()) {
                        ImportForm.this.timer.restart();
                    } else {
                        ImportForm.this.timer.start();
                    }
                }
            });
            this.teamProjectScrollPane.setMinimumSize(new Dimension(JBUI.scale((int)200), JBUI.scale((int)70)));
            this.teamProjectTable.setRowHeight(this.teamProjectTable.getFontMetrics(this.teamProjectTable.getFont()).getHeight());
            this.initialized = true;
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.userAccountPanel.addActionListener(listener);
        this.timer.addActionListener(listener);
        this.refreshButton.addActionListener(listener);
        this.helpPanel.addActionListener(listener);
    }

    public void setTeamProjectFilter(String filter) {
        this.teamProjectFilter.setText(filter);
    }

    public String getTeamProjectFilter() {
        return this.teamProjectFilter.getText();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.teamProjectFilter;
    }

    public void setTeamProjectTable(ServerContextTableModel tableModel, ListSelectionModel selectionModel) {
        this.teamProjectTable.setModel(tableModel);
        this.teamProjectTable.setSelectionModel(selectionModel);
        TableRowSorter<ServerContextTableModel> sorter = new TableRowSorter<ServerContextTableModel>(tableModel);
        this.teamProjectTable.setRowSorter(sorter);
        tableModel.setSelectionConverter(new TableModelSelectionConverter(){

            @Override
            public int convertRowIndexToModel(int viewRowIndex) {
                if (viewRowIndex >= 0) {
                    return ImportForm.this.teamProjectTable.convertRowIndexToModel(viewRowIndex);
                }
                return viewRowIndex;
            }
        });
    }

    public void setRepositoryName(String name) {
        this.repositoryName.setText(name);
    }

    public String getRepositoryName() {
        return StringUtils.trim((String)this.repositoryName.getText());
    }

    public JComponent getRepositoryNameComponent() {
        return this.repositoryName;
    }

    public void setUserName(String name) {
        this.userAccountPanel.setUserName(name);
    }

    public void setServerName(String name) {
        this.userAccountPanel.setServerName(name);
        if (!this.userAccountPanel.isWindowsAccount() || UrlHelper.isTeamServicesUrl((String)name)) {
            this.helpPanel.setVisible(true);
        } else {
            this.helpPanel.setVisible(false);
        }
    }

    public void setLoading(boolean loading) {
        if (loading) {
            this.refreshButton.setVisible(false);
            this.busySpinner.start(true);
        } else {
            this.busySpinner.stop(true);
            this.refreshButton.setVisible(true);
        }
    }

    private void createUIComponents() {
        this.userAccountPanel = new UserAccountPanel();
        this.refreshButton = new JButton(AllIcons.Actions.Refresh);
        this.timer = new Timer(400, null);
        this.timer.setInitialDelay(400);
        this.timer.setActionCommand(CMD_PROJECT_FILTER_CHANGED);
        this.timer.setRepeats(false);
    }

    @VisibleForTesting
    BusySpinnerPanel getBusySpinner() {
        return this.busySpinner;
    }

    @VisibleForTesting
    UserAccountPanel getUserAccountPanel() {
        return this.userAccountPanel;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPanel.add((Component)this.userAccountPanel, new GridConstraints(0, 0, 1, 3, 4, 0, 3, 3, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ImportForm.SelectTeamProject"));
        this.contentPanel.add((Component)label1, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null, 0, false));
        this.teamProjectFilter = new JTextField();
        this.contentPanel.add((Component)this.teamProjectFilter, new GridConstraints(2, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.teamProjectScrollPane = new JScrollPane();
        this.contentPanel.add((Component)this.teamProjectScrollPane, new GridConstraints(3, 0, 1, 3, 0, 3, 5, 5, null, null, null, 0, false));
        this.teamProjectTable = new JTable();
        this.teamProjectTable.setFillsViewportHeight(true);
        this.teamProjectTable.setShowHorizontalLines(false);
        this.teamProjectTable.setShowVerticalLines(false);
        this.teamProjectScrollPane.setViewportView(this.teamProjectTable);
        JLabel label2 = new JLabel();
        this.$$$loadLabelText$$$(label2, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ImportForm.NewRepositoryName"));
        this.contentPanel.add((Component)label2, new GridConstraints(5, 0, 1, 3, 8, 0, 0, 0, null, null, null, 0, false));
        this.repositoryName = new JTextField();
        this.contentPanel.add((Component)this.repositoryName, new GridConstraints(6, 0, 1, 3, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.refreshButton.setText("");
        this.refreshButton.setToolTipText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ImportDialog.RefreshButton.ToolTip"));
        this.contentPanel.add((Component)this.refreshButton, new GridConstraints(2, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.busySpinner = new BusySpinnerPanel();
        this.contentPanel.add((Component)this.busySpinner, new GridConstraints(2, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.helpPanel = new HelpPanel();
        this.helpPanel.setHelpText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoLookupHelp.helpText"));
        this.helpPanel.setPopupText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoLookupHelp.Instructions"));
        this.contentPanel.add((Component)this.helpPanel, new GridConstraints(4, 0, 1, 3, 4, 0, 3, 3, null, null, null, 0, false));
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }
}

