/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.vcsimport;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.microsoft.alm.plugin.idea.common.ui.common.PageModelImpl;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportPageModel;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.TfsImportPageModel;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.VsoImportPageModel;

public class ImportModel
extends PageModelImpl {
    private boolean vsoSelected = true;
    private boolean importEnabledForVso = false;
    private boolean importEnabledForTfs = false;
    private final ImportPageModel vsoImportPageModel;
    private final ImportPageModel tfsImportPageModel;
    private final Project project;
    public static final String PROP_VSO_SELECTED = "vsoSelected";
    public static final String PROP_IMPORT_ENABLED = "importEnabled";

    public ImportModel(Project project) {
        this(project, null, null, true);
    }

    @VisibleForTesting
    public ImportModel(Project project, ImportPageModel vsoImportPageModel, ImportPageModel tfsImportPageModel, boolean autoLoad) {
        this.project = project;
        this.vsoImportPageModel = vsoImportPageModel == null ? new VsoImportPageModel(this, autoLoad) : vsoImportPageModel;
        this.tfsImportPageModel = tfsImportPageModel == null ? new TfsImportPageModel(this) : tfsImportPageModel;
        this.updateImportEnabled();
    }

    public boolean isVsoSelected() {
        return this.vsoSelected;
    }

    public void setVsoSelected(boolean value) {
        if (this.vsoSelected != value) {
            this.vsoSelected = value;
            super.setChangedAndNotify(PROP_VSO_SELECTED);
        }
    }

    public ImportPageModel getVsoImportPageModel() {
        return this.vsoImportPageModel;
    }

    public ImportPageModel getTfsImportPageModel() {
        return this.tfsImportPageModel;
    }

    public Project getProject() {
        return this.project;
    }

    public void dispose() {
        this.vsoImportPageModel.dispose();
        this.tfsImportPageModel.dispose();
    }

    public boolean isImportEnabled() {
        if (this.isVsoSelected()) {
            return this.importEnabledForVso;
        }
        return this.importEnabledForTfs;
    }

    public void updateImportEnabled() {
        if (this.vsoImportPageModel != null) {
            this.setImportEnabledForVso(this.vsoImportPageModel.isConnected());
        }
        if (this.tfsImportPageModel != null) {
            this.setImportEnabledForTfs(this.tfsImportPageModel.isConnected());
        }
    }

    protected void setImportEnabledForVso(boolean value) {
        if (this.importEnabledForVso != value) {
            this.importEnabledForVso = value;
            super.setChangedAndNotify(PROP_IMPORT_ENABLED);
        }
    }

    protected void setImportEnabledForTfs(boolean value) {
        if (this.importEnabledForTfs != value) {
            this.importEnabledForTfs = value;
            super.setChangedAndNotify(PROP_IMPORT_ENABLED);
        }
    }
}

