/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.vcsimport;

import com.microsoft.alm.plugin.idea.common.ui.common.AbstractController;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportController;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportPage;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportPageModel;
import java.awt.event.ActionEvent;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ImportPageController
extends AbstractController {
    private final ImportPage page;
    private final ImportPageModel pageModel;
    private final ImportController parentController;

    public ImportPageController(ImportController parentController, ImportPageModel pageModel, ImportPage page) {
        this.parentController = parentController;
        this.pageModel = pageModel;
        this.pageModel.addObserver(this);
        this.page = page;
        this.page.addActionListener(this);
        this.update(null, null);
    }

    public JPanel getPageAsPanel() {
        if (this.page instanceof JPanel) {
            return (JPanel)((Object)this.page);
        }
        return null;
    }

    public JComponent getComponent(String name) {
        return this.page.getComponent(name);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == null || arg.equals("connected")) {
            this.page.setLoginShowing(!this.pageModel.isConnected());
        }
        if (arg == null || arg.equals("loading")) {
            this.page.setLoading(this.pageModel.isLoading());
        }
        if (arg == null || arg.equals("authenticating")) {
            this.page.setAuthenticating(this.pageModel.isAuthenticating());
        }
        if (arg == null || arg.equals("repositoryName")) {
            this.page.setRepositoryName(this.pageModel.getRepositoryName());
        }
        if (arg == null || arg.equals("teamProjectFilter")) {
            this.page.setTeamProjectFilter(this.pageModel.getTeamProjectFilter());
        }
        if (arg == null || arg.equals("userName")) {
            this.page.setUserName(this.pageModel.getUserName());
        }
        if (arg == null || arg.equals("serverName")) {
            this.page.setServerName(this.pageModel.getServerName());
        }
        if (arg == null) {
            this.page.setTeamProjectTable(this.pageModel.getTableModel(), this.pageModel.getTableSelectionModel());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModel();
        this.pageModel.clearErrors();
        if ("createAccount".equals(e.getActionCommand())) {
            this.pageModel.gotoLink("https://go.microsoft.com/fwlink/?LinkId=307137&wt.mc_id=o~msft~java~intellij");
        } else if ("learnMore".equals(e.getActionCommand())) {
            this.pageModel.gotoLink("http://java.visualstudio.com");
        } else if ("signIn".equals(e.getActionCommand())) {
            this.pageModel.loadTeamProjects();
            super.requestFocus(this.page);
        } else if ("refresh".equals(e.getActionCommand())) {
            this.pageModel.loadTeamProjects();
        } else if ("signOut".equals(e.getActionCommand())) {
            this.pageModel.signOut();
            super.requestFocus(this.page);
        } else if (!"teamProjectFilterChanged".equals(e.getActionCommand())) {
            if ("gotoTFS".equals(e.getActionCommand())) {
                this.parentController.gotoEnterVsoURL();
            } else if ("gotoSPSProfile".equals(e.getActionCommand())) {
                this.pageModel.gotoLink("https://app.vssps.visualstudio.com");
            }
        }
    }

    @Override
    protected void updateModel() {
        this.pageModel.setRepositoryName(this.page.getRepositoryName());
        this.pageModel.setTeamProjectFilter(this.page.getTeamProjectFilter());
        this.pageModel.setServerName(this.page.getServerName());
    }
}

