/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.vcsimport;

import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.alm.client.model.VssServiceException;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.core.webapi.CoreHttpClient;
import com.microsoft.alm.core.webapi.model.TeamProject;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextBuilder;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.context.rest.GitHttpClientEx;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.LoginPageModelImpl;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextLookupListener;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextLookupPageModel;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextTableModel;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportModel;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportPageModel;
import com.microsoft.alm.plugin.telemetry.TfsTelemetryHelper;
import git4idea.DialogManager;
import git4idea.GitUtil;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleHandler;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ListSelectionModel;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImportPageModelImpl
extends LoginPageModelImpl
implements ImportPageModel,
ServerContextLookupPageModel {
    private static final Logger logger = LoggerFactory.getLogger(ImportPageModelImpl.class);
    private ImportModel parentDialogModel;
    private boolean loading = false;
    private boolean importEnabled = false;
    private String teamProjectFilter = "";
    private String repositoryName = "";
    private final ServerContextTableModel teamProjectTableModel;
    private final ServerContextLookupListener teamProjectProvider;
    private static final String ACTION_NAME = "import";
    private static final String REMOTE_ORIGIN = "origin";
    private static final String PROJECT_CAPABILITY_VC = "versioncontrol";
    private static final String PROJECT_CAPABILITY_VC_TYPE = "sourceControlType";
    private static final String PROJECT_CAPABILITY_VC_GIT = "Git";

    public ImportPageModelImpl(ImportModel importModel, ServerContextTableModel.Column[] columns) {
        super(importModel);
        this.parentDialogModel = importModel;
        this.teamProjectTableModel = new ServerContextTableModel(columns);
        this.teamProjectProvider = new ServerContextLookupListener(this);
        if (ApplicationManager.getApplication() != null) {
            this.repositoryName = importModel.getProject().getName();
        }
    }

    protected ImportModel getParentModel() {
        return this.parentDialogModel;
    }

    protected void setParentModel(ImportModel parentDialogModel) {
        this.parentDialogModel = parentDialogModel;
    }

    protected ServerContextLookupListener getTeamProjectProvider() {
        return this.teamProjectProvider;
    }

    protected abstract AuthenticationInfo getAuthenticationInfo();

    @Override
    public void signOut() {
        super.signOut();
        this.setConnected(false);
        this.setLoading(false);
        this.clearContexts();
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public void setRepositoryName(String repositoryName) {
        if (!StringUtils.equals((String)this.repositoryName, (String)repositoryName)) {
            this.repositoryName = repositoryName;
            this.setChangedAndNotify("repositoryName");
        }
    }

    @Override
    public String getTeamProjectFilter() {
        return this.teamProjectFilter;
    }

    @Override
    public void setTeamProjectFilter(String teamProjectFilter) {
        if (!StringUtils.equals((String)this.teamProjectFilter, (String)teamProjectFilter)) {
            this.teamProjectFilter = teamProjectFilter;
            this.setChangedAndNotify("teamProjectFilter");
            this.teamProjectTableModel.setFilter(teamProjectFilter);
        }
    }

    @Override
    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public void setLoading(boolean loading) {
        if (this.loading != loading) {
            this.loading = loading;
            this.setChangedAndNotify("loading");
        }
    }

    @Override
    public void setImportEnabled(boolean importEnabled) {
        if (this.importEnabled != importEnabled) {
            this.importEnabled = importEnabled;
            if (this.getParentModel() != null) {
                this.getParentModel().updateImportEnabled();
            }
        }
    }

    @Override
    public void setConnected(boolean connected) {
        super.setConnected(connected);
        this.setImportEnabled(connected);
    }

    @Override
    public void importIntoRepository() {
        ModelValidationInfo validationInfo = this.validate();
        if (validationInfo == null) {
            ServerContext selectedContext = this.getSelectedContext();
            ServerContext context = super.completeSignIn(selectedContext);
            Project project = this.getParentModel().getProject();
            this.doImport(project, context, this.getRepositoryName());
        }
    }

    private void doImport(final Project project, final ServerContext context, final String repositoryName) {
        new Task.Backgroundable(project, TfPluginBundle.message("Import.ImportingProject", new Object[0]), true, PerformInBackgroundOption.DEAF){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run(@NotNull ProgressIndicator indicator) {
                com.microsoft.alm.sourcecontrol.webapi.model.GitRepository remoteRepository;
                String remoteUrlForDisplay;
                ServerContext localContext;
                block16: {
                    GitRepository localRepository;
                    block15: {
                        block14: {
                            block13: {
                                VirtualFile rootVirtualFile;
                                block12: {
                                    block11: {
                                        localContext = context;
                                        remoteUrlForDisplay = "";
                                        if (ImportPageModelImpl.this.projectSupportsGitRepos(project, context, indicator)) break block11;
                                        logger.error("doImport: the team project {} on collection {} , server {} does not support Git repositories or is not a hybrid project", new Object[]{localContext.getTeamProjectReference().getName(), localContext.getTeamProjectCollectionReference().getName(), localContext.getUri()});
                                        if (!StringUtils.isNotEmpty((String)remoteUrlForDisplay)) return;
                                        VcsNotifier.getInstance((Project)project).notifyImportantInfo(TfPluginBundle.message("Import.Succeeded", new Object[0]), TfPluginBundle.message("Import.Succeeded.Message", project.getName(), remoteUrlForDisplay, repositoryName), NotificationListener.URL_OPENING_LISTENER);
                                        TfsTelemetryHelper.sendEventAsync((String)ImportPageModelImpl.ACTION_NAME, (Map)new TfsTelemetryHelper.PropertyMapBuilder().currentOrActiveContext(localContext).actionName(ImportPageModelImpl.ACTION_NAME).success(Boolean.valueOf(true)).build());
                                        return;
                                    }
                                    GitRepository repo = ImportPageModelImpl.this.getRepositoryForProject(project);
                                    rootVirtualFile = repo != null ? repo.getRoot() : project.getBaseDir();
                                    GitRepository gitRepository = localRepository = repo != null ? repo : ImportPageModelImpl.this.setupGitRepositoryForProject(project, rootVirtualFile, localContext, indicator);
                                    if (localRepository != null) break block12;
                                    logger.error("doImport: current project {} is not in a Git repository", (Object)project.getName());
                                    if (!StringUtils.isNotEmpty((String)remoteUrlForDisplay)) return;
                                    VcsNotifier.getInstance((Project)project).notifyImportantInfo(TfPluginBundle.message("Import.Succeeded", new Object[0]), TfPluginBundle.message("Import.Succeeded.Message", project.getName(), remoteUrlForDisplay, repositoryName), NotificationListener.URL_OPENING_LISTENER);
                                    TfsTelemetryHelper.sendEventAsync((String)ImportPageModelImpl.ACTION_NAME, (Map)new TfsTelemetryHelper.PropertyMapBuilder().currentOrActiveContext(localContext).actionName(ImportPageModelImpl.ACTION_NAME).success(Boolean.valueOf(true)).build());
                                    return;
                                }
                                if (ImportPageModelImpl.this.doFirstCommitIfRequired(project, localRepository, rootVirtualFile, localContext, indicator)) break block13;
                                logger.error("doImport: failed to do first commit on the local repository at: {}", (Object)localRepository.getRoot().getUrl());
                                if (!StringUtils.isNotEmpty((String)remoteUrlForDisplay)) return;
                                VcsNotifier.getInstance((Project)project).notifyImportantInfo(TfPluginBundle.message("Import.Succeeded", new Object[0]), TfPluginBundle.message("Import.Succeeded.Message", project.getName(), remoteUrlForDisplay, repositoryName), NotificationListener.URL_OPENING_LISTENER);
                                TfsTelemetryHelper.sendEventAsync((String)ImportPageModelImpl.ACTION_NAME, (Map)new TfsTelemetryHelper.PropertyMapBuilder().currentOrActiveContext(localContext).actionName(ImportPageModelImpl.ACTION_NAME).success(Boolean.valueOf(true)).build());
                                return;
                            }
                            remoteRepository = ImportPageModelImpl.this.createRemoteGitRepo(project, context, localContext, indicator);
                            if (remoteRepository != null) {
                                localContext = new ServerContextBuilder(localContext).uri(remoteRepository.getRemoteUrl()).repository(remoteRepository).build();
                                ServerContextManager.getInstance().add(localContext);
                                break block14;
                            }
                            logger.error("doImport: failed to create remote repository with name: {} on server: {}, collection: {}", new Object[]{repositoryName, localContext.getUri(), localContext.getTeamProjectCollectionReference().getName()});
                            if (!StringUtils.isNotEmpty((String)remoteUrlForDisplay)) return;
                            VcsNotifier.getInstance((Project)project).notifyImportantInfo(TfPluginBundle.message("Import.Succeeded", new Object[0]), TfPluginBundle.message("Import.Succeeded.Message", project.getName(), remoteUrlForDisplay, repositoryName), NotificationListener.URL_OPENING_LISTENER);
                            TfsTelemetryHelper.sendEventAsync((String)ImportPageModelImpl.ACTION_NAME, (Map)new TfsTelemetryHelper.PropertyMapBuilder().currentOrActiveContext(localContext).actionName(ImportPageModelImpl.ACTION_NAME).success(Boolean.valueOf(true)).build());
                            return;
                        }
                        if (ImportPageModelImpl.this.setupRemoteOnLocalRepo(project, localRepository, remoteRepository, localContext, indicator)) break block15;
                        logger.error("doImport: failed to setup remote origin on local repository at: {} to point to remote repository: {}", (Object)localRepository.getRoot().getUrl(), (Object)remoteRepository.getRemoteUrl());
                        if (!StringUtils.isNotEmpty((String)remoteUrlForDisplay)) return;
                        VcsNotifier.getInstance((Project)project).notifyImportantInfo(TfPluginBundle.message("Import.Succeeded", new Object[0]), TfPluginBundle.message("Import.Succeeded.Message", project.getName(), remoteUrlForDisplay, repositoryName), NotificationListener.URL_OPENING_LISTENER);
                        TfsTelemetryHelper.sendEventAsync((String)ImportPageModelImpl.ACTION_NAME, (Map)new TfsTelemetryHelper.PropertyMapBuilder().currentOrActiveContext(localContext).actionName(ImportPageModelImpl.ACTION_NAME).success(Boolean.valueOf(true)).build());
                        return;
                    }
                    if (ImportPageModelImpl.this.pushChangesToRemoteRepo(project, localRepository, remoteRepository, localContext, indicator)) break block16;
                    logger.error("doImport: failed to push changes to remote repository: {}", (Object)remoteRepository.getRemoteUrl());
                    if (!StringUtils.isNotEmpty((String)remoteUrlForDisplay)) return;
                    VcsNotifier.getInstance((Project)project).notifyImportantInfo(TfPluginBundle.message("Import.Succeeded", new Object[0]), TfPluginBundle.message("Import.Succeeded.Message", project.getName(), remoteUrlForDisplay, repositoryName), NotificationListener.URL_OPENING_LISTENER);
                    TfsTelemetryHelper.sendEventAsync((String)ImportPageModelImpl.ACTION_NAME, (Map)new TfsTelemetryHelper.PropertyMapBuilder().currentOrActiveContext(localContext).actionName(ImportPageModelImpl.ACTION_NAME).success(Boolean.valueOf(true)).build());
                    return;
                }
                try {
                    remoteUrlForDisplay = remoteRepository.getRemoteUrl();
                }
                catch (Throwable unexpectedError) {
                    try {
                        remoteUrlForDisplay = "";
                        logger.error("doImport: Unexpected error during import");
                        logger.warn("doImport", unexpectedError);
                        ImportPageModelImpl.this.notifyImportError(project, TfPluginBundle.message("Import.Errors.Unexpected", unexpectedError.getLocalizedMessage()), TfPluginBundle.message("Import.Failed", new Object[0]), localContext);
                    }
                    catch (Throwable throwable) {
                        if (!StringUtils.isNotEmpty((String)remoteUrlForDisplay)) throw throwable;
                        VcsNotifier.getInstance((Project)project).notifyImportantInfo(TfPluginBundle.message("Import.Succeeded", new Object[0]), TfPluginBundle.message("Import.Succeeded.Message", project.getName(), remoteUrlForDisplay, repositoryName), NotificationListener.URL_OPENING_LISTENER);
                        TfsTelemetryHelper.sendEventAsync((String)ImportPageModelImpl.ACTION_NAME, (Map)new TfsTelemetryHelper.PropertyMapBuilder().currentOrActiveContext(localContext).actionName(ImportPageModelImpl.ACTION_NAME).success(Boolean.valueOf(true)).build());
                        throw throwable;
                    }
                    if (!StringUtils.isNotEmpty((String)remoteUrlForDisplay)) return;
                    VcsNotifier.getInstance((Project)project).notifyImportantInfo(TfPluginBundle.message("Import.Succeeded", new Object[0]), TfPluginBundle.message("Import.Succeeded.Message", project.getName(), remoteUrlForDisplay, repositoryName), NotificationListener.URL_OPENING_LISTENER);
                    TfsTelemetryHelper.sendEventAsync((String)ImportPageModelImpl.ACTION_NAME, (Map)new TfsTelemetryHelper.PropertyMapBuilder().currentOrActiveContext(localContext).actionName(ImportPageModelImpl.ACTION_NAME).success(Boolean.valueOf(true)).build());
                    return;
                }
                if (!StringUtils.isNotEmpty((String)remoteUrlForDisplay)) return;
                VcsNotifier.getInstance((Project)project).notifyImportantInfo(TfPluginBundle.message("Import.Succeeded", new Object[0]), TfPluginBundle.message("Import.Succeeded.Message", project.getName(), remoteUrlForDisplay, repositoryName), NotificationListener.URL_OPENING_LISTENER);
                TfsTelemetryHelper.sendEventAsync((String)ImportPageModelImpl.ACTION_NAME, (Map)new TfsTelemetryHelper.PropertyMapBuilder().currentOrActiveContext(localContext).actionName(ImportPageModelImpl.ACTION_NAME).success(Boolean.valueOf(true)).build());
                return;
            }
        }.queue();
    }

    private GitRepository getRepositoryForProject(Project project) {
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager((Project)project);
        List localRepositories = repositoryManager.getRepositories();
        GitRepository repo = localRepositories.size() == 1 ? (GitRepository)localRepositories.get(0) : (GitRepository)repositoryManager.getRepositoryForFile(project.getBaseDir());
        return repo;
    }

    private GitRepository setupGitRepositoryForProject(Project project, VirtualFile rootVirtualFile, ServerContext localContext, ProgressIndicator indicator) {
        indicator.setText(TfPluginBundle.message("Import.GitInit", project.getName()));
        GitLineHandler hInit = new GitLineHandler(project, rootVirtualFile, GitCommand.INIT);
        GitHandlerUtil.runInCurrentThread((GitHandler)hInit, null, (boolean)true, (String)TfPluginBundle.message("Import.GitInit", project.getName()));
        if (!hInit.errors().isEmpty()) {
            String error = ((VcsException)hInit.errors().get(0)).getMessage();
            logger.error("setupGitRepositoryForProject: git init failed on project: {} at root: {} with error: {}", new Object[]{project.getName(), rootVirtualFile.getUrl(), error});
            this.notifyImportError(project, TfPluginBundle.message("Import.Errors.GitInit", project.getName(), error), ACTION_NAME, localContext);
            return null;
        }
        GitInit.refreshAndConfigureVcsMappings((Project)project, (VirtualFile)rootVirtualFile, (String)rootVirtualFile.getPath());
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager((Project)project);
        return (GitRepository)repositoryManager.getRepositoryForRoot(rootVirtualFile);
    }

    private boolean projectSupportsGitRepos(final Project project, ServerContext localContext, ProgressIndicator indicator) {
        String sourceControlType;
        HashMap vcCapabilities;
        if (localContext.getType() != ServerContext.Type.TFS) {
            return true;
        }
        CoreHttpClient client = new CoreHttpClient(localContext.getClient(), localContext.getCollectionURI());
        final TeamProject tp = client.getProject(localContext.getTeamProjectReference().getId().toString(), true);
        HashMap capabilities = tp.getCapabilities();
        if (capabilities != null && capabilities.containsKey(PROJECT_CAPABILITY_VC) && (vcCapabilities = (HashMap)capabilities.get(PROJECT_CAPABILITY_VC)) != null && vcCapabilities.containsKey(PROJECT_CAPABILITY_VC_TYPE) && StringUtils.equalsIgnoreCase((String)(sourceControlType = (String)vcCapabilities.get(PROJECT_CAPABILITY_VC_TYPE)), (String)PROJECT_CAPABILITY_VC_GIT)) {
            return true;
        }
        final ArrayList proceed = new ArrayList();
        IdeaHelper.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                boolean response = IdeaHelper.showConfirmationDialog(project, TfPluginBundle.message("Import.TeamProject.GitSupport", tp.getName()), TfPluginBundle.message("ImportDialog.Title", new Object[0]), Icons.VSLogo, TfPluginBundle.message("Import.Proceed", new Object[0]), TfPluginBundle.message("Import.Cancel", new Object[0]));
                if (response) {
                    proceed.add("true");
                }
            }
        }, true, indicator.getModalityState());
        if (proceed.size() == 0) {
            logger.warn("projectSupportsGitRepos: User chose to cancel import into team project: {}", (Object)localContext.getTeamProjectReference().getName());
            this.notifyImportError(project, TfPluginBundle.message("Import.Canceled", new Object[0]), TfPluginBundle.message("Actions.Import.Title", new Object[0]), localContext);
            return false;
        }
        return true;
    }

    private boolean doFirstCommitIfRequired(final Project project, GitRepository localRepository, VirtualFile rootVirtualFile, ServerContext localContext, ProgressIndicator indicator) {
        if (localRepository.isFresh()) {
            try {
                final ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                final ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
                List trackedFiles = changeListManager.getAffectedFiles();
                List untrackedFiles = ContainerUtil.filter((Collection)localRepository.getUntrackedFilesHolder().retrieveUntrackedFiles(), (Condition)new Condition<VirtualFile>(){

                    public boolean value(VirtualFile file) {
                        return !changeListManager.isIgnoredFile(file) && !vcsManager.isIgnored(file);
                    }
                });
                trackedFiles.removeAll(untrackedFiles);
                final ArrayList allFiles = new ArrayList();
                allFiles.addAll(trackedFiles);
                allFiles.addAll(untrackedFiles);
                final ArrayList<VirtualFile> filesToCommit = new ArrayList<VirtualFile>();
                IdeaHelper.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SelectFilesDialog dialog = SelectFilesDialog.init((Project)project, (List)allFiles, (String)TfPluginBundle.message("Import.SelectFiles", new Object[0]), (VcsShowConfirmationOption)VcsShowConfirmationOption.STATIC_SHOW_CONFIRMATION, (boolean)true, (boolean)false, (boolean)false);
                        dialog.setTitle(TfPluginBundle.message("Import.SelectFilesDialog.Title", new Object[0]));
                        DialogManager.show((DialogWrapper)dialog);
                        if (dialog.isOK()) {
                            filesToCommit.addAll(dialog.getSelectedFiles());
                        }
                    }
                }, true, indicator.getModalityState());
                indicator.setText(TfPluginBundle.message("Import.AddingFiles", project.getName()));
                GitFileUtils.addFiles((Project)project, (VirtualFile)rootVirtualFile, filesToCommit);
                if (filesToCommit.size() > 0) {
                    GitSimpleHandler hCommit = new GitSimpleHandler(project, rootVirtualFile, GitCommand.COMMIT);
                    hCommit.addParameters(new String[]{"-m", TfPluginBundle.message("Import.AddingFiles", project.getName())});
                    GitHandlerUtil.runInCurrentThread((GitHandler)hCommit, null, (boolean)true, (String)TfPluginBundle.message("Import.AddingFiles", project.getName()));
                    if (hCommit.getExitCode() != 0) {
                        logger.error("doFirstCommitIfRequired: git commit failed for project: {}, repoRoot: {} with error: {}", new Object[]{project.getName(), rootVirtualFile.getUrl(), hCommit.getStderr()});
                        this.notifyImportError(project, TfPluginBundle.message("Import.Errors.AddingFiles", project.getName(), hCommit.getStderr()), ACTION_NAME, localContext);
                        return false;
                    }
                } else {
                    logger.error("doFirstCommitIfRequired: No files to do first commit in project: {}, repoRoot: {}", (Object)project.getName(), (Object)rootVirtualFile.getUrl());
                    this.notifyImportError(project, TfPluginBundle.message("Import.Errors.NoSelectedFiles", new Object[0]), ACTION_NAME, localContext);
                    return false;
                }
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])((VirtualFile[])ArrayUtil.toObjectArray(filesToCommit, VirtualFile.class)));
                VcsFileUtil.markFilesDirty((Project)project, this.getFilePaths(filesToCommit));
            }
            catch (VcsException ve) {
                logger.error("doFirstCommitIfRequired: VcsException occurred when trying to do a commit on project: {}, repoRoot: {}", (Object)project.getName(), (Object)rootVirtualFile.getUrl());
                logger.warn("doFirstCommitIfRequired", (Throwable)ve);
                TfsTelemetryHelper.sendExceptionAsync((Exception)((Object)ve), (Map)new TfsTelemetryHelper.PropertyMapBuilder().currentOrActiveContext(localContext).actionName(ACTION_NAME).success(Boolean.valueOf(false)).build());
                this.notifyImportError(project, TfPluginBundle.message("Import.Errors.AddingFiles", project.getName(), ve.getMessage()), ACTION_NAME, localContext);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private com.microsoft.alm.sourcecontrol.webapi.model.GitRepository createRemoteGitRepo(Project project, ServerContext context, ServerContext localContext, ProgressIndicator indicator) {
        com.microsoft.alm.sourcecontrol.webapi.model.GitRepository remoteRepository;
        String collectionUrl;
        block11: {
            indicator.setText(TfPluginBundle.message("Import.CreatingRemoteRepo", new Object[0]));
            GitHttpClientEx gitClient = context.getGitHttpClient();
            collectionUrl = gitClient.getBaseUrl().toString();
            com.microsoft.alm.sourcecontrol.webapi.model.GitRepository gitRepoToCreate = new com.microsoft.alm.sourcecontrol.webapi.model.GitRepository();
            gitRepoToCreate.setName(this.repositoryName);
            gitRepoToCreate.setProjectReference(localContext.getTeamProjectReference());
            remoteRepository = null;
            Throwable t = null;
            try {
                remoteRepository = gitClient.createRepository(gitRepoToCreate, context.getTeamProjectReference().getId());
                t = null;
                if (t == null) break block11;
            }
            catch (VssServiceException vssEx) {
                block12: {
                    t = vssEx;
                    if (t == null) break block12;
                    logger.error("doImport: Failed to create remote git repository name: {} collection: {}", (Object)this.repositoryName, (Object)collectionUrl);
                    logger.warn("doImport", t);
                    String errorMessage = t.getMessage().contains("Microsoft.TeamFoundation.Git.Server.GitRepositoryNameAlreadyExists") ? TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.AlreadyExistsError", this.repositoryName, localContext.getTeamProjectURI().toString()) : (t.getMessage().contains("Microsoft.TeamFoundation.Git.Server.InvalidGitRepositoryNameException") ? TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.InvalidNameError", this.repositoryName) : (t.getMessage().contains("Microsoft.TeamFoundation.Git.Server.GitNeedsPermissionException") ? TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.PermissionError", this.repositoryName, localContext.getTeamProjectURI().toString()) : TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.UnexpectedError", this.repositoryName, localContext.getTeamProjectURI().toString())));
                    this.notifyImportError(project, errorMessage, ACTION_NAME, localContext);
                }
                if (remoteRepository == null) {
                    logger.error("doImport: remoteRepository is null after trying to remote git repository name: {} collection: {}", (Object)this.repositoryName, (Object)collectionUrl);
                }
            }
            catch (Throwable otherEx) {
                block13: {
                    t = otherEx;
                    if (t == null) break block13;
                    {
                        catch (Throwable throwable) {
                            if (t != null) {
                                logger.error("doImport: Failed to create remote git repository name: {} collection: {}", (Object)this.repositoryName, (Object)collectionUrl);
                                logger.warn("doImport", t);
                                String errorMessage = t.getMessage().contains("Microsoft.TeamFoundation.Git.Server.GitRepositoryNameAlreadyExists") ? TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.AlreadyExistsError", this.repositoryName, localContext.getTeamProjectURI().toString()) : (t.getMessage().contains("Microsoft.TeamFoundation.Git.Server.InvalidGitRepositoryNameException") ? TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.InvalidNameError", this.repositoryName) : (t.getMessage().contains("Microsoft.TeamFoundation.Git.Server.GitNeedsPermissionException") ? TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.PermissionError", this.repositoryName, localContext.getTeamProjectURI().toString()) : TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.UnexpectedError", this.repositoryName, localContext.getTeamProjectURI().toString())));
                                this.notifyImportError(project, errorMessage, ACTION_NAME, localContext);
                            }
                            if (remoteRepository == null) {
                                logger.error("doImport: remoteRepository is null after trying to remote git repository name: {} collection: {}", (Object)this.repositoryName, (Object)collectionUrl);
                            }
                            throw throwable;
                        }
                    }
                    logger.error("doImport: Failed to create remote git repository name: {} collection: {}", (Object)this.repositoryName, (Object)collectionUrl);
                    logger.warn("doImport", t);
                    String errorMessage = t.getMessage().contains("Microsoft.TeamFoundation.Git.Server.GitRepositoryNameAlreadyExists") ? TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.AlreadyExistsError", this.repositoryName, localContext.getTeamProjectURI().toString()) : (t.getMessage().contains("Microsoft.TeamFoundation.Git.Server.InvalidGitRepositoryNameException") ? TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.InvalidNameError", this.repositoryName) : (t.getMessage().contains("Microsoft.TeamFoundation.Git.Server.GitNeedsPermissionException") ? TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.PermissionError", this.repositoryName, localContext.getTeamProjectURI().toString()) : TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.UnexpectedError", this.repositoryName, localContext.getTeamProjectURI().toString())));
                    this.notifyImportError(project, errorMessage, ACTION_NAME, localContext);
                }
                if (remoteRepository == null) {
                    logger.error("doImport: remoteRepository is null after trying to remote git repository name: {} collection: {}", (Object)this.repositoryName, (Object)collectionUrl);
                }
            }
            logger.error("doImport: Failed to create remote git repository name: {} collection: {}", (Object)this.repositoryName, (Object)collectionUrl);
            logger.warn("doImport", t);
            String errorMessage = t.getMessage().contains("Microsoft.TeamFoundation.Git.Server.GitRepositoryNameAlreadyExists") ? TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.AlreadyExistsError", this.repositoryName, localContext.getTeamProjectURI().toString()) : (t.getMessage().contains("Microsoft.TeamFoundation.Git.Server.InvalidGitRepositoryNameException") ? TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.InvalidNameError", this.repositoryName) : (t.getMessage().contains("Microsoft.TeamFoundation.Git.Server.GitNeedsPermissionException") ? TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.PermissionError", this.repositoryName, localContext.getTeamProjectURI().toString()) : TfPluginBundle.message("Import.Errors.CreatingRemoteRepo.UnexpectedError", this.repositoryName, localContext.getTeamProjectURI().toString())));
            this.notifyImportError(project, errorMessage, ACTION_NAME, localContext);
        }
        if (remoteRepository == null) {
            logger.error("doImport: remoteRepository is null after trying to remote git repository name: {} collection: {}", (Object)this.repositoryName, (Object)collectionUrl);
        }
        return remoteRepository;
    }

    private boolean setupRemoteOnLocalRepo(final Project project, GitRepository localRepository, com.microsoft.alm.sourcecontrol.webapi.model.GitRepository remoteRepository, ServerContext localContext, ProgressIndicator indicator) {
        indicator.setText(TfPluginBundle.message("Import.GitRemote", new Object[0]));
        Collection gitRemotes = localRepository.getRemotes();
        final ArrayList remoteParams = new ArrayList();
        if (!gitRemotes.isEmpty()) {
            for (GitRemote remote : gitRemotes) {
                if (!StringUtils.equalsIgnoreCase((String)remote.getName(), (String)REMOTE_ORIGIN)) continue;
                IdeaHelper.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        boolean replaceOrigin = IdeaHelper.showConfirmationDialog(project, TfPluginBundle.message("Import.OriginExists", new Object[0]), TfPluginBundle.message("ImportDialog.Title", new Object[0]), Icons.VSLogoSmall, TfPluginBundle.message("Import.UpdateOrigin", new Object[0]), TfPluginBundle.message("Import.Cancel", new Object[0]));
                        if (replaceOrigin) {
                            remoteParams.add("set-url");
                        }
                    }
                }, true, indicator.getModalityState());
                if (remoteParams.size() != 0) break;
                logger.warn("setupRemoteOnLocalRepo: User chose to cancel import for project: {}, local repo: {}", (Object)project.getName(), (Object)localRepository.getGitDir().getUrl());
                this.notifyImportError(project, TfPluginBundle.message("Import.Canceled", new Object[0]), TfPluginBundle.message("Actions.Import.Title", new Object[0]), localContext);
                return false;
            }
        }
        String remoteGitUrl = UrlHelper.getCmdLineFriendlyUrl((String)remoteRepository.getRemoteUrl());
        GitSimpleHandler hRemote = new GitSimpleHandler(project, localRepository.getRoot(), GitCommand.REMOTE);
        hRemote.setSilent(true);
        if (remoteParams.size() == 1) {
            hRemote.addParameters(new String[]{(String)remoteParams.get(0), REMOTE_ORIGIN, remoteGitUrl});
        } else {
            hRemote.addParameters(new String[]{"add", REMOTE_ORIGIN, remoteGitUrl});
        }
        GitHandlerUtil.runInCurrentThread((GitHandler)hRemote, null, (boolean)true, (String)TfPluginBundle.message("Import.GitRemote", new Object[0]));
        if (hRemote.getExitCode() != 0) {
            logger.error("setupRemoteOnLocalRepo: git remote failed for project: {}, local repo: {}, error: {}, output: {}", new Object[]{project.getName(), localRepository.getRoot().getUrl(), hRemote.getStderr(), hRemote.getStdout()});
            this.notifyImportError(project, TfPluginBundle.message("Import.Errors.GitRemote", remoteGitUrl, hRemote.getStderr()), ACTION_NAME, localContext);
            return false;
        }
        return true;
    }

    private boolean pushChangesToRemoteRepo(Project project, GitRepository localRepository, com.microsoft.alm.sourcecontrol.webapi.model.GitRepository remoteRepository, ServerContext localContext, ProgressIndicator indicator) {
        localRepository.update();
        String remoteGitUrl = UrlHelper.getCmdLineFriendlyUrl((String)remoteRepository.getRemoteUrl());
        indicator.setText(TfPluginBundle.message("Import.GitPush", new Object[0]));
        Git git = (Git)ServiceManager.getService(Git.class);
        GitCommandResult result = git.push(localRepository, REMOTE_ORIGIN, remoteGitUrl, "*", true, new GitLineHandlerListener[0]);
        if (!result.success()) {
            logger.error("pushChangesToRemoteRepo: push to remote: {} failed with error: {}, outuput: {}", new Object[]{remoteGitUrl, result.getErrorOutputAsJoinedString(), result.getOutputAsJoinedString()});
            this.notifyImportError(project, result.getErrorOutputAsJoinedString(), ACTION_NAME, localContext);
            return false;
        }
        return true;
    }

    private List<FilePath> getFilePaths(List<VirtualFile> virtualFiles) {
        assert (virtualFiles != null);
        ArrayList<FilePath> filePaths = new ArrayList<FilePath>(virtualFiles.size());
        for (VirtualFile vf : virtualFiles) {
            filePaths.add(VcsUtil.getFilePath((VirtualFile)vf));
        }
        return filePaths;
    }

    private void notifyImportError(Project project, String message, String action, ServerContext context) {
        TfsTelemetryHelper.sendEventAsync((String)action, (Map)new TfsTelemetryHelper.PropertyMapBuilder().currentOrActiveContext(context).actionName(action).success(Boolean.valueOf(false)).message(message).build());
        VcsNotifier.getInstance((Project)project).notifyError(TfPluginBundle.message("Import.Failed", new Object[0]), message, NotificationListener.URL_OPENING_LISTENER);
    }

    @Override
    public void appendContexts(List<ServerContext> serverContexts) {
        this.teamProjectTableModel.addServerContexts(serverContexts);
    }

    protected void addContext(ServerContext serverContext) {
        this.teamProjectTableModel.addServerContexts(Collections.singletonList(serverContext));
    }

    @Override
    public ServerContextTableModel getTableModel() {
        return this.teamProjectTableModel;
    }

    @Override
    public ListSelectionModel getTableSelectionModel() {
        return this.teamProjectTableModel.getSelectionModel();
    }

    @Override
    public ModelValidationInfo validate() {
        ModelValidationInfo result = super.validate();
        if (result == ModelValidationInfo.NO_ERRORS) {
            if (this.getSelectedContext() == null) {
                return ModelValidationInfo.createWithResource("teamProjectTable", "ImportDialog.Errors.ProjectNotSelected", new Object[0]);
            }
            String directoryName = this.getRepositoryName();
            if (directoryName == null || directoryName.isEmpty()) {
                return ModelValidationInfo.createWithResource("repositoryName", "ImportDialog.Errors.RepoNameEmpty", new Object[0]);
            }
        } else {
            return result;
        }
        return ModelValidationInfo.NO_ERRORS;
    }

    @Override
    public void clearContexts() {
        this.teamProjectTableModel.clearRows();
    }

    protected ServerContext getSelectedContext() {
        return this.teamProjectTableModel.getSelectedContext();
    }

    @Override
    public void dispose() {
        this.teamProjectProvider.terminateActiveOperation();
    }
}

