/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.vcsimport;

import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.authentication.AuthenticationProvider;
import com.microsoft.alm.plugin.authentication.VsoAuthenticationProvider;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.LookupHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextTableModel;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportModel;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportPageModelImpl;
import com.microsoft.alm.plugin.operations.ServerContextLookupOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VsoImportPageModel
extends ImportPageModelImpl {
    private VsoAuthenticationProvider authenticationProvider = VsoAuthenticationProvider.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(VsoImportPageModel.class);

    public VsoImportPageModel(ImportModel importDialogModel, boolean autoLoad) {
        super(importDialogModel, ServerContextTableModel.VSO_PROJECT_COLUMNS);
        this.setServerNameInternal(TfPluginBundle.message("ImportDialog.VSO.ServerName", new Object[0]));
        this.setConnected(false);
        this.setAuthenticating(false);
        String serverName = LookupHelper.getVsspsUrlFromDisplayName(this.getServerName());
        if (autoLoad && this.authenticationProvider.isAuthenticated(serverName)) {
            LookupHelper.loadVsoContexts(this, this, (AuthenticationProvider)this.authenticationProvider, this.getTeamProjectProvider(), ServerContextLookupOperation.ContextScope.PROJECT);
        }
    }

    @Override
    protected AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationProvider.getAuthenticationInfo(this.getServerName());
    }

    @Override
    public void signOut() {
        super.signOut();
        this.authenticationProvider.clearAuthenticationDetails(this.getServerName());
    }

    @Override
    public void loadTeamProjects() {
        LookupHelper.authenticateAndLoadVsoContexts(this, this, (AuthenticationProvider)this.authenticationProvider, this.getTeamProjectProvider(), ServerContextLookupOperation.ContextScope.PROJECT);
    }
}

