/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TfGitHelper {
    private static final String MASTER_BRANCH_PATTERN = "%s/master";

    public static boolean isTfGitRepository(@NotNull GitRepository gitRepository) {
        return TfGitHelper.getTfGitRemote(gitRepository) != null;
    }

    public static String getTfGitRemoteUrl(@NotNull GitRepository gitRepository) {
        GitRemote gitRemote = TfGitHelper.getTfGitRemote(gitRepository);
        if (gitRemote != null) {
            return gitRemote.getFirstUrl();
        }
        return null;
    }

    public static GitRemote getTfGitRemote(@NotNull GitRepository gitRepository) {
        if (gitRepository == null) {
            throw new IllegalArgumentException();
        }
        GitRemote first = null;
        for (GitRemote gitRemote : gitRepository.getRemotes()) {
            if (!TfGitHelper.isTfGitRemote(gitRemote)) continue;
            if (gitRemote.getName().equals("origin")) {
                return gitRemote;
            }
            if (first != null) continue;
            first = gitRemote;
        }
        return first;
    }

    private static boolean isTfGitRemote(GitRemote gitRemote) {
        if (gitRemote == null) {
            return false;
        }
        String remoteUrl = gitRemote.getFirstUrl();
        return remoteUrl != null && (remoteUrl.contains(".visualstudio.com/") || remoteUrl.contains(".tfsallin.net/") || remoteUrl.contains("/_git/"));
    }

    public static Collection<GitRemote> getTfGitRemotes(@NotNull GitRepository gitRepository) {
        assert (gitRepository != null);
        Collection gitRemotes = gitRepository.getRemotes();
        return Collections2.filter((Collection)gitRemotes, (Predicate)new Predicate<GitRemote>(){

            public boolean apply(GitRemote remote) {
                return TfGitHelper.isTfGitRemote(remote);
            }
        });
    }

    public static GitRepository getTfGitRepository(@NotNull Project project) {
        if (project != null) {
            List repositories = GitUtil.getRepositoryManager((Project)project).getRepositories();
            for (GitRepository repository : repositories) {
                if (!TfGitHelper.isTfGitRepository(repository)) continue;
                return repository;
            }
        }
        return null;
    }

    public static ServerContext getSavedServerContext(@NotNull GitRepository gitRepository) {
        ServerContext context = ServerContextManager.getInstance().get(TfGitHelper.getTfGitRemoteUrl(gitRepository));
        return context;
    }

    @Nullable
    public static GitRemoteBranch getDefaultBranch(@NotNull List<GitRemoteBranch> remoteBranches, @NotNull Collection<GitRemote> tfGitRemotes) {
        if (remoteBranches.isEmpty() || tfGitRemotes.isEmpty()) {
            return null;
        }
        GitRemote firstTfRemote = tfGitRemotes.iterator().next();
        String masterBranchName = String.format(MASTER_BRANCH_PATTERN, firstTfRemote.getName());
        for (GitRemoteBranch remoteBranch : remoteBranches) {
            if (!remoteBranch.getName().equals(masterBranchName)) continue;
            return remoteBranch;
        }
        return remoteBranches.get(0);
    }

    public static String getRemoteBranchName(GitRemote remote, String branchName) {
        ArgumentHelper.checkNotNull((Object)remote, (String)"remote");
        ArgumentHelper.checkNotEmptyString((String)branchName, (String)"branchName");
        return remote.getName() + "/" + branchName;
    }

    public static class BranchComparator
    implements Comparator<GitRemoteBranch>,
    Serializable {
        private static final long serialVersionUID = 2526372195429182934L;

        @Override
        public int compare(GitRemoteBranch branch1, GitRemoteBranch branch2) {
            return StringUtil.naturalCompare((String)branch1.getFullName(), (String)branch2.getFullName());
        }
    }
}

