/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.actions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.external.utils.WorkspaceHelper;
import com.microsoft.alm.plugin.idea.common.actions.InstrumentedAction;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import com.microsoft.alm.plugin.idea.tfvc.ui.ProxySettingsDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureProxyAction
extends InstrumentedAction {
    private static final Logger logger = LoggerFactory.getLogger(ConfigureProxyAction.class);

    @VisibleForTesting
    public ConfigureProxyAction() {
        super(TfPluginBundle.message("Actions.Tfvc.Proxy.Title", new Object[0]), TfPluginBundle.message("Actions.Tfvc.Proxy.Message", new Object[0]), null, false);
    }

    @Override
    public void doActionPerformed(AnActionEvent anActionEvent) {
        Project project = anActionEvent.getProject();
        RepositoryContext context = VcsHelper.getRepositoryContext(project);
        if (context != null) {
            String currentProxy = this.getProxy(context);
            ProxySettingsDialog dialog = new ProxySettingsDialog(project, context.getUrl(), currentProxy);
            if (dialog.showAndGet()) {
                String newProxy = dialog.getProxyUri();
                this.setProxy(context, newProxy);
            }
        } else {
            logger.warn("RepositoryContext returned null");
        }
    }

    private String getProxy(RepositoryContext context) {
        if (context == null) {
            return null;
        }
        return WorkspaceHelper.getProxyServer((String)context.getUrl());
    }

    private void setProxy(RepositoryContext context, String newProxy) {
        if (context == null) {
            return;
        }
        WorkspaceHelper.setProxyServer((String)context.getUrl(), (String)newProxy);
    }

    @Override
    public void doUpdate(AnActionEvent anActionEvent) {
        Project project = anActionEvent.getProject();
        anActionEvent.getPresentation().setEnabled(project != null);
    }
}

