/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.actions;

import com.intellij.openapi.progress.ProgressManager;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.commands.LockCommand;
import com.microsoft.alm.plugin.external.models.ItemInfo;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.actions.MultipleItemAction;
import com.microsoft.alm.plugin.idea.tfvc.ui.LockItemsDialog;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockAction
extends MultipleItemAction {
    public static final Logger logger = LoggerFactory.getLogger(LockAction.class);

    public LockAction() {
        super(TfPluginBundle.message("Actions.Tfvc.Lock.Title", new Object[0]), TfPluginBundle.message("Actions.Tfvc.Lock.Message", new Object[0]));
    }

    @Override
    protected void execute(final @NotNull MultipleItemAction.MultipleItemActionContext actionContext) {
        logger.info("Starting Lock/unlock action");
        final LockItemsDialog d = new LockItemsDialog(actionContext.project, actionContext.itemInfos);
        d.show();
        int exitCode = d.getExitCode();
        if (exitCode != 2 && exitCode != 3) {
            logger.info("User canceled Lock/unlock action");
            actionContext.cancelled = true;
            return;
        }
        String title = d.getLockLevel() == LockCommand.LockLevel.NONE ? TfPluginBundle.message("Actions.Tfvc.Lock.Progress.Unlocking", new Object[0]) : TfPluginBundle.message("Actions.Tfvc.Lock.Progress.Locking", new Object[0]);
        this.runWithProgress(actionContext, new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                List<ItemInfo> selectedItems = d.getSelectedItems();
                ArrayList<String> itemSpecs = new ArrayList<String>(selectedItems.size());
                for (ItemInfo item : selectedItems) {
                    itemSpecs.add(item.getServerItem());
                }
                logger.info("Calling the lock command");
                CommandUtils.lock((ServerContext)actionContext.serverContext, (String)actionContext.workingFolder, (LockCommand.LockLevel)d.getLockLevel(), (boolean)d.getRecursive(), itemSpecs);
            }
        }, title);
        if (!actionContext.hasErrors()) {
            logger.info("Files locked/unlocked successfully.");
            String message = exitCode == 2 ? TfPluginBundle.message("Actions.Tfvc.Label.Success.Locked", new Object[0]) : TfPluginBundle.message("Actions.Tfvc.Label.Success.Unlocked", new Object[0]);
            this.showSuccess(actionContext, TfPluginBundle.message("Actions.Tfvc.Lock.Title", new Object[0]), message);
        }
    }
}

