/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.alm.helpers.Path;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.ItemInfo;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.common.actions.InstrumentedAction;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultipleItemAction
extends InstrumentedAction {
    public static final Logger logger = LoggerFactory.getLogger(MultipleItemAction.class);

    public MultipleItemAction(String title, String message) {
        super(title, message, null, false);
    }

    protected abstract void execute(@NotNull MultipleItemActionContext var1);

    @Override
    public void doUpdate(AnActionEvent anActionEvent) {
        Project project = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        VirtualFile[] files = VcsUtil.getVirtualFiles((AnActionEvent)anActionEvent);
        anActionEvent.getPresentation().setEnabled(this.isEnabled(project, files));
    }

    @Override
    public void doActionPerformed(AnActionEvent anActionEvent) {
        logger.info("Starting multiple item action");
        final MultipleItemActionContext context = new MultipleItemActionContext();
        context.project = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        final VirtualFile[] files = VcsUtil.getVirtualFiles((AnActionEvent)anActionEvent);
        logger.info("Finding the list of selected files and getting itemInfos for each one");
        this.runWithProgress(context, new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                context.serverContext = TFSVcs.getInstance(context.project).getServerContext(true);
                ArrayList<String> localPaths = new ArrayList<String>(files.length);
                for (VirtualFile file : files) {
                    FilePath localPath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
                    localPaths.add(localPath.getPath());
                }
                List infos = CommandUtils.getItemInfos((ServerContext)context.serverContext, null, localPaths);
                context.itemInfos.addAll(infos);
                if (context.itemInfos.size() > 0) {
                    logger.info("Setting the defaultLocalPath and workingFolder");
                    context.defaultLocalPath = context.itemInfos.get(0).getLocalItem();
                    context.isFolder = Path.directoryExists((String)context.defaultLocalPath);
                    context.workingFolder = context.isFolder ? context.defaultLocalPath : Path.getDirectoryName((String)context.defaultLocalPath);
                }
            }
        }, TfPluginBundle.message("Actions.Tfvc.Label.Progress.GatheringInformation", new Object[0]));
        if (context.hasErrors()) {
            logger.info("Errors found; showing them and exiting");
            this.showErrors(context);
            return;
        }
        if (!context.hasItems()) {
            logger.warn("We ended up without any items in the list and no errors occurred. We need to understand how this happened.");
            return;
        }
        logger.info("Calling the subclasses execute method to do the actual work.");
        this.execute(context);
        if (context.cancelled) {
            return;
        }
        if (context.hasErrors()) {
            logger.info("Errors found; showing them and exiting");
            this.showErrors(context);
        }
    }

    protected boolean runWithProgress(final MultipleItemActionContext context, final Runnable runnable, final String progressMessage) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("running with progress: " + progressMessage);
                    runnable.run();
                }
                catch (Throwable t) {
                    logger.warn("runnable threw an error", t);
                    context.errors.add(TFSVcs.convertToVcsException(t));
                }
            }
        }, progressMessage, false, context.project);
        return !context.hasErrors();
    }

    protected boolean isEnabled(Project project, VirtualFile[] files) {
        if (files.length == 0) {
            return false;
        }
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project);
        for (VirtualFile file : files) {
            FileStatus fileStatus = fileStatusManager.getStatus(file);
            if (fileStatus == FileStatus.NOT_CHANGED || fileStatus == FileStatus.MODIFIED || fileStatus == FileStatus.HIJACKED) continue;
            return false;
        }
        return true;
    }

    protected void showErrors(MultipleItemActionContext context) {
        AbstractVcsHelper.getInstance((Project)context.project).showErrors(context.errors, "TFVC");
    }

    protected void showSuccess(MultipleItemActionContext context, String title, String successMessage) {
        Messages.showInfoMessage((Project)context.project, (String)successMessage, (String)title);
    }

    protected static class MultipleItemActionContext {
        protected Project project;
        protected ServerContext serverContext;
        protected String defaultLocalPath;
        protected boolean isFolder;
        protected String workingFolder;
        protected boolean cancelled = false;
        protected final List<VcsException> errors = new ArrayList<VcsException>();
        protected final List<ItemInfo> itemInfos = new ArrayList<ItemInfo>();

        protected MultipleItemActionContext() {
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public boolean hasItems() {
            return !this.itemInfos.isEmpty();
        }
    }
}

