/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.ItemInfo;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.common.actions.InstrumentedAction;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SingleItemAction
extends InstrumentedAction {
    protected static final Logger logger = LoggerFactory.getLogger(SingleItemAction.class);
    private static final Collection<FileStatus> ALLOWED_STATUSES = Arrays.asList(FileStatus.HIJACKED, FileStatus.MODIFIED, FileStatus.NOT_CHANGED, FileStatus.OBSOLETE);

    protected SingleItemAction(String text, String description) {
        super(text, description, null, false);
    }

    protected abstract void execute(@NotNull SingleItemActionContext var1) throws TfsException;

    protected Collection<FileStatus> getAllowedStatuses() {
        return ALLOWED_STATUSES;
    }

    @Override
    public void doActionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = VcsUtil.getOneVirtualFile((AnActionEvent)e);
        if (project == null || file == null) {
            logger.warn("project or file is null in actionPerformed");
            return;
        }
        final FilePath localPath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
        String actionTitle = StringUtil.trimEnd((String)e.getPresentation().getText(), (String)"...");
        try {
            final SingleItemActionContext actionContext = new SingleItemActionContext(project, localPath);
            final ArrayList errors = new ArrayList();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                        ServerContext context = TFSVcs.getInstance(project).getServerContext(true);
                        ItemInfo item = CommandUtils.getItemInfo((ServerContext)context, (String)localPath.getPath());
                        actionContext.setItem(item);
                        actionContext.setServerContext(context);
                    }
                    catch (Throwable t) {
                        errors.add(TFSVcs.convertToVcsException(t));
                    }
                }
            }, TfPluginBundle.message("Tfvc.Update.Status.Msg", new Object[0]), false, project);
            if (!errors.isEmpty()) {
                AbstractVcsHelper.getInstance((Project)project).showErrors(errors, "TFVC");
                return;
            }
            this.execute(actionContext);
        }
        catch (TfsException ex) {
            Messages.showErrorDialog((Project)project, (String)ex.getMessage(), (String)actionTitle);
        }
    }

    @Override
    public void doUpdate(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(this.isEnabled(e.getProject(), VcsUtil.getOneVirtualFile((AnActionEvent)e)));
    }

    protected final boolean isEnabled(@Nullable Project project, @Nullable VirtualFile file) {
        return project != null && file != null && this.getAllowedStatuses().contains(FileStatusManager.getInstance((Project)project).getStatus(file));
    }

    public static class SingleItemActionContext {
        private final Project project;
        private final FilePath filePath;
        private ServerContext serverContext;
        private ItemInfo item;

        public SingleItemActionContext(Project project, FilePath filePath) {
            this.project = project;
            this.filePath = filePath;
        }

        public Project getProject() {
            return this.project;
        }

        public FilePath getFilePath() {
            return this.filePath;
        }

        public void setItem(ItemInfo item) {
            this.item = item;
        }

        public ItemInfo getItem() {
            return this.item;
        }

        public void setServerContext(ServerContext serverContext) {
            this.serverContext = serverContext;
        }

        public ServerContext getServerContext() {
            return this.serverContext;
        }
    }
}

