/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.ChangeSet;
import com.microsoft.alm.plugin.external.models.PendingChange;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.revision.TFSContentRevision;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.ServerStatus;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.StatusVisitor;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.VersionControlPath;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChangelistBuilderStatusVisitor
implements StatusVisitor {
    private static final Logger logger = LoggerFactory.getLogger(ChangelistBuilderStatusVisitor.class);
    @NotNull
    private final Project project;
    @NotNull
    private final ChangelistBuilder changelistBuilder;
    private final ServerContext serverContext;

    public ChangelistBuilderStatusVisitor(@NotNull Project project, ServerContext serverContext, @NotNull ChangelistBuilder changelistBuilder) {
        this.project = project;
        this.changelistBuilder = changelistBuilder;
        this.serverContext = serverContext;
    }

    @Override
    public void checkedOutForEdit(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localItemExists) {
            TFSContentRevision baseRevision = TFSContentRevision.create(this.project, this.serverContext, localPath, serverStatus.localVer, serverStatus.modicationDate);
            this.changelistBuilder.processChange(new Change((ContentRevision)baseRevision, CurrentContentRevision.create((FilePath)localPath)), TFSVcs.getKey());
        } else {
            this.changelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void locked(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
    }

    @Override
    public void scheduledForAddition(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        if (localItemExists) {
            this.changelistBuilder.processChange(new Change(null, (ContentRevision)new CurrentContentRevision(localPath)), TFSVcs.getKey());
        } else {
            this.changelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void scheduledForDeletion(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        TFSContentRevision baseRevision = TFSContentRevision.create(this.project, this.serverContext, localPath, serverStatus.localVer, serverStatus.modicationDate);
        this.changelistBuilder.processChange(new Change((ContentRevision)baseRevision, null), TFSVcs.getKey());
    }

    @Override
    public void renamedCheckedOut(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localItemExists) {
            TFSContentRevision before = this.getPreviousRenamedRevision(localPath, serverStatus.localVer);
            ContentRevision after = CurrentContentRevision.create((FilePath)localPath);
            this.changelistBuilder.processChange(new Change((ContentRevision)before, after), TFSVcs.getKey());
        } else {
            this.changelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void renamed(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localItemExists) {
            TFSContentRevision before = this.getPreviousRenamedRevision(localPath, serverStatus.localVer);
            ContentRevision after = CurrentContentRevision.create((FilePath)localPath);
            this.changelistBuilder.processChange(new Change((ContentRevision)before, after), TFSVcs.getKey());
        } else {
            this.changelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void unversioned(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        if (localItemExists) {
            VirtualFile filePath = localPath.getVirtualFile();
            if (filePath == null) {
                this.changelistBuilder.processLocallyDeletedFile(localPath);
            } else {
                this.changelistBuilder.processUnversionedFile(filePath);
            }
        }
    }

    @Override
    public void undeleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        this.checkedOutForEdit(localPath, localItemExists, serverStatus);
    }

    private TFSContentRevision getPreviousRenamedRevision(FilePath localPath, int revision) {
        ChangeSet lastChangeSet = CommandUtils.getLastHistoryEntryForAnyUser((ServerContext)this.serverContext, (String)localPath.getPath());
        if (lastChangeSet != null && !lastChangeSet.getChanges().isEmpty()) {
            String serverPath = ((PendingChange)lastChangeSet.getChanges().get(0)).getServerItem();
            String originalPath = CommandUtils.getLocalPathSynchronously(null, (String)serverPath, (String)CommandUtils.getWorkspaceName(null, (Project)this.project));
            return TFSContentRevision.createRenameRevision(this.project, this.serverContext, VersionControlPath.getFilePath(originalPath, localPath.isDirectory()), revision, lastChangeSet.getDate(), serverPath);
        }
        return null;
    }
}

