/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.commands.StatusCommand;
import com.microsoft.alm.plugin.external.models.PendingChange;
import com.microsoft.alm.plugin.idea.tfvc.core.ChangelistBuilderStatusVisitor;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.RootsCollection;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.StatusProvider;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSChangeProvider
implements ChangeProvider {
    private static final Logger logger = LoggerFactory.getLogger(TFSChangeProvider.class);
    private final Project myProject;

    public TFSChangeProvider(Project project) {
        this.myProject = project;
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public void doCleanup(List<VirtualFile> files) {
    }

    public void getChanges(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder, @NotNull ProgressIndicator progress, @NotNull ChangeListManagerGate addGate) throws VcsException {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (builder == null) {
            return;
        }
        progress.setText("Processing changes");
        ServerContext serverContext = TFSVcs.getInstance(this.myProject).getServerContext(false);
        RootsCollection.FilePathRootsCollection roots = new RootsCollection.FilePathRootsCollection();
        roots.addAll(dirtyScope.getRecursivelyDirtyDirectories());
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        for (FilePath dirtyFile : dirtyScope.getDirtyFiles()) {
            if (dirtyFile.getVirtualFile() != null && changeListManager.isIgnoredFile(dirtyFile.getVirtualFile())) continue;
            roots.add(dirtyFile);
        }
        if (roots.isEmpty()) {
            return;
        }
        ChangelistBuilderStatusVisitor changelistBuilderStatusVisitor = new ChangelistBuilderStatusVisitor(this.myProject, serverContext, builder);
        Iterator iterator = roots.iterator();
        while (iterator.hasNext()) {
            List<PendingChange> changes;
            FilePath root = (FilePath)iterator.next();
            if (StringUtils.containsIgnoreCase((String)root.getPath(), (String)"$tf") || StringUtils.containsIgnoreCase((String)root.getPath(), (String)".tf")) continue;
            try {
                StatusCommand command = new StatusCommand(serverContext, root.getPath());
                changes = (List<PendingChange>)command.runSynchronously();
            }
            catch (Throwable t) {
                logger.warn("Failed to get changes from command line. root=" + root.getPath(), t);
                changes = Collections.emptyList();
            }
            for (PendingChange change : changes) {
                try {
                    StatusProvider.visitByStatus(changelistBuilderStatusVisitor, change);
                }
                catch (TfsException e) {
                    throw new VcsException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

