/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.exceptions.TeamServicesException;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.services.LocalizationServiceImpl;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSProgressUtil;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsFileUtil;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.VersionControlPath;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.operations.ScheduleForDeletion;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSCheckinEnvironment
implements CheckinEnvironment {
    public static final Logger logger = LoggerFactory.getLogger(TFSCheckinEnvironment.class);
    private static final String CHECKIN_OPERATION_NAME = "Checkin";
    @NotNull
    private final TFSVcs myVcs;

    public TFSCheckinEnvironment(@NotNull TFSVcs vcs) {
        this.myVcs = vcs;
    }

    @Nullable
    public RefreshableOnComponent createAdditionalOptionsPanel(CheckinProjectPanel checkinProjectPanel, PairConsumer<Object, Object> additionalDataConsumer) {
        return null;
    }

    @Nullable
    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return CHECKIN_OPERATION_NAME;
    }

    @Nullable
    public List<VcsException> commit(List<Change> changes, String preparedComment, @NotNull NullableFunction<Object, Object> parametersHolder, Set<String> feedback) {
        ArrayList<VcsException> errors = new ArrayList<VcsException>();
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        TFSProgressUtil.setProgressText(progressIndicator, TfPluginBundle.message("Tfvc.Checkin.Status", new Object[0]));
        ArrayList<String> files = new ArrayList<String>();
        for (Change change : changes) {
            String path = null;
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision != null) {
                path = afterRevision.getFile().getPath();
            } else if (beforeRevision != null) {
                path = beforeRevision.getFile().getPath();
            }
            if (path == null) continue;
            files.add(path);
        }
        try {
            ServerContext context = this.myVcs.getServerContext(true);
            List<Integer> workItemIds = VcsHelper.getWorkItemIdsFromMessage(preparedComment);
            String changesetNumber = CommandUtils.checkinFiles((ServerContext)context, files, (String)preparedComment, workItemIds);
            String changesetLink = String.format("<html><body><a href=\"%s\">%s</a></body></html>", UrlHelper.getTfvcChangesetURI((String)context.getUri().toString(), (String)changesetNumber), TfPluginBundle.message("Tfvc.Checkin.Link.Text", changesetNumber));
            VcsNotifier.getInstance((Project)this.myVcs.getProject()).notifyImportantInfo(TfPluginBundle.message("Tfvc.Checkin.Successful.Title", new Object[0]), TfPluginBundle.message("Tfvc.Checkin.Successful.Msg", changesetLink), new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent hyperlinkEvent) {
                    BrowserUtil.browse((URL)hyperlinkEvent.getURL());
                }
            });
        }
        catch (Exception e) {
            logger.warn("Error during checkin", (Throwable)e);
            if (e instanceof TeamServicesException) {
                errors.add(new VcsException(LocalizationServiceImpl.getInstance().getExceptionMessage(e)));
            }
            errors.add(new VcsException((Throwable)e));
        }
        return errors;
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment) {
        return this.commit(changes, preparedComment, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null);
    }

    @Nullable
    public List<VcsException> scheduleMissingFileForDeletion(final List<FilePath> files) {
        final ArrayList<VcsException> errors = new ArrayList<VcsException>();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                errors.addAll(ScheduleForDeletion.execute(TFSCheckinEnvironment.this.myVcs.getProject(), files));
            }
        }, TfPluginBundle.message("Tfvc.Delete.Scheduling", new Object[0]), false, this.myVcs.getProject());
        return errors;
    }

    @Nullable
    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        try {
            ArrayList<String> filesToAddPaths = new ArrayList<String>(files.size());
            for (VirtualFile file : files) {
                filesToAddPaths.add(file.getPath());
            }
            List successfullyAdded = CommandUtils.addFiles((ServerContext)this.myVcs.getServerContext(false), filesToAddPaths);
            for (String path : successfullyAdded) {
                VirtualFile file = VersionControlPath.getVirtualFile(path);
                if (file == null || !file.isValid()) continue;
                TfsFileUtil.markFileDirty(this.myVcs.getProject(), file);
            }
            if (successfullyAdded.size() != filesToAddPaths.size()) {
                filesToAddPaths.removeAll(successfullyAdded);
                exceptions.add(new VcsException(TfPluginBundle.message("Tfvc.Add.Error", StringUtils.join(filesToAddPaths, (String)", "))));
            }
        }
        catch (RuntimeException e) {
            exceptions.add(new VcsException((Throwable)e));
        }
        return exceptions;
    }

    public boolean keepChangeListAfterCommit(ChangeList changeList) {
        return false;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }
}

