/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.ItemInfo;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.revision.TFSContentRevision;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsFileUtil;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsRevisionNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSDiffProvider
implements DiffProvider {
    private static final Logger logger = LoggerFactory.getLogger(TFSDiffProvider.class);
    private final Project project;

    public TFSDiffProvider(@NotNull Project project) {
        this.project = project;
    }

    @Nullable
    public ItemLatestState getLastRevision(VirtualFile virtualFile) {
        FilePath localPath = TfsFileUtil.getFilePath(virtualFile);
        return this.getLastRevision(localPath);
    }

    @Nullable
    public ContentRevision createFileContent(VcsRevisionNumber vcsRevisionNumber, VirtualFile virtualFile) {
        if (VcsRevisionNumber.NULL.equals(vcsRevisionNumber)) {
            return null;
        }
        FilePath path = TfsFileUtil.getFilePath(virtualFile);
        try {
            ServerContext serverContext = TFSVcs.getInstance(this.project).getServerContext(true);
            return TFSContentRevision.create(this.project, serverContext, path, this.getChangeset(vcsRevisionNumber), this.getModificationDate(vcsRevisionNumber));
        }
        catch (Exception e) {
            logger.warn("Unable to create file content", (Throwable)e);
            AbstractVcsHelper.getInstance((Project)this.project).showError(new VcsException((Throwable)e), "TFVC");
            return null;
        }
    }

    private String getModificationDate(VcsRevisionNumber vcsRevisionNumber) {
        if (vcsRevisionNumber instanceof TfsRevisionNumber) {
            TfsRevisionNumber revisionNumber = (TfsRevisionNumber)vcsRevisionNumber;
            return revisionNumber.getModificationDate();
        }
        return "";
    }

    private int getChangeset(VcsRevisionNumber vcsRevisionNumber) {
        if (vcsRevisionNumber instanceof VcsRevisionNumber.Int) {
            VcsRevisionNumber.Int revisionNumber = (VcsRevisionNumber.Int)vcsRevisionNumber;
            return revisionNumber.getValue();
        }
        return 0;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision(VirtualFile virtualFile) {
        try {
            ItemInfo info = CommandUtils.getItemInfo((ServerContext)TFSVcs.getInstance(this.project).getServerContext(true), (String)virtualFile.getPath());
            if (info != null) {
                return new TfsRevisionNumber(info.getLocalVersionAsInt(), virtualFile.getName(), info.getLastModified());
            }
        }
        catch (Exception e) {
            AbstractVcsHelper.getInstance((Project)this.project).showError(new VcsException(e.getMessage(), (Throwable)e), "TFVC");
        }
        return VcsRevisionNumber.NULL;
    }

    public ItemLatestState getLastRevision(FilePath localPath) {
        try {
            ItemInfo info = CommandUtils.getItemInfo((ServerContext)TFSVcs.getInstance(this.project).getServerContext(true), (String)localPath.getPath());
            if (info != null) {
                TfsRevisionNumber revisionNumber = new TfsRevisionNumber(info.getServerVersionAsInt(), localPath.getName(), info.getLastModified());
                return new ItemLatestState((VcsRevisionNumber)revisionNumber, info.getServerVersionAsInt() == 0, false);
            }
            return new ItemLatestState(VcsRevisionNumber.NULL, false, false);
        }
        catch (Exception e) {
            logger.warn("Unable to getLastRevision", (Throwable)e);
            AbstractVcsHelper.getInstance((Project)this.project).showError(new VcsException(e.getMessage(), (Throwable)e), "TFVC");
            return new ItemLatestState(VcsRevisionNumber.NULL, false, false);
        }
    }

    public VcsRevisionNumber getLatestCommittedRevision(VirtualFile vcsRoot) {
        return null;
    }
}

