/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import com.microsoft.alm.helpers.Path;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.PendingChange;
import com.microsoft.alm.plugin.external.models.ServerStatusType;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.ServerStatus;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.StatusProvider;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.StatusVisitor;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSFileSystemListener
implements LocalFileOperationsHandler,
Disposable {
    public static final Logger logger = LoggerFactory.getLogger(TFSFileSystemListener.class);
    private final Project project;

    public TFSFileSystemListener(Project project) {
        this.project = project;
        LocalFileSystem.getInstance().registerAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this);
    }

    public void dispose() {
        LocalFileSystem.getInstance().unregisterAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this);
    }

    public boolean delete(VirtualFile virtualFile) throws IOException {
        logger.info("Deleting file with TFVC: " + virtualFile.getPath());
        ArrayList pendingChanges = new ArrayList();
        pendingChanges.addAll(CommandUtils.getStatusForFiles((ServerContext)TFSVcs.getInstance(this.project).getServerContext(true), Arrays.asList(virtualFile.getPath())));
        if (pendingChanges.isEmpty()) {
            logger.info("No changes to file so deleting though TFVC");
            CommandUtils.deleteFiles((ServerContext)TFSVcs.getInstance(this.project).getServerContext(true), Arrays.asList(virtualFile.getPath()), null, (boolean)true);
            return true;
        }
        final AtomicBoolean revert = new AtomicBoolean(false);
        final AtomicBoolean success = new AtomicBoolean(false);
        final AtomicBoolean isUndelete = new AtomicBoolean(false);
        try {
            for (final PendingChange pendingChange : pendingChanges) {
                StatusProvider.visitByStatus(new StatusVisitor(){

                    @Override
                    public void scheduledForAddition(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        revert.set(true);
                        success.set(false);
                    }

                    @Override
                    public void unversioned(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                        if (pendingChange.getChangeTypes().contains(ServerStatusType.DELETE)) {
                            revert.set(true);
                            success.set(true);
                        }
                    }

                    @Override
                    public void scheduledForDeletion(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                        success.set(false);
                    }

                    @Override
                    public void checkedOutForEdit(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                        revert.set(true);
                        success.set(true);
                    }

                    @Override
                    public void locked(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        success.set(false);
                    }

                    @Override
                    public void renamed(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        revert.set(true);
                        success.set(true);
                    }

                    @Override
                    public void renamedCheckedOut(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        revert.set(true);
                        success.set(true);
                    }

                    @Override
                    public void undeleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        revert.set(true);
                        isUndelete.set(true);
                    }
                }, pendingChange);
            }
        }
        catch (TfsException e) {
            logger.warn("Error while checking delete candidate's pending changes");
            AbstractVcsHelper.getInstance((Project)this.project).showError(new VcsException((Throwable)e), "TFVC");
        }
        if (revert.get()) {
            logger.info("Reverting pending changes for delete candidate");
            CommandUtils.undoLocalFiles((ServerContext)TFSVcs.getInstance(this.project).getServerContext(true), Arrays.asList(virtualFile.getPath()));
        }
        if (success.get() && !isUndelete.get()) {
            logger.info("Deleting file with TFVC after undoing pending changes");
            String filePath = StringUtils.isNotEmpty((String)((PendingChange)pendingChanges.get(0)).getSourceItem()) ? ((PendingChange)pendingChanges.get(0)).getSourceItem() : ((PendingChange)pendingChanges.get(0)).getLocalItem();
            CommandUtils.deleteFiles((ServerContext)TFSVcs.getInstance(this.project).getServerContext(true), Arrays.asList(filePath), (String)((PendingChange)pendingChanges.get(0)).getWorkspace(), (boolean)true);
        }
        logger.info("File was deleted using TFVC: " + success.get());
        return success.get();
    }

    public boolean move(VirtualFile virtualFile, VirtualFile toDirectory) throws IOException {
        logger.info(String.format("Moving file %s to %s", virtualFile.getPath(), toDirectory.getPath()));
        return this.renameOrMove(virtualFile.getPath(), Path.combine((String)toDirectory.getPath(), (String)virtualFile.getName()));
    }

    @Nullable
    public File copy(VirtualFile virtualFile, VirtualFile virtualFile1, String s) throws IOException {
        return null;
    }

    public boolean rename(VirtualFile virtualFile, String s) throws IOException {
        logger.info(String.format("Renaming file %s to %s", virtualFile.getName(), s));
        return this.renameOrMove(virtualFile.getPath(), Path.combine((String)virtualFile.getParent().getPath(), (String)s));
    }

    public boolean createFile(VirtualFile virtualFile, String s) throws IOException {
        return false;
    }

    public boolean createDirectory(VirtualFile virtualFile, String s) throws IOException {
        return false;
    }

    public void afterDone(ThrowableConsumer<LocalFileOperationsHandler, IOException> throwableConsumer) {
    }

    private boolean renameOrMove(String oldPath, String newPath) throws IOException {
        try {
            ArrayList pendingChanges = new ArrayList(2);
            pendingChanges.addAll(CommandUtils.getStatusForFiles((ServerContext)TFSVcs.getInstance(this.project).getServerContext(true), (List)ImmutableList.of((Object)oldPath)));
            if (pendingChanges.size() == 1 && ((PendingChange)pendingChanges.get(0)).isCandidate() && ((PendingChange)pendingChanges.get(0)).getChangeTypes().contains(ServerStatusType.ADD)) {
                logger.info("Renaming unversioned file thru file system");
                return false;
            }
            logger.info("Renaming file thru tf commandline");
            CommandUtils.renameFile((ServerContext)TFSVcs.getInstance(this.project).getServerContext(true), (String)oldPath, (String)newPath);
            return true;
        }
        catch (Throwable t) {
            logger.warn("renameOrMove experienced a failure while trying to rename a file", t);
            throw new IOException(t);
        }
    }
}

