/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.ColumnInfo;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.ChangeSet;
import com.microsoft.alm.plugin.external.models.PendingChange;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.revision.TfsFileRevision;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSHistoryProvider
implements VcsHistoryProvider {
    public static final Logger logger = LoggerFactory.getLogger(TFSHistoryProvider.class);
    private final Project project;

    public TFSHistoryProvider(@NotNull Project project) {
        this.project = project;
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        return VcsDependentHistoryComponents.createOnlyColumns((ColumnInfo[])ColumnInfo.EMPTY_ARRAY);
    }

    public AnAction[] getAdditionalActions(Runnable refresher) {
        return new AnAction[0];
    }

    public boolean isDateOmittable() {
        return false;
    }

    @Nullable
    @NonNls
    public String getHelpId() {
        return null;
    }

    @Nullable
    public VcsHistorySession createSessionFor(FilePath filePath) throws VcsException {
        try {
            List<TfsFileRevision> revisions = TFSHistoryProvider.getRevisions(this.project, TFSVcs.getInstance(this.project).getServerContext(true), filePath, filePath.isDirectory());
            if (revisions.isEmpty()) {
                return null;
            }
            return TFSHistoryProvider.createSession(revisions.get(0).getServerPath(), revisions.get(0).getRevisionNumber(), revisions, !filePath.isDirectory());
        }
        catch (Exception e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static VcsAbstractHistorySession createSession(final String serverPath, final VcsRevisionNumber currentRevisionNumber, final List<TfsFileRevision> revisions, final boolean isFile) {
        return new VcsAbstractHistorySession(revisions){

            public VcsRevisionNumber calcCurrentRevisionNumber() {
                return currentRevisionNumber;
            }

            public HistoryAsTreeProvider getHistoryAsTreeProvider() {
                return null;
            }

            public VcsHistorySession copy() {
                return TFSHistoryProvider.createSession(serverPath, currentRevisionNumber, revisions, isFile);
            }

            public boolean isContentAvailable(VcsFileRevision revision) {
                return isFile;
            }
        };
    }

    public void reportAppendableHistory(FilePath path, VcsAppendableHistorySessionPartner partner) throws VcsException {
        VcsHistorySession session = this.createSessionFor(path);
        partner.reportCreatedEmptySession((VcsAbstractHistorySession)session);
    }

    public static List<TfsFileRevision> getRevisions(Project project, ServerContext serverContext, FilePath localPath, boolean isDirectory) {
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)project);
        int maxCount = vcsConfiguration.LIMIT_HISTORY ? vcsConfiguration.MAXIMUM_HISTORY_ROWS : Integer.MAX_VALUE;
        List changesets = CommandUtils.getHistoryCommand((ServerContext)serverContext, (String)localPath.getPath(), null, (int)maxCount, (boolean)isDirectory, null, (boolean)false);
        ArrayList<TfsFileRevision> revisions = new ArrayList<TfsFileRevision>(changesets.size());
        for (ChangeSet changeSet : changesets) {
            revisions.add(new TfsFileRevision(project, serverContext, TFSHistoryProvider.getServerPath(changeSet, localPath), localPath, changeSet.getIdAsInt(), changeSet.getCommitter(), changeSet.getComment(), changeSet.getDate()));
        }
        return revisions;
    }

    private static String getServerPath(ChangeSet changeSet, FilePath localPath) {
        if (changeSet != null && changeSet.getChanges().size() > 0 && localPath != null) {
            for (PendingChange pc : changeSet.getChanges()) {
                if (!StringUtils.equalsIgnoreCase((String)pc.getLocalItem(), (String)localPath.getPath())) continue;
                return pc.getServerItem();
            }
        }
        return null;
    }

    public boolean supportsHistoryForDirectories() {
        return true;
    }

    public DiffFromHistoryHandler getHistoryDiffHandler() {
        return null;
    }

    public boolean canShowHistoryFor(@NotNull VirtualFile file) {
        return true;
    }
}

