/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsFileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSRollbackEnvironment
extends DefaultRollbackEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(TFSRollbackEnvironment.class);
    private final Project project;
    private final TFSVcs vcs;

    public TFSRollbackEnvironment(@NotNull TFSVcs vcs, @NotNull Project project) {
        logger.info("Initilizing TFSRollbackEnvironment");
        this.vcs = vcs;
        this.project = project;
    }

    public void rollbackChanges(List<Change> changes, List<VcsException> vcsExceptions, @NotNull RollbackProgressListener listener) {
        logger.info("rollbackChanges started");
        ArrayList<FilePath> localPaths = new ArrayList<FilePath>();
        listener.determinate();
        for (Change change : changes) {
            ContentRevision revision = change.getType() == Change.Type.DELETED ? change.getBeforeRevision() : change.getAfterRevision();
            localPaths.add(revision.getFile());
        }
        this.undoPendingChanges(localPaths, vcsExceptions, listener, false);
        logger.info("rollbackChanges ended");
    }

    public void rollbackMissingFileDeletion(List<FilePath> files, List<VcsException> errors, RollbackProgressListener listener) {
    }

    public void rollbackModifiedWithoutCheckout(List<VirtualFile> files, List<VcsException> errors, RollbackProgressListener listener) {
    }

    public void rollbackIfUnchanged(VirtualFile file) {
    }

    private void undoPendingChanges(List<FilePath> localPaths, List<VcsException> errors, @NotNull RollbackProgressListener listener, boolean tolerateNoChangesFailure) {
        logger.info("undoPendingChanges started");
        try {
            ArrayList<String> localFiles = new ArrayList<String>(localPaths.size());
            for (FilePath path : localPaths) {
                localFiles.add(path.getPath());
            }
            ServerContext context = this.vcs.getServerContext(false);
            List filesUndone = CommandUtils.undoLocalFiles((ServerContext)context, localFiles);
            ArrayList<VirtualFile> refresh = new ArrayList<VirtualFile>(filesUndone.size());
            for (String path : filesUndone) {
                File fileUndone = new File(path);
                listener.accept(fileUndone);
                VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(fileUndone);
                VirtualFile parent = file != null ? file.getParent() : null;
                if (parent == null || !parent.exists()) continue;
                refresh.add(file);
            }
            TfsFileUtil.refreshAndMarkDirty(this.project, refresh, true);
        }
        catch (Throwable e) {
            logger.warn("undoPendingChanges: Errors caught: " + e.getMessage(), e);
            errors.add(new VcsException("Cannot undo pending changes", e));
        }
        logger.info("undoPendingChanges ended");
    }
}

