/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core.revision;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.tfvc.core.revision.TFSContentStore;
import com.microsoft.alm.plugin.idea.tfvc.core.revision.TFSContentStoreFactory;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsRevisionNumber;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TFSContentRevision
implements ContentRevision {
    private final Project project;
    private final ServerContext serverContext;
    @Nullable
    private byte[] myContent;

    protected TFSContentRevision(Project project, ServerContext serverContext) {
        this.project = project;
        this.serverContext = serverContext;
    }

    protected abstract int getChangeset() throws TfsException;

    protected abstract String getFilePath();

    public static TFSContentRevision create(Project project, ServerContext serverContext, final @NotNull FilePath localPath, final int changeset, final String modificationDate) {
        return new TFSContentRevision(project, serverContext){

            @Override
            protected int getChangeset() {
                return changeset;
            }

            @NotNull
            public FilePath getFile() {
                return localPath;
            }

            @Override
            protected String getFilePath() {
                return localPath.getPath();
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                return new TfsRevisionNumber(changeset, localPath.getName(), modificationDate);
            }
        };
    }

    public static TFSContentRevision createRenameRevision(Project project, ServerContext serverContext, final @NotNull FilePath orignalPath, final int changeset, final String modificationDate, final String serverPath) {
        return new TFSContentRevision(project, serverContext){

            @Override
            protected int getChangeset() {
                return changeset;
            }

            @NotNull
            public FilePath getFile() {
                return orignalPath;
            }

            @Override
            protected String getFilePath() {
                return serverPath;
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                return new TfsRevisionNumber(changeset, orignalPath.getName(), modificationDate);
            }
        };
    }

    @Nullable
    public String getContent() throws VcsException {
        return new String(this.doGetContent(), this.getFile().getCharset(this.project));
    }

    @Nullable
    public byte[] doGetContent() throws VcsException {
        if (this.myContent == null) {
            try {
                this.myContent = this.loadContent();
            }
            catch (TfsException e) {
                throw new VcsException((Throwable)e);
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
        }
        return this.myContent;
    }

    @Nullable
    private byte[] loadContent() throws TfsException, IOException {
        ArgumentHelper.checkNotNull((Object)this.getFile(), (String)"localPath");
        TFSContentStore store = TFSContentStoreFactory.findOrCreate(this.getFile().getPath(), this.getChangeset(), this.getFilePath(), this.serverContext);
        return store.loadContent();
    }

    @NonNls
    public String toString() {
        return "TFSContentRevision [file=" + this.getFile() + ", revision=" + ((TfsRevisionNumber)this.getRevisionNumber()).getValue() + "]";
    }
}

