/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core.revision;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.tfvc.core.revision.TFSContentRevision;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfsFileRevision
implements VcsFileRevision {
    public static final Logger logger = LoggerFactory.getLogger(TfsFileRevision.class);
    private final Project project;
    private final ServerContext serverContext;
    private final FilePath localPath;
    private final String serverPath;
    private final int changeset;
    private final String author;
    private final String commitMessage;
    private final String modificationDate;
    private byte[] content;

    public TfsFileRevision(Project project, ServerContext serverContext, String serverPath, @NotNull FilePath localPath, int changeset, String author, String commitMessage, String modificationDate) {
        ArgumentHelper.checkNotNull((Object)localPath, (String)"localPath");
        ArgumentHelper.checkNotNull((Object)serverContext, (String)"serverContext");
        this.project = project;
        this.serverContext = serverContext;
        this.localPath = localPath;
        this.serverPath = serverPath;
        this.changeset = changeset;
        this.author = author;
        this.commitMessage = commitMessage;
        this.modificationDate = modificationDate;
    }

    @Nullable
    public String getBranchName() {
        return null;
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    public byte[] loadContent() throws IOException, VcsException {
        this.content = this.createContentRevision().doGetContent();
        return this.content;
    }

    @Nullable
    public byte[] getContent() throws IOException, VcsException {
        return this.content;
    }

    public VcsRevisionNumber getRevisionNumber() {
        return new VcsRevisionNumber.Int(this.changeset);
    }

    public Date getRevisionDate() {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ENGLISH).parse(this.modificationDate);
        }
        catch (ParseException e) {
            logger.warn("Unable to parse date: " + this.modificationDate);
            return new Date();
        }
    }

    @Nullable
    public String getAuthor() {
        return this.author;
    }

    @Nullable
    public String getCommitMessage() {
        return this.commitMessage;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    public TFSContentRevision createContentRevision() throws VcsException {
        try {
            return TFSContentRevision.create(this.project, this.serverContext, this.localPath, this.changeset, this.modificationDate);
        }
        catch (Exception e) {
            logger.warn("failed to create content revision", (Throwable)e);
            throw new VcsException("Cannot get revision content", (Throwable)e);
        }
    }
}

