/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core.tfs;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.DistinctRootsCollection;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.ItemPath;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class RootsCollection<T> {

    public static class VirtualFileRootsCollection
    extends DistinctRootsCollection<VirtualFile> {
        public VirtualFileRootsCollection() {
        }

        public VirtualFileRootsCollection(Collection<VirtualFile> items) {
            super(items);
        }

        public VirtualFileRootsCollection(VirtualFile[] items) {
            super((Object[])items);
        }

        protected boolean isAncestor(@NotNull VirtualFile parent, @NotNull VirtualFile child) {
            return VfsUtil.isAncestor((VirtualFile)parent, (VirtualFile)child, (boolean)false);
        }
    }

    public static class ItemPathRootsCollection
    extends DistinctRootsCollection<ItemPath> {
        public ItemPathRootsCollection() {
        }

        public ItemPathRootsCollection(Collection<ItemPath> items) {
            super(items);
        }

        protected boolean isAncestor(@NotNull ItemPath parent, @NotNull ItemPath child) {
            return child.getLocalPath().isUnder(parent.getLocalPath(), false);
        }
    }

    public static class FilePathRootsCollection
    extends DistinctRootsCollection<FilePath> {
        public FilePathRootsCollection() {
        }

        public FilePathRootsCollection(Collection<FilePath> items) {
            super(items);
        }

        protected boolean isAncestor(@NotNull FilePath parent, @NotNull FilePath child) {
            return child.isUnder(parent, false);
        }
    }
}

