/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core.tfs;

import com.intellij.openapi.vcs.FilePath;
import com.microsoft.alm.plugin.external.models.PendingChange;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.StatusVisitor;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import java.io.File;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ServerStatus {
    public final int localVer;
    public final boolean isDirectory;
    @Nullable
    public final String sourceItem;
    @Nullable
    public final String targetItem;
    public final String modicationDate;

    protected ServerStatus(int localVer, boolean isDirectory, String sourceItem, String targetItem, String modicationDate) {
        this.localVer = localVer;
        this.isDirectory = isDirectory;
        this.sourceItem = sourceItem;
        this.targetItem = targetItem;
        this.modicationDate = modicationDate;
    }

    protected ServerStatus(@NotNull PendingChange pendingChange) {
        this(Integer.parseInt(pendingChange.getVersion()), new File(pendingChange.getLocalItem()).isDirectory(), pendingChange.getServerItem(), pendingChange.getLocalItem(), pendingChange.getDate());
    }

    public abstract void visitBy(@NotNull FilePath var1, boolean var2, @NotNull StatusVisitor var3) throws TfsException;

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf("$") + 1);
    }

    public static class Undeleted
    extends ServerStatus {
        protected Undeleted(@NotNull PendingChange pendingChange) {
            super(pendingChange);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            statusVisitor.undeleted(localPath, localItemExists, this);
        }
    }

    public static class Unversioned
    extends ServerStatus {
        public static final ServerStatus INSTANCE = new Unversioned();

        private Unversioned() {
            super(0, false, null, null, new Date().toString());
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            statusVisitor.unversioned(localPath, localItemExists, this);
        }
    }

    public static class Renamed
    extends ServerStatus {
        protected Renamed(@NotNull PendingChange pendingChange) {
            super(pendingChange);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            statusVisitor.renamed(localPath, localItemExists, this);
        }
    }

    public static class RenamedCheckedOut
    extends ServerStatus {
        protected RenamedCheckedOut(@NotNull PendingChange pendingChange) {
            super(pendingChange);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            statusVisitor.renamedCheckedOut(localPath, localItemExists, this);
        }
    }

    public static class ScheduledForDeletion
    extends ServerStatus {
        protected ScheduledForDeletion(@NotNull PendingChange pendingChange) {
            super(pendingChange);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            statusVisitor.scheduledForDeletion(localPath, localItemExists, this);
        }
    }

    public static class ScheduledForAddition
    extends ServerStatus {
        protected ScheduledForAddition(@NotNull PendingChange pendingChange) {
            super(pendingChange);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            statusVisitor.scheduledForAddition(localPath, localItemExists, this);
        }
    }

    public static class Locked
    extends ServerStatus {
        protected Locked(@NotNull PendingChange pendingChange) {
            super(pendingChange);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            statusVisitor.locked(localPath, localItemExists, this);
        }
    }

    public static class CheckedOutForEdit
    extends ServerStatus {
        protected CheckedOutForEdit(@NotNull PendingChange pendingChange) {
            super(pendingChange);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            statusVisitor.checkedOutForEdit(localPath, localItemExists, this);
        }
    }
}

