/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core.tfs;

import com.microsoft.alm.helpers.Path;
import com.microsoft.alm.plugin.external.models.PendingChange;
import com.microsoft.alm.plugin.external.models.ServerStatusType;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.ServerStatus;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.StatusVisitor;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.VersionControlPath;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusProvider {
    public static final Logger logger = LoggerFactory.getLogger(StatusProvider.class);

    public static void visitByStatus(@NotNull StatusVisitor statusVisitor, PendingChange pendingChange) throws TfsException {
        StatusProvider.determineServerStatus(pendingChange).visitBy(VersionControlPath.getFilePath(pendingChange.getLocalItem(), new File(pendingChange.getLocalItem()).isDirectory()), true, statusVisitor);
    }

    private static ServerStatus determineServerStatus(@Nullable PendingChange pendingChange) {
        if (pendingChange.isCandidate()) {
            return ServerStatus.Unversioned.INSTANCE;
        }
        List types = pendingChange.getChangeTypes();
        if (types.contains(ServerStatusType.ADD)) {
            return new ServerStatus.ScheduledForAddition(pendingChange);
        }
        if (types.contains(ServerStatusType.EDIT) && types.contains(ServerStatusType.RENAME)) {
            return new ServerStatus.RenamedCheckedOut(pendingChange);
        }
        if (types.contains(ServerStatusType.EDIT)) {
            return new ServerStatus.CheckedOutForEdit(pendingChange);
        }
        if (types.contains(ServerStatusType.RENAME)) {
            return new ServerStatus.Renamed(pendingChange);
        }
        if (types.contains(ServerStatusType.DELETE)) {
            return new ServerStatus.ScheduledForDeletion(pendingChange);
        }
        if (types.contains(ServerStatusType.UNDELETE)) {
            return new ServerStatus.Undeleted(pendingChange);
        }
        if (types.contains(ServerStatusType.BRANCH)) {
            return new ServerStatus.ScheduledForAddition(pendingChange);
        }
        if (types.contains(ServerStatusType.MERGE)) {
            if (Path.fileExists((String)pendingChange.getLocalItem())) {
                return new ServerStatus.CheckedOutForEdit(pendingChange);
            }
            return new ServerStatus.ScheduledForDeletion(pendingChange);
        }
        if (types.contains(ServerStatusType.LOCK)) {
            return new ServerStatus.Locked(pendingChange);
        }
        logger.error("Unhandled status type: " + Arrays.toString(pendingChange.getChangeTypes().toArray()));
        return null;
    }
}

