/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core.tfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.ui.GuiUtils;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfsFileUtil {
    public static final Logger logger = LoggerFactory.getLogger(TfsFileUtil.class);

    public static boolean isServerItem(String itemPath) {
        return StringUtils.startsWithIgnoreCase((String)itemPath, (String)"$/");
    }

    public static List<FilePath> getFilePaths(@NotNull VirtualFile[] files) {
        return TfsFileUtil.getFilePaths(Arrays.asList(files));
    }

    public static List<FilePath> getFilePaths(@NotNull Collection<VirtualFile> files) {
        ArrayList<FilePath> paths = new ArrayList<FilePath>(files.size());
        for (VirtualFile f : files) {
            paths.add(TfsFileUtil.getFilePath(f));
        }
        return paths;
    }

    public static FilePath getFilePath(@NotNull VirtualFile f) {
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(f);
    }

    public static List<String> getFilePathStrings(@NotNull Collection<VirtualFile> files) {
        ArrayList<String> paths = new ArrayList<String>(files.size());
        for (VirtualFile f : files) {
            FilePath filePath = TfsFileUtil.getFilePath(f);
            paths.add(filePath.getPath());
        }
        return paths;
    }

    public static void setReadOnly(VirtualFile file, boolean status) throws IOException {
        TfsFileUtil.setReadOnly(Collections.singletonList(file), status);
    }

    public static void setReadOnly(final Collection<VirtualFile> files, final boolean status) throws IOException {
        final Ref exception = new Ref();
        try {
            GuiUtils.runOrInvokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                for (VirtualFile file : files) {
                                    ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)file, (boolean)status);
                                }
                            }
                            catch (IOException e) {
                                exception.set((Object)e);
                            }
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!exception.isNull()) {
            throw (IOException)exception.get();
        }
    }

    private static void setReadOnly(final String path, final boolean status) throws IOException {
        final Ref exception = new Ref();
        try {
            GuiUtils.runOrInvokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ReadOnlyAttributeUtil.setReadOnlyAttribute((String)path, (boolean)status);
                    }
                    catch (IOException e) {
                        exception.set((Object)e);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!exception.isNull()) {
            throw (IOException)exception.get();
        }
    }

    public static void markFileDirty(final Project project, final @NotNull FilePath file) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
            }
        });
    }

    public static void markDirtyRecursively(final Project project, final Collection<FilePath> roots) {
        if (roots.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (FilePath root : roots) {
                    VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(root);
                }
            }
        });
    }

    public static void markDirty(final Project project, final Collection<FilePath> roots, final Collection<FilePath> files) {
        if (roots.isEmpty() && files.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (FilePath root : roots) {
                    VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(root);
                }
                for (FilePath file : files) {
                    VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
                }
            }
        });
    }

    public static void markDirtyRecursively(final Project project, final FilePath rootDir) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(rootDir);
            }
        });
    }

    public static void markFileDirty(final Project project, final @NotNull VirtualFile file) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
            }
        });
    }

    public static void refreshAndMarkDirty(Project project, Collection<VirtualFile> roots, boolean async) {
        TfsFileUtil.refreshAndMarkDirty(project, VfsUtil.toVirtualFileArray(roots), async);
    }

    public static void refreshAndInvalidate(Project project, FilePath[] roots, boolean async) {
        VirtualFile[] files = new VirtualFile[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            files[i] = roots[i].getVirtualFile();
        }
        TfsFileUtil.refreshAndMarkDirty(project, files, async);
    }

    public static void refreshAndMarkDirty(final Project project, final VirtualFile[] roots, boolean async) {
        RefreshQueue.getInstance().refresh(async, true, new Runnable(){

            @Override
            public void run() {
                for (VirtualFile root : roots) {
                    try {
                        ArgumentHelper.checkNotNull((Object)root, (String)"root");
                        VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(root);
                    }
                    catch (IllegalArgumentException e) {
                        logger.error("Assertion failure: root is null", (Throwable)e);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        logger.error("RuntimeException while checking for dirty files", (Throwable)e);
                        throw e;
                    }
                }
            }
        }, roots);
    }

    public static void refreshAndFindFile(final FilePath path) {
        try {
            GuiUtils.runOrInvokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            VirtualFileManager.getInstance().refreshAndFindFileByUrl(path.getPath());
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFileContent(@NotNull File destination, @NotNull ContentWriter contentWriter) throws TfsException, IOException, IllegalArgumentException {
        ArgumentHelper.checkIfFile((File)destination);
        OutputStream fileStream = null;
        try {
            if (destination.exists() && !destination.canWrite()) {
                TfsFileUtil.setReadOnly(destination.getPath(), false);
            }
            fileStream = new FileOutputStream(destination);
            contentWriter.write(fileStream);
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean hasWritableChildFile(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File child : files) {
                if ((!child.isFile() || !child.canWrite()) && !TfsFileUtil.hasWritableChildFile(child)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFileWritable(FilePath localPath) {
        VirtualFile file = localPath.getVirtualFile();
        return file.isWritable() && !file.isDirectory();
    }

    public static boolean localItemExists(FilePath localPath) {
        VirtualFile file = localPath.getVirtualFile();
        return file != null && file.isValid() && file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] calculateMD5(File file) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        InputStream is = null;
        try {
            int read;
            is = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[8192];
            while ((read = is.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean findUnknownFiles(VirtualFile[] files, FileStatusManager fileStatusManager) {
        for (VirtualFile file : files) {
            FileStatus fileStatus;
            if (!(file.isDirectory() ? TfsFileUtil.findUnknownFiles(file.getChildren(), fileStatusManager) : (fileStatus = fileStatusManager.getStatus(file)) == FileStatus.UNKNOWN)) continue;
            return true;
        }
        return false;
    }

    public static interface ContentWriter {
        public void write(OutputStream var1) throws TfsException;
    }
}

