/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core.tfs.conflicts;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.common.utils.SystemHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.commands.ResolveConflictsCommand;
import com.microsoft.alm.plugin.external.models.ChangeSet;
import com.microsoft.alm.plugin.external.models.Conflict;
import com.microsoft.alm.plugin.external.models.MergeConflict;
import com.microsoft.alm.plugin.external.models.MergeResults;
import com.microsoft.alm.plugin.external.models.PendingChange;
import com.microsoft.alm.plugin.external.models.RenameConflict;
import com.microsoft.alm.plugin.external.models.ServerStatusType;
import com.microsoft.alm.plugin.external.models.VersionSpec;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.revision.TFSContentRevision;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsFileUtil;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.VersionControlPath;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.conflicts.ConflictsEnvironment;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.MergeFailedException;
import com.microsoft.alm.plugin.idea.tfvc.ui.resolve.ContentTriplet;
import com.microsoft.alm.plugin.idea.tfvc.ui.resolve.NameMergerResolution;
import com.microsoft.alm.plugin.idea.tfvc.ui.resolve.ResolveConflictsModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveConflictHelper {
    private static final Logger logger = LoggerFactory.getLogger(ResolveConflictHelper.class);
    @NotNull
    private final Project project;
    @Nullable
    private final UpdatedFiles updatedFiles;
    @NotNull
    private final List<String> updateRoots;
    @Nullable
    private final MergeResults mergeResults;

    public ResolveConflictHelper(Project project, UpdatedFiles updatedFiles, List<String> updateRoots) {
        this(project, updatedFiles, updateRoots, null);
    }

    public ResolveConflictHelper(Project project, UpdatedFiles updatedFiles, List<String> updateRoots, MergeResults mergeResults) {
        this.project = project;
        this.updatedFiles = updatedFiles;
        this.updateRoots = updateRoots;
        this.mergeResults = mergeResults;
    }

    public void acceptMerge(@NotNull Conflict conflict, ResolveConflictsModel model) throws VcsException {
        logger.info(String.format("Merging changes for file %s", conflict.getLocalPath()));
        File conflictPath = new File(conflict.getLocalPath());
        ServerContext context = TFSVcs.getInstance(this.project).getServerContext(false);
        if (ResolveConflictHelper.isDeleteConflict(conflict)) {
            throw new MergeFailedException(TfPluginBundle.message("Tfvc.Conflict.Merge.Error.CannotMergeDeletion", new Object[0]), true);
        }
        FilePath localPath = VersionControlPath.getFilePath(conflict.getLocalPath(), conflictPath.isDirectory());
        ContentTriplet contentTriplet = null;
        NameMergerResolution nameMergerResolution = null;
        if (ResolveConflictHelper.isContentConflict(conflict)) {
            logger.info("Content conflict have been found so getting file contents");
            contentTriplet = this.populateThreeWayDiffWithProgress(conflict, conflictPath, localPath, context);
        }
        if (ResolveConflictHelper.isNameConflict(conflict)) {
            logger.info("Rename conflict have been found so getting new name from user");
            nameMergerResolution = this.getMergedNameFromUser((RenameConflict)conflict);
            if (nameMergerResolution == null) {
                return;
            }
        }
        if (ResolveConflictHelper.isNameConflict(conflict) && ResolveConflictHelper.isContentConflict(conflict)) {
            logger.info("Both conflict types found");
            this.processBothConflicts(conflict, context, model, conflictPath, contentTriplet, nameMergerResolution);
        } else if (ResolveConflictHelper.isNameConflict(conflict)) {
            logger.info("Naming conflict found");
            this.processRenameConflict(conflict, context, model, nameMergerResolution);
        } else if (ResolveConflictHelper.isContentConflict(conflict)) {
            logger.info("Content conflict found");
            this.processContentConflict(context, model, contentTriplet, localPath, nameMergerResolution);
        } else {
            logger.error("Unknown conflict state");
        }
    }

    @VisibleForTesting
    protected void processBothConflicts(Conflict conflict, ServerContext context, ResolveConflictsModel model, File conflictPath, @Nullable ContentTriplet contentTriplet, NameMergerResolution nameMergerResolution) throws VcsException {
        if (nameMergerResolution != null && nameMergerResolution.userChoseTheirs()) {
            logger.debug("Taking their name before processing content conflict");
            this.resolveConflictWithProgress(conflict.getLocalPath(), ResolveConflictsCommand.AutoResolveType.TakeTheirs, context, model, false, nameMergerResolution);
            this.processContentConflict(context, model, contentTriplet, VersionControlPath.getFilePath(nameMergerResolution.getResolvedLocalPath(), conflictPath.isDirectory()), nameMergerResolution);
        } else {
            logger.debug("Keeping your name so continue to content conflict");
            this.processContentConflict(context, model, contentTriplet, VersionControlPath.getFilePath(conflict.getLocalPath(), conflictPath.isDirectory()), nameMergerResolution);
        }
    }

    private NameMergerResolution getMergedNameFromUser(RenameConflict renameConflict) {
        String myNameChoice;
        String theirNameChoice;
        logger.info("Ask the user which name choice they want: theirs or mine");
        if (renameConflict instanceof MergeConflict) {
            MergeConflict mergeConflict = (MergeConflict)renameConflict;
            theirNameChoice = mergeConflict.getMapping().getFromServerItem();
            myNameChoice = mergeConflict.getMapping().getToServerItem();
        } else {
            theirNameChoice = renameConflict.getServerPath();
            myNameChoice = renameConflict.getLocalPath();
        }
        logger.info(" - theirNameChoice: " + theirNameChoice);
        logger.info(" - myNameChoice: " + myNameChoice);
        String mergedServerPath = ConflictsEnvironment.getNameMerger().mergeName(myNameChoice, theirNameChoice, this.project);
        if (mergedServerPath == null) {
            logger.warn("User canceled rename merge");
            return null;
        }
        logger.info("User chose: " + mergedServerPath);
        return new NameMergerResolution(theirNameChoice, myNameChoice, mergedServerPath);
    }

    @VisibleForTesting
    protected void processRenameConflict(Conflict conflict, ServerContext context, ResolveConflictsModel model, NameMergerResolution nameMergerResolution) throws VcsException {
        if (nameMergerResolution != null && nameMergerResolution.userChoseTheirs()) {
            logger.debug("Taking their name");
            this.resolveConflictWithProgress(conflict.getLocalPath(), nameMergerResolution.getTheirNameChoice(), ResolveConflictsCommand.AutoResolveType.TakeTheirs, context, model, true, nameMergerResolution);
        } else {
            logger.debug("Keeping your name");
            this.resolveConflictWithProgress(conflict.getLocalPath(), ResolveConflictsCommand.AutoResolveType.KeepYours, context, model, true, nameMergerResolution);
        }
    }

    @VisibleForTesting
    protected void processContentConflict(ServerContext context, ResolveConflictsModel model, ContentTriplet contentTriplet, FilePath localPath, NameMergerResolution nameMergerResolution) throws VcsException {
        boolean resolved = true;
        if (contentTriplet != null) {
            File localFile = new File(localPath.getPath());
            ArgumentHelper.checkIfFile((File)localFile);
            VirtualFile vFile = VcsUtil.getVirtualFileWithRefresh((File)localFile);
            if (vFile != null) {
                try {
                    TfsFileUtil.setReadOnly(vFile, false);
                    resolved = ConflictsEnvironment.getContentMerger().mergeContent(contentTriplet, this.project, vFile, null);
                }
                catch (IOException e) {
                    throw new VcsException((Throwable)e);
                }
            } else {
                throw new VcsException(TfPluginBundle.message("Tfvc.Conflict.Merge.LoadFailed", localPath.getPresentableUrl()));
            }
        }
        if (resolved) {
            this.resolveConflictWithProgress(localPath.getPath(), ResolveConflictsCommand.AutoResolveType.KeepYours, context, model, true, nameMergerResolution);
        } else {
            logger.warn("Conflict merge was aborted by user");
        }
    }

    @VisibleForTesting
    protected void resolveConflictWithProgress(String localPath, ResolveConflictsCommand.AutoResolveType type, ServerContext context, ResolveConflictsModel model, boolean updateFiles, NameMergerResolution nameMergerResolution) throws VcsException {
        this.resolveConflictWithProgress(localPath, localPath, type, context, model, updateFiles, nameMergerResolution);
    }

    @VisibleForTesting
    protected void resolveConflictWithProgress(final String localPath, final String updatedPath, final ResolveConflictsCommand.AutoResolveType type, final ServerContext context, final ResolveConflictsModel model, final boolean updateFiles, final NameMergerResolution nameMergerResolution) throws VcsException {
        VcsRunnable resolveRunnable = new VcsRunnable(){

            public void run() throws VcsException {
                ResolveConflictHelper.this.resolveConflict(localPath, updatedPath, type, context, model, updateFiles, nameMergerResolution);
            }
        };
        VcsUtil.runVcsProcessWithProgress((VcsRunnable)resolveRunnable, (String)TfPluginBundle.message("Tfvc.Conflict.Resolving.ProgressBar", new Object[0]), (boolean)false, (Project)this.project);
        if (nameMergerResolution != null && StringUtils.isEmpty((String)nameMergerResolution.getResolvedLocalPath())) {
            nameMergerResolution.setResolvedLocalPath(nameMergerResolution.getUserSelection());
        }
    }

    @VisibleForTesting
    protected void resolveConflict(String localPath, String updatedPath, ResolveConflictsCommand.AutoResolveType type, ServerContext context, ResolveConflictsModel model, boolean updateFiles, NameMergerResolution nameMergerResolution) throws VcsException {
        IdeaHelper.setProgress(ProgressManager.getInstance().getProgressIndicator(), 0.1, TfPluginBundle.message("Tfvc.Conflict.Resolving.Status", localPath));
        try {
            List resolvedConflicts = CommandUtils.resolveConflictsByPath((ServerContext)context, Arrays.asList(localPath), (ResolveConflictsCommand.AutoResolveType)type);
            if (resolvedConflicts.size() == 1 && nameMergerResolution != null) {
                nameMergerResolution.setResolvedLocalPath(((Conflict)resolvedConflicts.get(0)).getLocalPath());
            }
            if (updateFiles && this.updatedFiles != null) {
                this.updatedFiles.getGroupById("MERGED").add(updatedPath, TFSVcs.getKey(), null);
            }
            IdeaHelper.setProgress(ProgressManager.getInstance().getProgressIndicator(), 0.5, TfPluginBundle.message("Tfvc.Conflict.Resolving.Refresh", new Object[0]));
            this.findConflicts(model);
        }
        catch (VcsException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Error while resolving conflict: " + e.getMessage());
            throw new VcsException(TfPluginBundle.message("Tfvc.Conflict.Merge.Error", localPath, e.getMessage()));
        }
    }

    @VisibleForTesting
    protected ContentTriplet populateThreeWayDiffWithProgress(final Conflict conflict, final File conflictPath, final FilePath localPath, final ServerContext context) throws VcsException {
        final ContentTriplet contentTriplet = new ContentTriplet();
        VcsRunnable runnable = new VcsRunnable(){

            public void run() throws VcsException {
                ResolveConflictHelper.this.populateThreeWayDiff(conflict, conflictPath, localPath, context, contentTriplet);
            }
        };
        VcsUtil.runVcsProcessWithProgress((VcsRunnable)runnable, (String)TfPluginBundle.message("Tfvc.Conflict.Merge.Loading", new Object[0]), (boolean)false, (Project)this.project);
        return contentTriplet;
    }

    @VisibleForTesting
    protected void populateThreeWayDiff(Conflict conflict, File conflictPath, FilePath localPath, ServerContext context, ContentTriplet contentTriplet) throws VcsException {
        TfsFileUtil.refreshAndFindFile(localPath);
        IdeaHelper.setProgress(ProgressManager.getInstance().getProgressIndicator(), 0.1, TfPluginBundle.message("Tfvc.Conflict.Merge.Original", new Object[0]));
        try {
            if (conflictPath.isFile()) {
                String myLocalChanges;
                String serverChanges;
                String original;
                PendingChange originalChange = CommandUtils.getStatusForFile((ServerContext)context, (String)conflict.getLocalPath());
                if (ResolveConflictHelper.isMergeConflict(conflict, null)) {
                    String workingFolder = localPath.isDirectory() ? localPath.getPath() : localPath.getParentPath().getPath();
                    MergeConflict mergeConflict = (MergeConflict)conflict;
                    String sourcePath = mergeConflict.getMapping().getFromServerItem();
                    String targetPath = mergeConflict.getMapping().getToServerItem();
                    VersionSpec baseVersion = CommandUtils.getBaseVersion((ServerContext)context, (String)workingFolder, (String)sourcePath, (String)targetPath);
                    original = TFSContentRevision.createRenameRevision(this.project, context, localPath, SystemHelper.toInt((String)baseVersion.getValue(), (int)1), originalChange.getDate(), sourcePath).getContent();
                    serverChanges = TFSContentRevision.createRenameRevision(this.project, context, localPath, ResolveConflictHelper.getMergeFromVersion(mergeConflict), originalChange.getDate(), sourcePath).getContent();
                    myLocalChanges = CurrentContentRevision.create((FilePath)localPath).getContent();
                } else {
                    FilePath renamePath;
                    if (originalChange != null) {
                        int version = Integer.parseInt(originalChange.getVersion());
                        if (ResolveConflictHelper.isNameConflict(conflict)) {
                            renamePath = VersionControlPath.getFilePath(conflict.getLocalPath(), conflictPath.isDirectory());
                            original = TFSContentRevision.createRenameRevision(this.project, context, renamePath, version, originalChange.getDate(), ((RenameConflict)conflict).getOldPath()).getContent();
                        } else {
                            original = TFSContentRevision.create(this.project, context, localPath, version, originalChange.getDate()).getContent();
                        }
                    } else {
                        original = null;
                    }
                    IdeaHelper.setProgress(ProgressManager.getInstance().getProgressIndicator(), 0.5, TfPluginBundle.message("Tfvc.Conflict.Merge.Server", new Object[0]));
                    myLocalChanges = CurrentContentRevision.create((FilePath)localPath).getContent();
                    if (ResolveConflictHelper.isNameConflict(conflict)) {
                        ChangeSet serverChange = CommandUtils.getLastHistoryEntryForAnyUser((ServerContext)context, (String)((RenameConflict)conflict).getServerPath());
                        renamePath = VersionControlPath.getFilePath(conflict.getLocalPath(), conflictPath.isDirectory());
                        serverChanges = TFSContentRevision.createRenameRevision(this.project, context, renamePath, serverChange.getIdAsInt(), serverChange.getDate(), ((RenameConflict)conflict).getServerPath()).getContent();
                    } else {
                        ChangeSet serverChange = CommandUtils.getLastHistoryEntryForAnyUser((ServerContext)context, (String)conflict.getLocalPath());
                        serverChanges = TFSContentRevision.create(this.project, context, localPath, serverChange.getIdAsInt(), serverChange.getDate()).getContent();
                    }
                }
                contentTriplet.baseContent = original != null ? original : "";
                contentTriplet.localContent = myLocalChanges != null ? myLocalChanges : "";
                contentTriplet.serverContent = serverChanges != null ? serverChanges : "";
            }
        }
        catch (Exception e) {
            logger.error("Error loading contents for files");
            throw new VcsException(TfPluginBundle.message("Tfvc.Conflict.Load.Failed", localPath.getPresentableUrl(), e.getMessage()));
        }
    }

    public void acceptChanges(@NotNull String conflict, ResolveConflictsCommand.AutoResolveType type) {
        if (type == ResolveConflictsCommand.AutoResolveType.TakeTheirs) {
            this.acceptTheirs(conflict);
        } else if (type == ResolveConflictsCommand.AutoResolveType.KeepYours) {
            this.acceptYours(conflict);
        }
    }

    public void acceptYours(@NotNull String conflict) {
        this.skip(conflict);
    }

    public void acceptTheirs(@NotNull String conflict) {
        if (this.updatedFiles != null) {
            this.updatedFiles.getGroupById("UPDATED").add(conflict, TFSVcs.getKey(), null);
        }
    }

    public void skip(@NotNull String conflict) {
        if (this.updatedFiles != null) {
            this.updatedFiles.getGroupById("SKIPPED").add(conflict, TFSVcs.getKey(), null);
        }
    }

    public void skip(@NotNull List<Conflict> conflicts) {
        for (Conflict conflict : conflicts) {
            this.skip(conflict.getLocalPath());
        }
    }

    public static boolean isNameConflict(@NotNull Conflict conflict) {
        return Conflict.ConflictType.RENAME.equals((Object)conflict.getType()) || Conflict.ConflictType.NAME_AND_CONTENT.equals((Object)conflict.getType()) || ResolveConflictHelper.isMergeConflict(conflict, ServerStatusType.RENAME);
    }

    public static boolean isContentConflict(@NotNull Conflict conflict) {
        return Conflict.ConflictType.CONTENT.equals((Object)conflict.getType()) || Conflict.ConflictType.NAME_AND_CONTENT.equals((Object)conflict.getType()) || ResolveConflictHelper.isMergeConflict(conflict, ServerStatusType.EDIT);
    }

    public static boolean isDeleteConflict(@NotNull Conflict conflict) {
        return Conflict.ConflictType.DELETE.equals((Object)conflict.getType()) || Conflict.ConflictType.DELETE_TARGET.equals((Object)conflict.getType()) || ResolveConflictHelper.isMergeConflict(conflict, ServerStatusType.DELETE) || ResolveConflictHelper.isMergeConflict(conflict, ServerStatusType.UNDELETE);
    }

    public static boolean isMergeConflict(@NotNull Conflict conflict, @Nullable ServerStatusType matchingChangeType) {
        if (Conflict.ConflictType.MERGE.equals((Object)conflict.getType())) {
            MergeConflict mergeConflict = (MergeConflict)conflict;
            if (matchingChangeType != null) {
                return mergeConflict.getMapping().getChangeTypes().contains(matchingChangeType);
            }
            return true;
        }
        return false;
    }

    public static int getMergeFromVersion(MergeConflict mergeConflict) {
        if (mergeConflict == null || mergeConflict.getMapping() == null || mergeConflict.getMapping().getFromServerItemVersion() == null || mergeConflict.getMapping().getFromServerItemVersion().getEnd().getType() != VersionSpec.Type.Changeset) {
            logger.warn("The merge conflict does not contain the correct From Version Range (End).");
            throw new IllegalArgumentException("mergeConflict");
        }
        return SystemHelper.toInt((String)mergeConflict.getMapping().getFromServerItemVersion().getEnd().getValue(), (int)0);
    }

    public void acceptChangeAsync(final List<Conflict> conflicts, final ResolveConflictsCommand.AutoResolveType type, final ResolveConflictsModel model) {
        logger.info(String.format("Accepting changes to %s for file %s", type.name(), Arrays.toString(conflicts.toArray())));
        Task.Backgroundable loadConflictsTask = new Task.Backgroundable(this.project, TfPluginBundle.message("Tfvc.Conflict.Resolving.ProgressBar", new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator progressIndicator) {
                ResolveConflictHelper.this.acceptChange(conflicts, progressIndicator, ResolveConflictHelper.this.project, type, model);
            }
        };
        loadConflictsTask.queue();
    }

    @VisibleForTesting
    protected void acceptChange(List<Conflict> conflicts, ProgressIndicator progressIndicator, Project project, ResolveConflictsCommand.AutoResolveType type, ResolveConflictsModel model) {
        for (Conflict conflict : conflicts) {
            try {
                progressIndicator.setText(TfPluginBundle.message("Tfvc.Conflict.Resolving.Status", conflict.getLocalPath()));
                List resolved = CommandUtils.resolveConflictsByConflict((ServerContext)TFSVcs.getInstance(project).getServerContext(false), Arrays.asList(conflict), (ResolveConflictsCommand.AutoResolveType)type);
                if (resolved != null && resolved.size() > 0) {
                    if (conflict instanceof RenameConflict && ResolveConflictsCommand.AutoResolveType.TakeTheirs.equals((Object)type)) {
                        this.acceptChanges(((RenameConflict)conflict).getServerPath(), type);
                        continue;
                    }
                    this.acceptChanges(conflict.getLocalPath(), type);
                    continue;
                }
                this.skip(Arrays.asList(conflict));
            }
            catch (Exception e) {
                logger.error("Error while handling merge resolution: " + e.getMessage());
                model.addError(ModelValidationInfo.createWithMessage(TfPluginBundle.message("Tfvc.Conflict.Merge.Error", conflict.getLocalPath(), e.getMessage())));
            }
        }
        IdeaHelper.setProgress(progressIndicator, 0.5, TfPluginBundle.message("Tfvc.Conflict.Resolving.Refresh", new Object[0]));
        try {
            this.findConflicts(model);
        }
        catch (VcsException e) {
            model.addError(ModelValidationInfo.createWithMessage(e.getMessage()));
        }
    }

    public void findConflicts(final ResolveConflictsModel model) throws VcsException {
        final ArrayList conflicts = new ArrayList();
        try {
            for (String updatePath : this.updateRoots) {
                conflicts.addAll(CommandUtils.getConflicts((ServerContext)TFSVcs.getInstance(this.project).getServerContext(false), (String)updatePath, (MergeResults)this.mergeResults));
            }
        }
        catch (Exception e) {
            logger.error("Error while finding conflicts: " + e.getMessage());
            throw new VcsException(TfPluginBundle.message("Tfvc.Conflict.Load.Error", new Object[0]));
        }
        Collections.sort(conflicts, new Comparator<Conflict>(){

            @Override
            public int compare(Conflict conflict1, Conflict conflict2) {
                return conflict1.getLocalPath().compareToIgnoreCase(conflict2.getLocalPath());
            }
        });
        IdeaHelper.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                model.getConflictsTableModel().setConflicts(conflicts);
            }
        });
    }
}

