/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core.tfs.operations;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.microsoft.alm.helpers.Path;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.PendingChange;
import com.microsoft.alm.plugin.external.models.ServerStatusType;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameFileDirectory {
    public static final Logger logger = LoggerFactory.getLogger(RenameFileDirectory.class);

    public static void execute(PsiElement element, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        try {
            VirtualFile virtualFile;
            if (element instanceof PsiFile) {
                logger.info("Renaming file...");
                virtualFile = ((PsiFile)element).getVirtualFile();
            } else if (element instanceof PsiDirectory) {
                logger.info("Renaming directory...");
                virtualFile = ((PsiDirectory)element).getVirtualFile();
            } else {
                logger.warn("RenameFile: failed to find proper object to rename: " + element.getClass());
                throw new IncorrectOperationException("Can't perform rename on objects other than files and directories");
            }
            String currentPath = virtualFile.getPath();
            String parentDirectory = virtualFile.getParent().getPath();
            String newPath = Path.combine((String)parentDirectory, (String)newName);
            Project project = element.getProject();
            ArrayList pendingChanges = new ArrayList(2);
            pendingChanges.addAll(CommandUtils.getStatusForFiles((ServerContext)TFSVcs.getInstance(project).getServerContext(true), (List)ImmutableList.of((Object)currentPath)));
            if (pendingChanges.size() == 1 && ((PendingChange)pendingChanges.get(0)).getChangeTypes().contains(ServerStatusType.ADD)) {
                logger.info("Renaming unversioned file thru file system");
                RenameUtil.doRenameGenericNamedElement((PsiElement)element, (String)newName, (UsageInfo[])usages, (RefactoringElementListener)listener);
            } else {
                logger.info("Renaming file thru tf commandline");
                CommandUtils.renameFile((ServerContext)TFSVcs.getInstance(project).getServerContext(true), (String)currentPath, (String)newPath);
                VFilePropertyChangeEvent event = new VFilePropertyChangeEvent((Object)element.getManager(), virtualFile, "name", (Object)currentPath, (Object)newName, false);
                PersistentFS.getInstance().processEvents(Collections.singletonList(event));
            }
        }
        catch (Throwable t) {
            logger.warn("renameElement experienced a failure while trying to rename a file", t);
            throw new IncorrectOperationException(t);
        }
        if (listener != null) {
            listener.elementRenamed(element);
        }
    }
}

