/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core.tfs.operations;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.PendingChange;
import com.microsoft.alm.plugin.external.models.ServerStatusType;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.ServerStatus;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.StatusProvider;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.StatusVisitor;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsFileUtil;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleForDeletion {
    public static final Logger logger = LoggerFactory.getLogger(ScheduleForDeletion.class);

    public static Collection<VcsException> execute(Project project, List<FilePath> files) {
        ArrayList<VcsException> errors = new ArrayList<VcsException>();
        ArrayList<String> filePaths = new ArrayList<String>(files.size());
        for (FilePath filePath : files) {
            filePaths.add(filePath.getPath());
        }
        try {
            ArrayList pendingChanges = new ArrayList();
            final ArrayList revert = new ArrayList();
            final HashSet<String> scheduleForDeletion = new HashSet<String>();
            ServerContext context = TFSVcs.getInstance(project).getServerContext(true);
            for (String path : filePaths) {
                List fileChanges = CommandUtils.getStatusForFiles((ServerContext)context, (List)ImmutableList.of((Object)path));
                if (fileChanges.isEmpty()) {
                    scheduleForDeletion.add(path);
                    continue;
                }
                pendingChanges.addAll(fileChanges);
            }
            for (final PendingChange pendingChange : pendingChanges) {
                StatusProvider.visitByStatus(new StatusVisitor(){

                    @Override
                    public void unversioned(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        if (pendingChange.getChangeTypes().contains(ServerStatusType.DELETE)) {
                            logger.info("ScheduleForDeletion: unversioned deleted file " + localPath.getPath());
                            scheduleForDeletion.add(StringUtils.isNotEmpty((String)pendingChange.getSourceItem()) ? pendingChange.getSourceItem() : pendingChange.getLocalItem());
                        } else {
                            logger.info("ScheduleForDeletion: do nothing for unversioned file " + localPath.getPath());
                        }
                    }

                    @Override
                    public void checkedOutForEdit(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        logger.info("ScheduleForDeletion: checkedOutForEdit file " + localPath.getPath());
                        revert.add(pendingChange.getLocalItem());
                        scheduleForDeletion.add(pendingChange.getLocalItem());
                    }

                    @Override
                    public void locked(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                    }

                    @Override
                    public void scheduledForAddition(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                        logger.info("ScheduleForDeletion: scheduledForAddition file " + localPath.getPath());
                        revert.add(pendingChange.getLocalItem());
                    }

                    @Override
                    public void scheduledForDeletion(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                        logger.warn("ScheduleForDeletion: " + localPath + " already is deleted");
                    }

                    @Override
                    public void renamed(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        logger.info("ScheduleForDeletion: renamed file " + localPath.getPath());
                        revert.add(pendingChange.getLocalItem());
                        scheduleForDeletion.add(pendingChange.getSourceItem());
                    }

                    @Override
                    public void renamedCheckedOut(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        logger.info("ScheduleForDeletion: renamedCheckedOut file " + localPath.getPath());
                        revert.add(pendingChange.getLocalItem());
                        scheduleForDeletion.add(pendingChange.getSourceItem());
                    }

                    @Override
                    public void undeleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        logger.info("ScheduleForDeletion: undeleted file " + localPath.getPath());
                        revert.add(pendingChange.getLocalItem());
                    }
                }, pendingChange);
            }
            if (!revert.isEmpty()) {
                CommandUtils.undoLocalFiles((ServerContext)context, revert);
            }
            ArrayList confirmedDeletedFiles = new ArrayList();
            if (!scheduleForDeletion.isEmpty()) {
                String workspace = !pendingChanges.isEmpty() ? ((PendingChange)pendingChanges.get(0)).getWorkspace() : "";
                confirmedDeletedFiles.addAll(CommandUtils.deleteFiles((ServerContext)context, new ArrayList(scheduleForDeletion), (String)workspace, (boolean)false));
            }
            for (FilePath expectedDeletedFile : files) {
                if (!confirmedDeletedFiles.contains(expectedDeletedFile.getPath())) continue;
                TfsFileUtil.markFileDirty(project, expectedDeletedFile);
            }
        }
        catch (Throwable t) {
            logger.warn("executeDelete experienced a failure while looking for altered files to delete", t);
            errors.add(TFSVcs.convertToVcsException(t));
        }
        return errors;
    }
}

